/*
 * Decompiled with CFR 0.152.
 */
package play.modules.yml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import org.hibernate.Hibernate;
import org.hibernate.proxy.HibernateProxy;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import play.Logger;
import play.Play;
import play.db.jpa.GenericModel;
import play.db.jpa.JPABase;
import play.db.jpa.Model;
import play.modules.yml.YmlExtractor;
import play.modules.yml.models.YmlObject;

public class YmlExtractorUtil {
    private static final String TAB = " ";

    public static void writeYml(String output, String filename) throws IOException {
        File file = new File(output + "/" + filename + ".yml");
        FileOutputStream fop = new FileOutputStream(file);
        fop.write("# Generated by logisima-play-yml (http://github.com/sim51/logisima-play-yml).\n".getBytes());
        fop.write("# This module is a part of LogiSima (http://www.logisima.com).\n".getBytes());
        Iterator<Map.Entry<String, YmlObject>> it = YmlExtractor.ymlObjects.entrySet().iterator();
        String tmp = "";
        while (it.hasNext()) {
            Map.Entry<String, YmlObject> object = it.next();
            YmlObject ymlObject = object.getValue();
            if (ymlObject.isAlreadyWrite().booleanValue()) continue;
            tmp = YmlExtractorUtil.writeObject2Yml(ymlObject, 0);
            fop.write(tmp.getBytes());
        }
        fop.flush();
        fop.close();
    }

    public static String writeObject2Yml(YmlObject object, int level) {
        ++level;
        String ymlText = "";
        if (!object.isAlreadyWrite().booleanValue()) {
            object.setAlreadyWrite(Boolean.TRUE);
            YmlExtractor.ymlObjects.put(object.getId(), object);
            if (object.getChildren().size() != 0) {
                for (int i = 0; i < object.getChildren().size(); ++i) {
                    ymlText = ymlText + YmlExtractorUtil.writeObject2Yml(YmlExtractor.ymlObjects.get(object.getChildren().get(i)), level);
                }
            }
            ymlText = ymlText + object.getYmlValue();
            ymlText = ymlText.replaceAll("!!models.*", "");
            ymlText = ymlText.replaceAll("[{]", "\\\\u007B");
            ymlText = ymlText.replaceAll("[}]", "\\\\u007D");
        }
        return ymlText;
    }

    public static YmlObject object2YmlObject(JPABase jpaBase) throws IllegalArgumentException, IllegalAccessException, ParseException, SecurityException, NoSuchMethodException, InvocationTargetException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        options.setCanonical(false);
        options.setAllowUnicode(true);
        Yaml yaml = new Yaml(options);
        YmlObject ymlObject = new YmlObject();
        ymlObject.setId(YmlExtractorUtil.getObjectId(jpaBase));
        String stringObject = "\n" + YmlExtractorUtil.getObjectClassName(jpaBase) + "(" + YmlExtractorUtil.getObjectId(jpaBase) + "):\n";
        Logger.info((String)("Generate YML for class id :" + YmlExtractorUtil.getObjectId(jpaBase) + " (" + jpaBase.getClass().getFields().length + " fields)"), (Object[])new Object[0]);
        if (jpaBase.getClass().getCanonicalName().contains("_$$_")) {
            Hibernate.initialize((Object)jpaBase);
            HibernateProxy proxy = (HibernateProxy)jpaBase;
            jpaBase = (JPABase)proxy.getHibernateLazyInitializer().getImplementation();
        }
        for (Field field : jpaBase.getClass().getFields()) {
            Map.Entry myObj;
            int i;
            String[] tmpValues;
            HashMap<String, Object> data = new HashMap<String, Object>();
            String name = field.getName();
            if (Modifier.isStatic(field.getModifiers()) || name.equals("id") || name.equals("willBeSaved") || YmlExtractorUtil.isFieldHasMappedByInAnnotation(field).booleanValue()) continue;
            Boolean valueIsSet = Boolean.FALSE;
            Logger.debug((String)("Generated field " + name), (Object[])new Object[0]);
            if (field.get(jpaBase) == null) continue;
            if (List.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field " + name + " type is List"), (Object[])new Object[0]);
                List myList = (List)field.get(jpaBase);
                if (!myList.isEmpty() && myList.size() > 0) {
                    tmpValues = new String[myList.size()];
                    for (int i2 = 0; i2 < myList.size(); ++i2) {
                        if (GenericModel.class.isInstance(myList.get(i2))) {
                            tmpValues[i2] = YmlExtractorUtil.getObjectId(myList.get(i2));
                            ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(myList.get(i2)));
                            continue;
                        }
                        tmpValues[i2] = myList.get(i2).toString();
                    }
                    data.put(name, tmpValues);
                }
                valueIsSet = Boolean.TRUE;
            }
            if (Map.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field " + name + " type is Map"), (Object[])new Object[0]);
                Map myMap = (Map)field.get(jpaBase);
                if (myMap != null && myMap.size() > 0) {
                    tmpValues = new String[myMap.size()];
                    Iterator it = myMap.entrySet().iterator();
                    i = 0;
                    while (it.hasNext()) {
                        myObj = it.next();
                        if (myObj != null && GenericModel.class.isInstance(myObj)) {
                            tmpValues[i] = YmlExtractorUtil.getObjectId(myObj);
                            if (YmlExtractorUtil.getObjectId(myObj) != null) {
                                ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(myObj));
                            }
                        } else {
                            tmpValues[i] = myObj.toString();
                        }
                        ++i;
                    }
                    data.put(name, tmpValues);
                }
                valueIsSet = Boolean.TRUE;
            }
            if (Set.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field " + name + " type is Set"), (Object[])new Object[0]);
                Set mySet = (Set)field.get(jpaBase);
                if (mySet != null && mySet.size() > 0) {
                    tmpValues = new String[mySet.size()];
                    Iterator it = mySet.iterator();
                    i = 0;
                    while (it.hasNext()) {
                        myObj = it.next();
                        if (myObj != null && GenericModel.class.isInstance(myObj)) {
                            tmpValues[i] = YmlExtractorUtil.getObjectId(myObj);
                            if (YmlExtractorUtil.getObjectId(myObj) != null) {
                                ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(myObj));
                            }
                        } else {
                            tmpValues[i] = myObj.toString();
                        }
                        ++i;
                    }
                    data.put(name, tmpValues);
                }
                valueIsSet = Boolean.TRUE;
            }
            if (field.isAnnotationPresent(Lob.class)) {
                Logger.debug((String)("Field " + name + " type is a Lob"), (Object[])new Object[0]);
                if (field.get(jpaBase) != null) {
                    data.put(name, field.get(jpaBase).toString());
                }
                valueIsSet = Boolean.TRUE;
            }
            if (jpaBase != null && GenericModel.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field " + name + " type is a Model"), (Object[])new Object[0]);
                ymlObject.getChildren().add(YmlExtractorUtil.getObjectId(field.get(jpaBase)));
                data.put(name, YmlExtractorUtil.getObjectId(field.get(jpaBase)));
                valueIsSet = Boolean.TRUE;
            }
            if (Date.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field " + name + " type is Date"), (Object[])new Object[0]);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (field.getAnnotation(Temporal.class) != null) {
                    Temporal temporal = field.getAnnotation(Temporal.class);
                    switch (temporal.value()) {
                        case DATE: {
                            sdf = new SimpleDateFormat("yyyy-MM-dd");
                            break;
                        }
                        case TIME: {
                            sdf = new SimpleDateFormat("hh:mm:ss");
                            break;
                        }
                        case TIMESTAMP: {
                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        }
                    }
                }
                Date myDate = sdf.parse(field.get(jpaBase).toString());
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                data.put(name, sd.format(myDate));
                valueIsSet = Boolean.TRUE;
            }
            if (Calendar.class.isInstance(field.get(jpaBase))) {
                Logger.debug((String)("Field " + name + " type is Calendar"), (Object[])new Object[0]);
                Calendar cal = (Calendar)field.get(jpaBase);
                Date date = cal.getTime();
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                data.put(name, sd.format(date));
                valueIsSet = Boolean.TRUE;
            }
            if (field.isAnnotationPresent(Embedded.class)) {
                Logger.debug((String)("Field " + name + " is an embedded"), (Object[])new Object[0]);
                data.put(field.getName(), field.get(jpaBase));
                valueIsSet = Boolean.TRUE;
            }
            if (!valueIsSet.booleanValue()) {
                Logger.debug((String)("Field " + name + " type is Basic"), (Object[])new Object[0]);
                String tmpValue = "" + field.get(jpaBase);
                data.put(name, tmpValue);
                valueIsSet = Boolean.TRUE;
            }
            if (!valueIsSet.booleanValue() || data.isEmpty()) continue;
            String value = yaml.dump(data).replaceAll("^", TAB);
            value = value.replaceAll("- ", " - ");
            stringObject = stringObject + value;
        }
        ymlObject.setYmlValue(stringObject);
        return ymlObject;
    }

    public static String getObjectClassName(Object object) {
        String classname = object.getClass().getName();
        if (classname.contains("_$$_")) {
            classname = classname.split("_")[0];
        }
        return classname;
    }

    public static String getObjectId(Object object) throws IllegalArgumentException, IllegalAccessException {
        JPABase jpaBase = (JPABase)object;
        String objectId = null;
        if (jpaBase != null && jpaBase instanceof Model) {
            Model myModel = (Model)jpaBase;
            objectId = YmlExtractorUtil.getObjectClassName(object);
            objectId = objectId.replaceAll("[.]", "_");
            objectId = objectId + "_";
            objectId = objectId + myModel.getId();
        } else {
            Field fieldId = null;
            for (Field field : jpaBase.getClass().getFields()) {
                if (field.getAnnotation(Id.class) == null) continue;
                fieldId = field;
            }
            if (fieldId != null) {
                objectId = YmlExtractorUtil.getObjectClassName(object);
                objectId = objectId.replaceAll("[.]", "_");
                objectId = objectId + "_";
                objectId = objectId + fieldId.get(jpaBase).toString();
            }
        }
        return objectId;
    }

    public static String getDefaultDialect(String driver) {
        if (driver != null && driver.equals("org.hsqldb.jdbcDriver")) {
            return "org.hibernate.dialect.HSQLDialect";
        }
        if (driver != null && driver.equals("com.mysql.jdbc.Driver")) {
            return "play.db.jpa.MySQLDialect";
        }
        String dialect = Play.configuration.getProperty("jpa.dialect");
        if (dialect != null) {
            return dialect;
        }
        throw new UnsupportedOperationException("I do not know which hibernate dialect to use with " + driver + ", use the property jpa.dialect in config file");
    }

    public static Boolean isFieldHasMappedByInAnnotation(Field field) {
        ManyToMany annotation;
        Boolean bool = Boolean.FALSE;
        if (field.isAnnotationPresent(ManyToMany.class) && !(annotation = field.getAnnotation(ManyToMany.class)).mappedBy().isEmpty()) {
            bool = Boolean.TRUE;
        }
        if (field.isAnnotationPresent(OneToMany.class) && !(annotation = field.getAnnotation(OneToMany.class)).mappedBy().isEmpty()) {
            bool = Boolean.TRUE;
        }
        return bool;
    }
}

