/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import jodd.db.oom.DbEntityDescriptor;
import jodd.db.type.SqlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbEntityColumnDescriptor
implements Comparable {
    protected final DbEntityDescriptor dbEntityDescriptor;
    protected final String columnName;
    protected final String propertyName;
    protected final Class propertyType;
    protected final boolean isId;
    protected final Class<? extends SqlType> sqlTypeClass;
    protected int dbSqlType = Integer.MAX_VALUE;

    public DbEntityColumnDescriptor(DbEntityDescriptor ded, String columnName, String fieldName, Class fieldType, boolean isId, Class<? extends SqlType> sqlTypeClass) {
        this.dbEntityDescriptor = ded;
        this.columnName = columnName;
        this.propertyName = fieldName;
        this.propertyType = fieldType;
        this.isId = isId;
        this.sqlTypeClass = sqlTypeClass;
    }

    public DbEntityDescriptor getDbEntityDescriptor() {
        return this.dbEntityDescriptor;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public boolean isId() {
        return this.isId;
    }

    public Class<? extends SqlType> getSqlTypeClass() {
        return this.sqlTypeClass;
    }

    public int getDbSqlType() {
        return this.dbSqlType;
    }

    public void updateDbSqlType(int dbSqlType) {
        if (dbSqlType == Integer.MAX_VALUE) {
            this.dbSqlType = dbSqlType;
        }
    }

    public int compareTo(Object o) {
        DbEntityColumnDescriptor that = (DbEntityColumnDescriptor)o;
        if (this.isId != that.isId) {
            return this.isId ? -1 : 1;
        }
        return this.columnName.compareTo(that.columnName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbEntityColumnDescriptor)) {
            return false;
        }
        DbEntityColumnDescriptor that = (DbEntityColumnDescriptor)o;
        return this.columnName.equals(that.columnName);
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    public String toString() {
        return "DbEntityColumnDescriptor{columnName='" + this.columnName + '\'' + ", propertyName='" + this.propertyName + '\'' + ", isId=" + this.isId + '}';
    }
}

