/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jodd.decora.Buffer;
import jodd.decora.ContentTypeHeaderResolver;
import jodd.decora.LastModifiedData;

public class BufferResponseWrapper
extends HttpServletResponseWrapper {
    protected static final String CONTENT_TYPE = "content-type";
    protected static final String CONTENT_LENGTH = "content-length";
    protected static final String LAST_MODIFIED = "last-modified";
    protected final LastModifiedData lastModifiedData;
    protected Buffer buffer;

    public BufferResponseWrapper(HttpServletResponse originalResponse, LastModifiedData lastModifiedData) {
        super(originalResponse);
        this.lastModifiedData = lastModifiedData;
        lastModifiedData.startNewResponse();
        this.enableBuffering();
    }

    protected void preResponseCommit() {
    }

    protected void enableBuffering() {
        if (this.buffer != null) {
            return;
        }
        this.buffer = new Buffer();
    }

    protected void disableBuffering() {
        if (this.buffer == null) {
            return;
        }
        this.buffer = null;
    }

    public boolean isBufferingEnabled() {
        return this.buffer != null;
    }

    public boolean isBufferStreamBased() {
        return this.buffer != null && this.buffer.isUsingStream();
    }

    public PrintWriter getWriter() throws IOException {
        this.preResponseCommit();
        if (this.buffer == null) {
            return this.getResponse().getWriter();
        }
        return this.buffer.getWriter();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.preResponseCommit();
        if (this.buffer == null) {
            return this.getResponse().getOutputStream();
        }
        return this.buffer.getOutputStream();
    }

    public char[] getBufferedChars() {
        if (this.buffer == null) {
            return null;
        }
        return this.buffer.toCharArray();
    }

    public byte[] getBufferedBytes() {
        if (this.buffer == null) {
            return null;
        }
        return this.buffer.toByteArray();
    }

    protected boolean bufferContentType(String contentType, String mimeType, String encoding) {
        return true;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        ContentTypeHeaderResolver resolver = new ContentTypeHeaderResolver(type);
        if (this.bufferContentType(type, resolver.getType(), resolver.getEncoding())) {
            this.enableBuffering();
        } else {
            this.disableBuffering();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.buffer == null) {
            super.flushBuffer();
        }
    }

    public void setContentLength(int contentLength) {
        if (this.buffer == null) {
            super.setContentLength(contentLength);
        }
    }

    public void setHeader(String name, String value) {
        String lowerName = name.toLowerCase();
        if (lowerName.equals(CONTENT_TYPE)) {
            this.setContentType(value);
        } else if (this.buffer == null || !lowerName.equals(CONTENT_LENGTH)) {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name.toLowerCase().equals(CONTENT_TYPE)) {
            this.setContentType(value);
        } else if (this.buffer == null || !name.toLowerCase().equals(CONTENT_LENGTH)) {
            super.addHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.buffer == null || !name.toLowerCase().equals(CONTENT_LENGTH)) {
            super.setIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (this.buffer == null || !name.toLowerCase().equals(CONTENT_LENGTH)) {
            super.addIntHeader(name, value);
        }
    }

    public void setDateHeader(String name, long value) {
        if (name.toLowerCase().equals(LAST_MODIFIED)) {
            this.lastModifiedData.updateLastModified(value);
        } else {
            super.setDateHeader(name, value);
        }
    }

    public void addDateHeader(String name, long value) {
        if (name.toLowerCase().equals(LAST_MODIFIED)) {
            this.lastModifiedData.updateLastModified(value);
        } else {
            super.addDateHeader(name, value);
        }
    }

    public void setStatus(int statusCode) {
        this.stopBufferingForStatusCode(statusCode);
        super.setStatus(statusCode);
    }

    public void setStatus(int statusCode, String reason) {
        this.stopBufferingForStatusCode(statusCode);
        super.setStatus(statusCode);
    }

    public void sendError(int statusCode) throws IOException {
        this.stopBufferingForStatusCode(statusCode);
        super.sendError(statusCode);
    }

    public void sendError(int statusCode, String reason) throws IOException {
        this.stopBufferingForStatusCode(statusCode);
        super.sendError(statusCode, reason);
    }

    public void sendRedirect(String location) throws IOException {
        this.stopBufferingForStatusCode(307);
        super.sendRedirect(location);
    }

    protected void stopBufferingForStatusCode(int statusCode) {
        if (!this.bufferStatusCode(statusCode)) {
            this.disableBuffering();
        }
    }

    protected boolean bufferStatusCode(int statusCode) {
        return statusCode == 200;
    }
}

