/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora;

import jodd.util.ArraysUtil;

public class ContentTypeHeaderResolver {
    private static final char[] TSPECIALS = " ;()[]<>:,=?@\"\\".toCharArray();
    private final String type;
    private final String encoding;

    public ContentTypeHeaderResolver(String fullContentType) {
        int charsetNdx = fullContentType.lastIndexOf("charset=");
        this.encoding = charsetNdx != -1 ? this.extractContentTypeValue(fullContentType, charsetNdx + 8) : null;
        this.type = this.extractContentTypeValue(fullContentType, 0);
    }

    private String extractContentTypeValue(String type, int startIndex) {
        int endIndex;
        while (startIndex < type.length() && type.charAt(startIndex) == ' ') {
            ++startIndex;
        }
        if (startIndex >= type.length()) {
            return null;
        }
        if (type.charAt(startIndex) == '\"') {
            if ((endIndex = type.indexOf(34, ++startIndex)) == -1) {
                endIndex = type.length();
            }
        } else {
            for (endIndex = startIndex; endIndex < type.length() && !ArraysUtil.contains((char[])TSPECIALS, (char)type.charAt(endIndex)); ++endIndex) {
            }
        }
        return type.substring(startIndex, endIndex);
    }

    public String getType() {
        return this.type;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

