/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.csselly;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.List;
import jodd.io.CharBufferReader;
import jodd.lagarto.csselly.CSSellyException;
import jodd.lagarto.csselly.CSSellyLexer;
import jodd.lagarto.csselly.Combinator;
import jodd.lagarto.csselly.CssSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSelly {
    protected final CSSellyLexer lexer;

    public CSSelly(CharSequence charSequence) {
        this(CharBuffer.wrap(charSequence));
    }

    public CSSelly(CharBuffer input) {
        this.lexer = new CSSellyLexer((Reader)new CharBufferReader(input));
    }

    public List<CssSelector> parse() {
        try {
            this.lexer.yylex();
            if (this.lexer.selectors.isEmpty()) {
                return null;
            }
            CssSelector last = this.lexer.selectors.getLast();
            if (last.getCombinator() == Combinator.DESCENDANT) {
                this.lexer.selectors.getLast().setCombinator(null);
            }
            CssSelector prevCssSelector = null;
            for (CssSelector cssSelector : this.lexer.selectors) {
                if (prevCssSelector != null) {
                    cssSelector.setPrevCssSelector(prevCssSelector);
                }
                prevCssSelector = cssSelector;
            }
            return this.lexer.selectors;
        }
        catch (IOException ioex) {
            throw new CSSellyException(ioex);
        }
    }

    public static String toString(List<CssSelector> selectors) {
        StringBuilder out = new StringBuilder();
        for (CssSelector s : selectors) {
            out.append(s.toString());
        }
        return out.toString();
    }
}

