/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.csselly.selector;

import java.util.LinkedList;
import jodd.lagarto.csselly.selector.PseudoFunctionExpression;
import jodd.lagarto.dom.Node;
import jodd.typeconverter.Convert;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PseudoFunction<E> {
    public abstract E parseExpression(String var1);

    public abstract boolean match(Node var1, E var2);

    public boolean match(LinkedList<Node> currentResults, Node node, int index, E expression) {
        return true;
    }

    public String getPseudoFunctionName() {
        String name = this.getClass().getSimpleName().toLowerCase();
        name = name.replace('_', '-');
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CONTAINS
    extends PseudoFunction<String> {
        @Override
        public String parseExpression(String expression) {
            if (StringUtil.startsWithChar((String)expression, (char)'\'') || StringUtil.startsWithChar((String)expression, (char)'\"')) {
                expression = expression.substring(1, expression.length() - 1);
            }
            return expression;
        }

        @Override
        public boolean match(Node node, String expression) {
            String text = node.getTextContent();
            return text.contains(expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LT
    extends PseudoFunction<Integer> {
        @Override
        public Integer parseExpression(String expression) {
            return Convert.toInteger((Object)expression, null);
        }

        @Override
        public boolean match(Node node, Integer expression) {
            return true;
        }

        @Override
        public boolean match(LinkedList<Node> currentResults, Node node, int index, Integer expression) {
            int value = expression;
            return index < value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GT
    extends PseudoFunction<Integer> {
        @Override
        public Integer parseExpression(String expression) {
            return Convert.toInteger((Object)expression, null);
        }

        @Override
        public boolean match(Node node, Integer expression) {
            return true;
        }

        @Override
        public boolean match(LinkedList<Node> currentResults, Node node, int index, Integer expression) {
            int value = expression;
            return index > value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EQ
    extends PseudoFunction<Integer> {
        @Override
        public Integer parseExpression(String expression) {
            return Convert.toInteger((Object)expression, null);
        }

        @Override
        public boolean match(Node node, Integer expression) {
            return true;
        }

        @Override
        public boolean match(LinkedList<Node> currentResults, Node node, int index, Integer expression) {
            int value = expression;
            if (value >= 0) {
                return index == value;
            }
            return index == currentResults.size() + value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NTH_LAST_OF_TYPE
    extends PseudoFunction<PseudoFunctionExpression> {
        @Override
        public PseudoFunctionExpression parseExpression(String expression) {
            return new PseudoFunctionExpression(expression);
        }

        @Override
        public boolean match(Node node, PseudoFunctionExpression expression) {
            Node child = node.getParentNode().getLastChildElement(node.getNodeName());
            int value = child.getSiblingNameIndex() + 1 - node.getSiblingNameIndex();
            return expression.match(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NTH_OF_TYPE
    extends PseudoFunction<PseudoFunctionExpression> {
        @Override
        public PseudoFunctionExpression parseExpression(String expression) {
            return new PseudoFunctionExpression(expression);
        }

        @Override
        public boolean match(Node node, PseudoFunctionExpression expression) {
            int value = node.getSiblingNameIndex() + 1;
            return expression.match(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NTH_LAST_CHILD
    extends PseudoFunction<PseudoFunctionExpression> {
        @Override
        public PseudoFunctionExpression parseExpression(String expression) {
            return new PseudoFunctionExpression(expression);
        }

        @Override
        public boolean match(Node node, PseudoFunctionExpression expression) {
            int value = node.getParentNode().getChildElementsCount() - node.getSiblingElementIndex();
            return expression.match(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NTH_CHILD
    extends PseudoFunction<PseudoFunctionExpression> {
        @Override
        public PseudoFunctionExpression parseExpression(String expression) {
            return new PseudoFunctionExpression(expression);
        }

        @Override
        public boolean match(Node node, PseudoFunctionExpression expression) {
            int value = node.getSiblingElementIndex() + 1;
            return expression.match(value);
        }
    }
}

