/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.io.IOException;
import jodd.lagarto.Tag;
import jodd.lagarto.dom.Attribute;
import jodd.lagarto.dom.Node;

public class Element
extends Node {
    protected boolean forceCloseTag;

    public Element(Tag tag, boolean caseSensitive) {
        super(Node.NodeType.ELEMENT, tag.getName(), caseSensitive);
        int attrCount = tag.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String key = tag.getAttributeName(i);
            String value = tag.getAttributeValue(i);
            this.setAttribute(key, value);
        }
    }

    public Element(String name) {
        this(name, false);
    }

    public Element(String name, boolean caseSensitive) {
        super(Node.NodeType.ELEMENT, name, caseSensitive);
    }

    public Element clone() {
        return this.cloneTo(new Element(this.nodeName, this.caseSensitive));
    }

    public void toHtml(Appendable appendable) throws IOException {
        int childCount;
        appendable.append('<');
        appendable.append(this.nodeName);
        int attrCount = this.getAttributesCount();
        if (attrCount != 0) {
            for (int i = 0; i < attrCount; ++i) {
                Attribute attr = this.getAttribute(i);
                appendable.append(' ');
                attr.toHtml(appendable);
            }
        }
        if ((childCount = this.getChildNodesCount()) == 0 && !this.forceCloseTag) {
            appendable.append("/>");
        } else {
            appendable.append('>');
            if (childCount != 0) {
                this.toInnerHtml(appendable);
            }
            appendable.append("</");
            appendable.append(this.nodeName);
            appendable.append('>');
        }
    }
}

