/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocUtil;
import jodd.util.ArraysUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionConfigSet
implements Comparable<ActionConfigSet> {
    protected ActionConfig[] configs = new ActionConfig[0];
    public final String actionPath;
    public final String[] actionPathChunks;
    public final PathMacro[] actionPathMacros;

    public ActionConfigSet(String actionPath) {
        this.actionPath = actionPath;
        this.actionPathChunks = MadvocUtil.splitActionPath(actionPath);
        this.actionPathMacros = this.resolveMacros(this.actionPathChunks);
    }

    public List<ActionConfig> getActionConfigs() {
        ArrayList<ActionConfig> list = new ArrayList<ActionConfig>(this.configs.length);
        for (ActionConfig config : this.configs) {
            list.add(config);
        }
        return list;
    }

    public boolean add(ActionConfig cfg) {
        if (!cfg.actionPath.equals(this.actionPath)) {
            throw new MadvocException("Invalid configuration.");
        }
        cfg.actionConfigSet = this;
        int ndx = this.lookupIndex(cfg.actionMethod);
        if (ndx == -1) {
            this.configs = cfg.actionMethod == null ? (ActionConfig[])ArraysUtil.append((Object[])this.configs, (Object)cfg) : (ActionConfig[])ArraysUtil.insert((Object[])this.configs, (Object)cfg, (int)0);
            return false;
        }
        this.configs[ndx] = cfg;
        return true;
    }

    public ActionConfig lookup(String method) {
        int ndx = this.lookupIndex(method);
        if (ndx == -1) {
            return null;
        }
        return this.configs[ndx];
    }

    protected int lookupIndex(String method) {
        for (int i = 0; i < this.configs.length; ++i) {
            ActionConfig config = this.configs[i];
            if (config.actionMethod == null) {
                return i;
            }
            if (!config.actionMethod.equals(method)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int compareTo(ActionConfigSet set) {
        return this.actionPath.compareTo(set.actionPath);
    }

    protected PathMacro[] resolveMacros(String[] chunks) {
        ArrayList<PathMacro> list = new ArrayList<PathMacro>(chunks.length);
        for (int i = 0; i < chunks.length; ++i) {
            String chunk = chunks[i];
            int[] ndx = StringUtil.indexOfRegion((String)chunk, (String)"${", (String)"}");
            if (ndx == null) continue;
            PathMacro macro = new PathMacro();
            String name = chunk.substring(ndx[1], ndx[2]);
            int colonNdx = name.indexOf(58);
            if (colonNdx != -1) {
                String pattern = name.substring(colonNdx + 1);
                macro.pattern = Pattern.compile(pattern);
                name = name.substring(0, colonNdx);
            }
            macro.name = name;
            macro.ndx = i;
            macro.left = ndx[0] == 0 ? "" : chunk.substring(0, ndx[0]);
            macro.right = ndx[3] == chunk.length() ? "" : chunk.substring(ndx[3]);
            list.add(macro);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new PathMacro[list.size()]);
    }

    public static class PathMacro {
        public int ndx;
        public String name;
        public String left;
        public String right;
        public Pattern pattern;
    }
}

