/*
 * Decompiled with CFR 0.152.
 */
package play.modules.search.store;

import java.util.Collection;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import play.Logger;
import play.data.binding.Binder;
import play.db.jpa.Blob;
import play.db.jpa.JPABase;
import play.db.jpa.Model;
import play.exceptions.UnexpectedException;
import play.modules.search.Field;
import play.modules.search.Indexed;
import play.modules.search.store.FileExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertionUtils {
    public static Document toDocument(Object object) throws Exception {
        Indexed indexed = object.getClass().getAnnotation(Indexed.class);
        if (indexed == null) {
            return null;
        }
        if (!(object instanceof JPABase)) {
            return null;
        }
        JPABase jpaBase = (JPABase)object;
        Document document = new Document();
        document.add((Fieldable)new org.apache.lucene.document.Field("_docID", ConvertionUtils.getIdValueFor(jpaBase) + "", Field.Store.YES, Field.Index.NOT_ANALYZED));
        StringBuffer allValue = new StringBuffer();
        for (java.lang.reflect.Field field : object.getClass().getFields()) {
            Field index = field.getAnnotation(Field.class);
            if (index == null || field.getType().isArray() || Collection.class.isAssignableFrom(field.getType())) continue;
            String name = field.getName();
            String value = null;
            if (JPABase.class.isAssignableFrom(field.getType()) && index.joinField().length() != 0) {
                JPABase joinObject = (JPABase)field.get(object);
                for (java.lang.reflect.Field joinField : joinObject.getClass().getFields()) {
                    if (!joinField.getName().equals(index.joinField())) continue;
                    name = joinField.getName();
                    value = ConvertionUtils.valueOf(joinObject, joinField);
                }
            } else {
                value = ConvertionUtils.valueOf(object, field);
            }
            if (value == null) continue;
            document.add((Fieldable)new org.apache.lucene.document.Field(name, value, index.stored() ? Field.Store.YES : Field.Store.NO, index.tokenize() ? Field.Index.ANALYZED : Field.Index.NOT_ANALYZED));
            if (index.tokenize() && index.sortable()) {
                document.add((Fieldable)new org.apache.lucene.document.Field(name + "_untokenized", value, index.stored() ? Field.Store.YES : Field.Store.NO, Field.Index.NOT_ANALYZED));
            }
            allValue.append(value).append(' ');
        }
        document.add((Fieldable)new org.apache.lucene.document.Field("allfield", allValue.toString(), Field.Store.NO, Field.Index.ANALYZED));
        return document;
    }

    public static String valueOf(Object object, java.lang.reflect.Field field) throws Exception {
        if (field.getType().equals(String.class)) {
            return (String)field.get(object);
        }
        if (field.getType().equals(Blob.class) && field.get(object) != null) {
            return FileExtractor.getText((Blob)field.get(object));
        }
        Object o = field.get(object);
        if (field.isAnnotationPresent(ManyToOne.class) && o instanceof JPABase) {
            return "" + ConvertionUtils.getIdValueFor((JPABase)o);
        }
        return "" + field.get(object);
    }

    public static Object getIdValueFromIndex(Class<?> clazz, String indexValue) {
        java.lang.reflect.Field field = ConvertionUtils.getIdField(clazz);
        Class<?> parameter = field.getType();
        try {
            return Binder.directBind((String)indexValue, parameter);
        }
        catch (Exception e) {
            throw new UnexpectedException("Could not convert the ID from index to corresponding type", (Throwable)e);
        }
    }

    public static java.lang.reflect.Field getIdField(Class<?> clazz) {
        for (java.lang.reflect.Field field : clazz.getFields()) {
            if (field.getAnnotation(Id.class) == null) continue;
            return field;
        }
        throw new RuntimeException("Your class " + clazz.getName() + " is annotated with javax.persistence.Id but the field Id was not found");
    }

    public static Object getIdValueFor(JPABase jpaBase) {
        if (jpaBase instanceof Model) {
            return ((Model)jpaBase).id;
        }
        java.lang.reflect.Field field = ConvertionUtils.getIdField(jpaBase.getClass());
        Object val = null;
        try {
            val = field.get(jpaBase);
        }
        catch (IllegalAccessException e) {
            Logger.error((String)("Unable to read the field value of a field annotated with @Id " + field.getName() + " due to " + e.getMessage()), (Object[])new Object[]{e});
        }
        return val;
    }

    public static boolean isForcedUntokenized(Class<?> clazz, String fieldName) {
        try {
            java.lang.reflect.Field field = clazz.getField(fieldName);
            Field index = field.getAnnotation(Field.class);
            return index.tokenize() && index.sortable();
        }
        catch (Exception e) {
            Logger.error((String)"%s", (Object[])new Object[]{e.getCause()});
            return false;
        }
    }
}

