/*
 * Decompiled with CFR 0.152.
 */
package play.modules.search.store;

import java.util.ArrayList;
import java.util.List;
import play.Logger;
import play.Play;
import play.classloading.ApplicationClasses;
import play.db.jpa.Blob;
import play.modules.search.store.extractors.TextExtractor;
import play.modules.search.store.mime.ExtensionGuesser;
import play.modules.search.store.mime.MimeGuesser;

public class FileExtractor {
    public static List<TextExtractor> extractors = new ArrayList<TextExtractor>();
    public static MimeGuesser mimeGuesser = new ExtensionGuesser();

    public static void init() {
        Logger.debug((String)"init FileExtractor", (Object[])new Object[0]);
        List classes = Play.classes.getAssignableClasses(TextExtractor.class);
        ArrayList<TextExtractor> extractors = new ArrayList<TextExtractor>();
        for (ApplicationClasses.ApplicationClass applicationClass : classes) {
            try {
                Logger.trace((String)"adding %s as a TextExtractor", (Object[])new Object[]{applicationClass.name});
                extractors.add((TextExtractor)applicationClass.javaClass.newInstance());
            }
            catch (Exception e) {
                Logger.warn((Throwable)e, (String)"Could not instanciate text extractor %s", (Object[])new Object[]{applicationClass.javaClass.getName()});
            }
        }
        FileExtractor.extractors = extractors;
    }

    public static String getText(Blob blob) {
        String mime = mimeGuesser.guess(blob);
        String fileName = blob.getFile().getName();
        for (TextExtractor extractor : extractors) {
            if (!extractor.handles(mime)) continue;
            Logger.debug((String)"Using %s extractor to handle blob %s, mime=%s", (Object[])new Object[]{extractor.getClass().getName(), fileName, blob.type()});
            return extractor.extract(blob);
        }
        Logger.warn((String)"No handlers able to index %s mime type, file was %s", (Object[])new Object[]{mime, fileName});
        return null;
    }
}

