/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.plus;

import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.services.plus.PlusRequest;
import com.google.api.services.plus.model.Activity;
import com.google.api.services.plus.model.ActivityFeed;
import com.google.api.services.plus.model.Comment;
import com.google.api.services.plus.model.CommentFeed;
import com.google.api.services.plus.model.PeopleFeed;
import com.google.api.services.plus.model.Person;
import java.io.IOException;

public class Plus
extends GoogleClient {
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/plus/v1/";
    @Deprecated
    private String applicationName;
    @Deprecated
    private String baseServer = "https://www.googleapis.com";
    @Deprecated
    private String basePath = "/plus/v1/";
    @Key
    private Boolean prettyPrint;
    @Key
    private String fields;
    @Key
    private String quotaUser;
    @Key
    private String oauthToken;
    @Key
    private String key;
    @Key
    private String userIp;
    @Key
    private String alt;
    @Deprecated
    public final Activities activities = new Activities();
    @Deprecated
    public final Comments comments = new Comments();
    @Deprecated
    public final People people = new People();

    @Deprecated
    public Plus(HttpTransport transport, HttpRequestInitializer requestInitializer, JsonFactory jsonFactory) {
        super(transport, new PlusRequestInitializer(), requestInitializer, jsonFactory, DEFAULT_BASE_URL, null);
        ((PlusRequestInitializer)this.getJsonHttpRequestInitializer()).setPlus(this);
    }

    public Plus(HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
    }

    @Deprecated
    public Plus(String appName, HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
        this.setApplicationName(appName);
    }

    @Deprecated
    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    @Deprecated
    public Plus setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    @Deprecated
    public String getFields() {
        return this.fields;
    }

    @Deprecated
    public Plus setFields(String fields) {
        this.fields = fields;
        return this;
    }

    @Deprecated
    public String getQuotaUser() {
        return this.quotaUser;
    }

    @Deprecated
    public Plus setQuotaUser(String quotaUser) {
        this.quotaUser = quotaUser;
        return this;
    }

    @Deprecated
    public String getOauthToken() {
        return this.oauthToken;
    }

    @Deprecated
    public Plus setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return this;
    }

    @Deprecated
    public String getKey() {
        return this.key;
    }

    @Deprecated
    public Plus setKey(String key) {
        this.key = key;
        return this;
    }

    @Deprecated
    public String getUserIp() {
        return this.userIp;
    }

    @Deprecated
    public Plus setUserIp(String userIp) {
        this.userIp = userIp;
        return this;
    }

    @Deprecated
    public String getAlt() {
        return this.alt;
    }

    @Deprecated
    public Plus setAlt(String alt) {
        this.alt = alt;
        return this;
    }

    Plus(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, String baseUrl, String applicationName) {
        super(transport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, baseUrl, applicationName);
    }

    @Deprecated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        if (this.applicationName == null) {
            return super.getApplicationName();
        }
        return this.applicationName;
    }

    public String getBaseUrl() {
        String baseUrl = this.getBaseServer() + this.getBasePath();
        if (DEFAULT_BASE_URL.equals(baseUrl)) {
            return super.getBaseUrl();
        }
        return baseUrl;
    }

    @Deprecated
    public void setBaseServer(String baseServer) {
        this.baseServer = baseServer;
    }

    @Deprecated
    public String getBaseServer() {
        return this.baseServer;
    }

    @Deprecated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Deprecated
    public String getBasePath() {
        return this.basePath;
    }

    public static Builder builder(HttpTransport transport, JsonFactory jsonFactory) {
        return new Builder(transport, jsonFactory);
    }

    public Activities activities() {
        return new Activities();
    }

    public Comments comments() {
        return new Comments();
    }

    public People people() {
        return new People();
    }

    public static final class Builder
    extends GoogleClient.Builder {
        Builder(HttpTransport transport, JsonFactory jsonFactory) {
            super(transport, jsonFactory, new GenericUrl(Plus.DEFAULT_BASE_URL));
        }

        public Plus build() {
            return new Plus(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getBaseUrl().build(), this.getApplicationName());
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
            return this;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            super.setHttpRequestInitializer(httpRequestInitializer);
            return this;
        }

        public Builder setApplicationName(String applicationName) {
            super.setApplicationName(applicationName);
            return this;
        }
    }

    public class People {
        public ListByActivity listByActivity(String activityId, String collection) throws IOException {
            ListByActivity result = new ListByActivity(activityId, collection);
            Plus.this.initialize(result);
            return result;
        }

        public Search search() throws IOException {
            Search result = new Search();
            Plus.this.initialize(result);
            return result;
        }

        public Get get(String userId) throws IOException {
            Get result = new Get(userId);
            Plus.this.initialize(result);
            return result;
        }

        public class Get
        extends PlusRequest {
            private static final String REST_PATH = "people/{userId}";
            @Key(value="userId")
            private String userId;

            private Get(String userId) {
                super(Plus.this, HttpMethod.GET, REST_PATH, null);
                this.userId = userId;
            }

            public Person execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Person result = (Person)((Object)response.parseAs(Person.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getUserId() {
                return this.userId;
            }

            public Get setUserId(String userId) {
                this.userId = userId;
                return this;
            }
        }

        public class Search
        extends PlusRequest {
            private static final String REST_PATH = "people";
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;
            @Key(value="query")
            private String query;

            private Search() {
                super(Plus.this, HttpMethod.GET, REST_PATH, null);
            }

            public PeopleFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                PeopleFeed result = (PeopleFeed)((Object)response.parseAs(PeopleFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }
        }

        public class ListByActivity
        extends PlusRequest {
            private static final String REST_PATH = "activities/{activityId}/people/{collection}";
            @Key(value="activityId")
            private String activityId;
            @Key(value="collection")
            private String collection;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;

            private ListByActivity(String activityId, String collection) {
                super(Plus.this, HttpMethod.GET, REST_PATH, null);
                this.activityId = activityId;
                this.collection = collection;
            }

            public PeopleFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                PeopleFeed result = (PeopleFeed)((Object)response.parseAs(PeopleFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getActivityId() {
                return this.activityId;
            }

            public ListByActivity setActivityId(String activityId) {
                this.activityId = activityId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public ListByActivity setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListByActivity setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListByActivity setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }
        }
    }

    public class Comments {
        public List list(String activityId) throws IOException {
            List result = new List(activityId);
            Plus.this.initialize(result);
            return result;
        }

        public Get get(String commentId) throws IOException {
            Get result = new Get(commentId);
            Plus.this.initialize(result);
            return result;
        }

        public class Get
        extends PlusRequest {
            private static final String REST_PATH = "comments/{commentId}";
            @Key(value="commentId")
            private String commentId;

            private Get(String commentId) {
                super(Plus.this, HttpMethod.GET, REST_PATH, null);
                this.commentId = commentId;
            }

            public Comment execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Comment result = (Comment)((Object)response.parseAs(Comment.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String commentId) {
                this.commentId = commentId;
                return this;
            }
        }

        public class List
        extends PlusRequest {
            private static final String REST_PATH = "activities/{activityId}/comments";
            @Key(value="activityId")
            private String activityId;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;

            private List(String activityId) {
                super(Plus.this, HttpMethod.GET, REST_PATH, null);
                this.activityId = activityId;
            }

            public CommentFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                CommentFeed result = (CommentFeed)((Object)response.parseAs(CommentFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getActivityId() {
                return this.activityId;
            }

            public List setActivityId(String activityId) {
                this.activityId = activityId;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }
        }
    }

    public class Activities {
        public Search search() throws IOException {
            Search result = new Search();
            Plus.this.initialize(result);
            return result;
        }

        public List list(String userId, String collection) throws IOException {
            List result = new List(userId, collection);
            Plus.this.initialize(result);
            return result;
        }

        public Get get(String activityId) throws IOException {
            Get result = new Get(activityId);
            Plus.this.initialize(result);
            return result;
        }

        public class Get
        extends PlusRequest {
            private static final String REST_PATH = "activities/{activityId}";
            @Key(value="activityId")
            private String activityId;

            private Get(String activityId) {
                super(Plus.this, HttpMethod.GET, REST_PATH, null);
                this.activityId = activityId;
            }

            public Activity execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Activity result = (Activity)((Object)response.parseAs(Activity.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getActivityId() {
                return this.activityId;
            }

            public Get setActivityId(String activityId) {
                this.activityId = activityId;
                return this;
            }
        }

        public class List
        extends PlusRequest {
            private static final String REST_PATH = "people/{userId}/activities/{collection}";
            @Key(value="userId")
            private String userId;
            @Key(value="collection")
            private String collection;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;

            private List(String userId, String collection) {
                super(Plus.this, HttpMethod.GET, REST_PATH, null);
                this.userId = userId;
                this.collection = collection;
            }

            public ActivityFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                ActivityFeed result = (ActivityFeed)((Object)response.parseAs(ActivityFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getUserId() {
                return this.userId;
            }

            public List setUserId(String userId) {
                this.userId = userId;
                return this;
            }

            public String getCollection() {
                return this.collection;
            }

            public List setCollection(String collection) {
                this.collection = collection;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }
        }

        public class Search
        extends PlusRequest {
            private static final String REST_PATH = "activities";
            @Key(value="orderBy")
            private String orderBy;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="maxResults")
            private Long maxResults;
            @Key(value="query")
            private String query;

            private Search() {
                super(Plus.this, HttpMethod.GET, REST_PATH, null);
            }

            public ActivityFeed execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                ActivityFeed result = (ActivityFeed)((Object)response.parseAs(ActivityFeed.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public Search setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Search setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Search setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public Search setQuery(String query) {
                this.query = query;
                return this;
            }
        }
    }

    private static class PlusRequestInitializer
    implements JsonHttpRequestInitializer {
        private Plus plus;

        private PlusRequestInitializer() {
        }

        void setPlus(Plus plus) {
            this.plus = plus;
        }

        public void initialize(JsonHttpRequest jsonHttpRequest) {
            PlusRequest request = (PlusRequest)jsonHttpRequest;
            request.setPrettyPrint(this.plus.getPrettyPrint());
            request.setFields(this.plus.getFields());
            request.setQuotaUser(this.plus.getQuotaUser());
            request.setOauthToken(this.plus.getOauthToken());
            request.setKey(this.plus.getKey());
            request.setUserIp(this.plus.getUserIp());
            request.setAlt(this.plus.getAlt());
        }
    }
}

