/*
 * Decompiled with CFR 0.152.
 */
package org.tautua.markdownpapers.util;

import java.util.HashMap;
import java.util.Map;

public final class Utils {
    public static final char TAB = '\t';
    public static final char EOL = '\n';
    public static final char SPACE = ' ';
    public static final char QUOTE = '\"';
    public static final char AMPERSAND = '&';
    public static final char LT = '<';
    public static final char GT = '>';
    public static final String EMPTY_STRING = "";
    private static final Map<Character, String> ESCAPED_CHARS = new HashMap<Character, String>();

    public static String escape(char character) {
        String escaped = ESCAPED_CHARS.get(Character.valueOf(character));
        return escaped == null ? String.valueOf(character) : escaped;
    }

    public static boolean isBlank(String val) {
        return val == null || val.trim().equals(EMPTY_STRING);
    }

    static {
        ESCAPED_CHARS.put(Character.valueOf('&'), "&amp;");
        ESCAPED_CHARS.put(Character.valueOf('<'), "&lt;");
        ESCAPED_CHARS.put(Character.valueOf('>'), "&gt;");
        ESCAPED_CHARS.put(Character.valueOf('\"'), "&quot;");
    }
}

