/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractInputStreamContent
implements HttpContent {
    private static final int BUFFER_SIZE = 2048;
    private String type;
    private String encoding;

    public AbstractInputStreamContent(String type) {
        this.setType(type);
    }

    protected abstract InputStream getInputStream() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        InputStream inputStream = this.getInputStream();
        long contentLength = this.getLength();
        if (contentLength < 0L) {
            AbstractInputStreamContent.copy(inputStream, out);
        } else {
            byte[] buffer = new byte[2048];
            try {
                int read;
                for (long remaining = contentLength; remaining > 0L; remaining -= (long)read) {
                    read = inputStream.read(buffer, 0, (int)Math.min(2048L, remaining));
                    if (read == -1) {
                        break;
                    }
                    out.write(buffer, 0, read);
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getType() {
        return this.type;
    }

    public AbstractInputStreamContent setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public AbstractInputStreamContent setType(String type) {
        this.type = type;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int bytesRead;
            byte[] tmp = new byte[2048];
            while ((bytesRead = inputStream.read(tmp)) != -1) {
                outputStream.write(tmp, 0, bytesRead);
            }
        }
        finally {
            inputStream.close();
        }
    }
}

