/*
 * Decompiled with CFR 0.152.
 */
package compat16.org.mozilla.javascript;

import compat16.org.mozilla.javascript.FunctionNode;
import compat16.org.mozilla.javascript.Kit;
import compat16.org.mozilla.javascript.Node;
import compat16.org.mozilla.javascript.ObjArray;
import compat16.org.mozilla.javascript.ScriptOrFnNode;

public class NodeTransformer {
    private ObjArray loops;
    private ObjArray loopEnds;
    private boolean hasFinally;

    public final void transform(ScriptOrFnNode tree) {
        this.transformCompilationUnit(tree);
        for (int i = 0; i != tree.getFunctionCount(); ++i) {
            FunctionNode fn = tree.getFunctionNode(i);
            this.transform(fn);
        }
    }

    private void transformCompilationUnit(ScriptOrFnNode tree) {
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        this.hasFinally = false;
        this.transformCompilationUnit_r(tree, tree);
    }

    private void transformCompilationUnit_r(ScriptOrFnNode tree, Node parent) {
        Node node = null;
        block12: while (true) {
            Node previous = null;
            if (node == null) {
                node = parent.getFirstChild();
            } else {
                previous = node;
                node = node.getNext();
            }
            if (node == null) break;
            int type = node.getType();
            switch (type) {
                case 110: 
                case 126: 
                case 128: {
                    this.loops.push(node);
                    this.loopEnds.push(((Node.Jump)node).target);
                    break;
                }
                case 119: {
                    this.loops.push(node);
                    Node leave = node.getNext();
                    if (leave.getType() != 3) {
                        Kit.codeBug();
                    }
                    this.loopEnds.push(leave);
                    break;
                }
                case 77: {
                    Node.Jump jump = (Node.Jump)node;
                    Node finallytarget = jump.getFinally();
                    if (finallytarget == null) break;
                    this.hasFinally = true;
                    this.loops.push(node);
                    this.loopEnds.push(finallytarget);
                    break;
                }
                case 3: 
                case 127: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 4: {
                    if (!this.hasFinally) break;
                    Node unwindBlock = null;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node unwind;
                        Node n = (Node)this.loops.get(i);
                        int elemtype = n.getType();
                        if (elemtype != 77 && elemtype != 119) continue;
                        if (elemtype == 77) {
                            Node jsrtarget;
                            Node.Jump jsrnode = new Node.Jump(131);
                            jsrnode.target = jsrtarget = ((Node.Jump)n).getFinally();
                            unwind = jsrnode;
                        } else {
                            unwind = new Node(3);
                        }
                        if (unwindBlock == null) {
                            unwindBlock = new Node(125, node.getLineno());
                        }
                        unwindBlock.addChildToBack(unwind);
                    }
                    if (unwindBlock == null) break;
                    Node returnNode = node;
                    Node returnExpr = returnNode.getFirstChild();
                    node = NodeTransformer.replaceCurrent(parent, previous, node, unwindBlock);
                    if (returnExpr == null) {
                        unwindBlock.addChildToBack(returnNode);
                        continue block12;
                    }
                    Node store = new Node(130, returnExpr);
                    unwindBlock.addChildToFront(store);
                    returnNode = new Node(62);
                    unwindBlock.addChildToBack(returnNode);
                    this.transformCompilationUnit_r(tree, store);
                    continue block12;
                }
                case 116: 
                case 117: {
                    Node.Jump jump = (Node.Jump)node;
                    Node.Jump jumpStatement = jump.getJumpStatement();
                    if (jumpStatement == null) {
                        Kit.codeBug();
                    }
                    int i = this.loops.size();
                    while (true) {
                        Node n;
                        if (i == 0) {
                            throw Kit.codeBug();
                        }
                        if ((n = (Node)this.loops.get(--i)) == jumpStatement) break;
                        int elemtype = n.getType();
                        if (elemtype == 119) {
                            Node leave = new Node(3);
                            previous = NodeTransformer.addBeforeCurrent(parent, previous, node, leave);
                            continue;
                        }
                        if (elemtype != 77) continue;
                        Node.Jump tryNode = (Node.Jump)n;
                        Node.Jump jsrFinally = new Node.Jump(131);
                        jsrFinally.target = tryNode.getFinally();
                        previous = NodeTransformer.addBeforeCurrent(parent, previous, node, jsrFinally);
                    }
                    jump.target = type == 116 ? jumpStatement.target : jumpStatement.getContinue();
                    jump.setType(5);
                    break;
                }
                case 37: {
                    this.visitCall(node, tree);
                    break;
                }
                case 30: {
                    this.visitNew(node, tree);
                    break;
                }
                case 118: 
                case 149: {
                    Node result = new Node(125);
                    for (Node cursor = node.getFirstChild(); cursor != null; cursor = cursor.getNext()) {
                        Node n = cursor;
                        if (n.getType() == 38) continue;
                        Kit.codeBug();
                        if (!n.hasChildren()) continue;
                        Node init = n.getFirstChild();
                        n.removeChild(init);
                        n.setType(48);
                        n = new Node(type == 118 ? 8 : 150, n, init);
                        Node pop = new Node(129, n, node.getLineno());
                        result.addChildToBack(pop);
                    }
                    node = NodeTransformer.replaceCurrent(parent, previous, node, result);
                    break;
                }
                case 8: 
                case 31: 
                case 38: 
                case 150: {
                    Node nameSource;
                    if (tree.getType() != 105 || ((FunctionNode)tree).requiresActivation()) break;
                    if (type == 38) {
                        nameSource = node;
                    } else {
                        nameSource = node.getFirstChild();
                        if (nameSource.getType() != 48) {
                            if (type == 31) break;
                            throw Kit.codeBug();
                        }
                    }
                    String name = nameSource.getString();
                    if (!tree.hasParamOrVar(name)) break;
                    if (type == 38) {
                        node.setType(54);
                        break;
                    }
                    if (type == 8) {
                        node.setType(55);
                        nameSource.setType(40);
                        break;
                    }
                    if (type == 150) {
                        node.setType(151);
                        nameSource.setType(40);
                        break;
                    }
                    if (type == 31) {
                        Node n = new Node(43);
                        node = NodeTransformer.replaceCurrent(parent, previous, node, n);
                        break;
                    }
                    throw Kit.codeBug();
                }
            }
            this.transformCompilationUnit_r(tree, node);
        }
    }

    protected void visitNew(Node node, ScriptOrFnNode tree) {
    }

    protected void visitCall(Node node, ScriptOrFnNode tree) {
    }

    private static Node addBeforeCurrent(Node parent, Node previous, Node current, Node toAdd) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.addChildToFront(toAdd);
        } else {
            if (current != previous.getNext()) {
                Kit.codeBug();
            }
            parent.addChildAfter(toAdd, previous);
        }
        return toAdd;
    }

    private static Node replaceCurrent(Node parent, Node previous, Node current, Node replacement) {
        if (previous == null) {
            if (current != parent.getFirstChild()) {
                Kit.codeBug();
            }
            parent.replaceChild(current, replacement);
        } else if (previous.next == current) {
            parent.replaceChildAfter(previous, replacement);
        } else {
            parent.replaceChild(current, replacement);
        }
        return replacement;
    }
}

