/*
 * Decompiled with CFR 0.152.
 */
package play.modules.less;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import compat16.org.mozilla.javascript.WrappedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.Logger;
import play.cache.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayLessEngine {
    LessEngine lessEngine;
    Boolean devMode;
    Pattern importPattern = Pattern.compile(".*@import\\s*\"(.*?)\".*");

    PlayLessEngine(Boolean devMode) {
        this.lessEngine = new LessEngine();
        this.devMode = devMode;
    }

    public String get(File lessFile) {
        String cacheKey = "less_" + lessFile.getPath() + this.lastModifiedRecursive(lessFile);
        String css = (String)Cache.get((String)cacheKey, String.class);
        if (css == null) {
            css = this.compile(lessFile);
            Cache.set((String)cacheKey, (Object)css);
        }
        return css;
    }

    public long lastModifiedRecursive(File lessFile) {
        long lastModified = lessFile.lastModified();
        for (File imported : this.getImportsFromCacheOrFile(lessFile)) {
            lastModified = Math.max(lastModified, imported.lastModified());
        }
        return lastModified;
    }

    protected Set<File> getImportsFromCacheOrFile(File lessFile) {
        String cacheKey = "less_imports_" + lessFile.getPath() + lessFile.lastModified();
        Set<File> files = (Set<File>)Cache.get((String)cacheKey, Set.class);
        if (files == null) {
            try {
                files = this.getImportsFromFile(lessFile);
                Cache.set((String)cacheKey, files);
            }
            catch (IOException e) {
                Logger.error((Throwable)e, (String)"IOException trying to determine imports in LESS file", (Object[])new Object[0]);
                files = new HashSet<File>();
            }
        }
        return files;
    }

    protected Set<File> getImportsFromFile(File lessFile) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(lessFile));
        HashSet<File> files = new HashSet<File>();
        while ((line = r.readLine()) != null) {
            Matcher m = this.importPattern.matcher(line);
            while (m.find()) {
                File file = new File(lessFile.getParentFile(), m.group(1));
                files.add(file);
                files.addAll(this.getImportsFromCacheOrFile(file));
            }
        }
        return files;
    }

    protected String compile(File lessFile) {
        try {
            return this.lessEngine.compile(lessFile);
        }
        catch (LessException e) {
            return this.handleException(lessFile, e);
        }
    }

    public String handleException(File lessFile, LessException e) {
        WrappedException we;
        Logger.warn((Throwable)e, (String)"Less exception", (Object[])new Object[0]);
        String filename = e.getFilename();
        List extractList = e.getExtract();
        String extract = null;
        if (extractList != null) {
            extract = extractList.toString();
        }
        if (filename == null) {
            filename = lessFile.getName();
        }
        if (extract == null && e.getCause() instanceof WrappedException && (we = (WrappedException)e.getCause()).getCause() instanceof FileNotFoundException) {
            FileNotFoundException fnfe = (FileNotFoundException)we.getCause();
            extract = fnfe.getMessage();
        }
        return this.formatMessage(filename, e.getLine(), e.getColumn(), extract, e.getErrorType());
    }

    public String formatMessage(String filename, int line, int column, String extract, String errorType) {
        return "body:before {display: block; color: #c00; white-space: pre; font-family: monospace; background: #FDD9E1; border-top: 1px solid pink; border-bottom: 1px solid pink; padding: 10px; content: \"[LESS ERROR] " + String.format("%s:%s: %s (%s)", filename, line, extract, errorType) + "\"; }";
    }
}

