/*
 * Decompiled with CFR 0.152.
 */
package play.modules.less;

import java.io.PrintStream;
import java.util.Date;
import play.Play;
import play.PlayPlugin;
import play.modules.less.PlayLessEngine;
import play.mvc.Http;
import play.utils.Utils;
import play.vfs.VirtualFile;

public class Plugin
extends PlayPlugin {
    PlayLessEngine playLessEngine;
    boolean useEtag = true;

    public void onLoad() {
        this.playLessEngine = new PlayLessEngine(Play.mode == Play.Mode.DEV);
        this.useEtag = Play.configuration.getProperty("http.useETag", "true").equals("true");
    }

    public boolean serveStatic(VirtualFile file, Http.Request request, Http.Response response) {
        if (file.getName().endsWith(".less")) {
            response.contentType = "text/css";
            try {
                this.handleResponse(file, request, response);
            }
            catch (Exception e) {
                response.status = 500;
                response.print((Object)"Bugger, the LESS processing failed:,\n");
                e.printStackTrace(new PrintStream(response.out));
            }
            return true;
        }
        return super.serveStatic(file, request, response);
    }

    private void handleResponse(VirtualFile file, Http.Request request, Http.Response response) {
        long lastModified = this.playLessEngine.lastModifiedRecursive(file.getRealFile());
        String etag = "\"" + lastModified + "-" + file.hashCode() + "\"";
        if (!request.isModified(etag, lastModified)) {
            this.handleNotModified(request, response, etag);
        } else {
            this.handleOk(request, response, file, etag, lastModified);
        }
    }

    private void handleNotModified(Http.Request request, Http.Response response, String etag) {
        if (request.method.equals("GET")) {
            response.status = 304;
        }
        if (this.useEtag) {
            response.setHeader("ETag", etag);
        }
    }

    private void handleOk(Http.Request request, Http.Response response, VirtualFile file, String etag, long lastModified) {
        response.status = 200;
        response.print((Object)this.playLessEngine.get(file.getRealFile()));
        response.setHeader("Last-Modified", Utils.getHttpDateFormatter().format(new Date(lastModified)));
        if (this.useEtag) {
            response.setHeader("ETag", etag);
        }
    }
}

