/*
 * Decompiled with CFR 0.152.
 */
package org.tautua.markdownpapers.ast;

import org.tautua.markdownpapers.ast.SimpleNode;
import org.tautua.markdownpapers.ast.Visitor;

public class Emphasis
extends SimpleNode {
    private String text;
    private Type type = Type.ITALIC;

    public Emphasis(int id) {
        super(id);
    }

    public String getText() {
        return this.text;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void makeItalic(String text) {
        this.type = Type.ITALIC;
        this.text = text;
    }

    public void makeBold(String text) {
        this.type = Type.BOLD;
        this.text = text;
    }

    public void makeItalicAndBold(String text) {
        this.type = Type.ITALIC_AND_BOLD;
        this.text = text;
    }

    public static enum Type {
        ITALIC,
        BOLD,
        ITALIC_AND_BOLD;

    }
}

