/*
 * Decompiled with CFR 0.152.
 */
package org.tautua.markdownpapers.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.tautua.markdownpapers.ast.CharRef;
import org.tautua.markdownpapers.ast.ClosingTag;
import org.tautua.markdownpapers.ast.Code;
import org.tautua.markdownpapers.ast.CodeSpan;
import org.tautua.markdownpapers.ast.CodeText;
import org.tautua.markdownpapers.ast.Comment;
import org.tautua.markdownpapers.ast.Document;
import org.tautua.markdownpapers.ast.Emphasis;
import org.tautua.markdownpapers.ast.EmptyTag;
import org.tautua.markdownpapers.ast.Header;
import org.tautua.markdownpapers.ast.Image;
import org.tautua.markdownpapers.ast.InlineUrl;
import org.tautua.markdownpapers.ast.Item;
import org.tautua.markdownpapers.ast.JJTParserState;
import org.tautua.markdownpapers.ast.Line;
import org.tautua.markdownpapers.ast.Link;
import org.tautua.markdownpapers.ast.Node;
import org.tautua.markdownpapers.ast.OpeningTag;
import org.tautua.markdownpapers.ast.Paragraph;
import org.tautua.markdownpapers.ast.ParserTreeConstants;
import org.tautua.markdownpapers.ast.Quote;
import org.tautua.markdownpapers.ast.Resource;
import org.tautua.markdownpapers.ast.ResourceDefinition;
import org.tautua.markdownpapers.ast.Ruler;
import org.tautua.markdownpapers.ast.TagAttribute;
import org.tautua.markdownpapers.ast.Text;
import org.tautua.markdownpapers.parser.ParseException;
import org.tautua.markdownpapers.parser.ParserConstants;
import org.tautua.markdownpapers.parser.ParserTokenManager;
import org.tautua.markdownpapers.parser.SimpleCharStream;
import org.tautua.markdownpapers.parser.Token;
import org.tautua.markdownpapers.util.DequeStack;
import org.tautua.markdownpapers.util.Stack;

public class Parser
implements ParserTreeConstants,
ParserConstants {
    protected JJTParserState jjtree = new JJTParserState();
    private static final String EMPTY_STRING = "";
    private static final String QUOTE = "\"";
    private Stack<Node> stack = new DequeStack<Node>();
    private Stack<Node> markupStack = new DequeStack<Node>();
    private int currentQuoteLevel = 0;
    private int parentheses;
    private int brackets;
    public ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[81];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[37];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public Document parse() throws ParseException {
        this.jj_input_stream.setTabSize(4);
        this.Document();
        return (Document)this.getRootNode();
    }

    public Node getRootNode() {
        return this.jjtree.rootNode();
    }

    String val(Token t) {
        String i = t.image;
        if (t.kind == 30 || t.kind == 28 && i.startsWith("``")) {
            i = i.substring(2, i.length() - 2);
        } else if (t.any(28, 29)) {
            i = i.substring(1, i.length() - 1);
        } else if (t.any(31)) {
            i = i.substring(3, i.length() - 3);
        } else if (t.kind == 37) {
            i = String.valueOf(i.charAt(1));
        }
        return i;
    }

    String toWhitespace(Token prev, Token tab) {
        int x = 4 - (prev == null ? 1 : prev.endColumn + 1) % 4 + 1;
        switch (x) {
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return "   ";
            }
        }
        return "    ";
    }

    boolean ParagraphLookahead() {
        Token t;
        if (this.getToken((int)1).kind != 3) {
            return false;
        }
        int i = 2;
        int quoteLevel = 0;
        do {
            t = this.getToken(i++);
            if (t.kind == 11) {
                ++quoteLevel;
                continue;
            }
            if (t.kind != 3) continue;
            quoteLevel = 0;
        } while (t.any(3, 1, 2, 11));
        if (t.any(16, 15, 22, 32, 0)) {
            return false;
        }
        return this.currentQuoteLevel == quoteLevel && this.stack.size() > 0 && this.stack.peek() instanceof Item && ((Item)this.stack.peek()).getIndentation() < t.beginColumn;
    }

    boolean LineLookahead() {
        Token t;
        if (this.getToken((int)1).kind != 3) {
            return false;
        }
        int i = 2;
        int quoteLevel = 0;
        do {
            t = this.getToken(i++);
            if (t.kind != 11) continue;
            ++quoteLevel;
        } while (t.any(1, 2, 11));
        if (t.any(3, 0)) {
            return false;
        }
        if (t.any(16, 15, 22, 32) && this.stack.peek() instanceof Item) {
            return false;
        }
        return this.currentQuoteLevel >= quoteLevel;
    }

    boolean CodeLineLookahead() {
        Token t;
        if (this.getToken((int)1).kind != 3) {
            return false;
        }
        int i = 2;
        int quoteLevel = 0;
        int _indent = 0;
        do {
            t = this.getToken(i++);
            if (t.kind == 11) {
                ++quoteLevel;
                _indent = 0;
                continue;
            }
            if (t.kind == 1) {
                ++_indent;
                continue;
            }
            if (t.kind != 2) continue;
            _indent += 4;
        } while (t.any(1, 2, 11) && _indent < 4);
        if (t.any(3, 0)) {
            return true;
        }
        return this.currentQuoteLevel >= quoteLevel && _indent >= 4;
    }

    boolean QuotedElementLookahead() {
        Token t;
        if (this.getToken(1).none(3)) {
            return false;
        }
        int i = 2;
        int quoteLevel = 0;
        do {
            if (!(t = this.getToken(i++)).any(11)) continue;
            ++quoteLevel;
        } while (t.any(1, 2, 11));
        if (t.any(3, 0)) {
            return true;
        }
        return this.currentQuoteLevel <= quoteLevel;
    }

    boolean LooseLookahead() {
        Token t;
        if (this.getToken(1).none(3)) {
            return false;
        }
        int i = 2;
        boolean newline = false;
        do {
            if (!(t = this.getToken(i++)).any(3)) continue;
            newline = true;
        } while (t.any(1, 2, 3));
        Item item = (Item)this.stack.peek();
        return newline && t.any(16, 15, 22, 32) && item.getIndentation() == t.beginColumn;
    }

    boolean TextLookahead() {
        if (this.stack.size() > 0 && this.stack.peek() instanceof Header) {
            Token t;
            int i = 1;
            while ((t = this.getToken(i++)).any(19)) {
            }
            return t.none(3, 0);
        }
        return this.getToken(1).none(3, 0);
    }

    boolean ListLookahead() {
        Token t;
        if (this.getToken(1).none(3)) {
            return false;
        }
        int i = 2;
        int quoteLevel = 0;
        do {
            if (!(t = this.getToken(i++)).any(11)) continue;
            ++quoteLevel;
        } while (t.any(3, 1, 2, 11));
        Item item = (Item)this.stack.peek();
        return t.any(16, 15, 22, 32) && item.getIndentation() < t.beginColumn;
    }

    boolean ItemLookahead() {
        Token t;
        if (this.getToken(1).none(3)) {
            return false;
        }
        int i = 2;
        int quoteLevel = 0;
        do {
            if (!(t = this.getToken(i++)).any(11)) continue;
            ++quoteLevel;
        } while (t.any(3, 1, 2, 11));
        org.tautua.markdownpapers.ast.List list = (org.tautua.markdownpapers.ast.List)this.stack.peek();
        return t.any(16, 15, 22, 32) && list.getIndentation() == t.beginColumn;
    }

    boolean QuoteInsideTitleLookahead(int quoteKind) {
        if (this.getToken((int)1).kind == quoteKind) {
            Token t;
            int i = 2;
            while ((t = this.getToken(i++)).none(quoteKind, 18, 3, 0)) {
            }
            return t.kind == quoteKind;
        }
        return this.getToken(1).none(3, 0);
    }

    public final void Document() throws ParseException {
        Document jjtn000 = new Document(0);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            block8: while (this.jj_2_1(1)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: {
                        this.jj_consume_token(3);
                        continue block8;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                if (this.jj_2_3(1)) {
                    this.Element();
                    while (this.jj_2_2(2)) {
                        this.jj_consume_token(3);
                        this.Element();
                    }
                    continue;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(0);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void Element() throws ParseException {
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            this.DocumentElement();
        } else if (this.jj_2_5(1)) {
            this.BlockElement();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void DocumentElement() throws ParseException {
        this.ResourceDefinition();
    }

    public final void BlockElement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.Header();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                if (this.jj_2_6(Integer.MAX_VALUE)) {
                    this.SetextHeader();
                    break;
                }
                if (this.jj_2_7(Integer.MAX_VALUE)) {
                    this.Whitespace();
                    break;
                }
                if (this.jj_2_8(Integer.MAX_VALUE)) {
                    this.Ruler();
                    break;
                }
                if (this.jj_2_9(Integer.MAX_VALUE)) {
                    this.Code();
                    break;
                }
                if (this.jj_2_10(Integer.MAX_VALUE)) {
                    this.Quote();
                    break;
                }
                if (this.jj_2_11(Integer.MAX_VALUE)) {
                    this.List();
                    break;
                }
                if (this.jj_2_12(Integer.MAX_VALUE)) {
                    this.Comment();
                    break;
                }
                if (this.jj_2_13(1)) {
                    this.Paragraph();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Whitespace() throws ParseException {
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    this.jj_consume_token(1);
                    break;
                }
                case 2: {
                    this.jj_consume_token(2);
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[3] = this.jj_gen;
    }

    public final void InsignificantWhitespace() throws ParseException {
        this.jj_consume_token(1);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
    }

    public final void EmptyLine() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: {
                this.Whitespace();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Header() throws ParseException {
        Header jjtn000 = new Header(2);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        int level = 1;
        this.stack.push(jjtn000);
        try {
            level = this.HeaderPrefix();
            this.Line();
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block8;
                    }
                }
                this.jj_consume_token(19);
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.setLevel(level);
            this.stack.pop();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final int HeaderPrefix() throws ParseException {
        int level = 1;
        this.jj_consume_token(19);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                ++level;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 19: {
                        this.jj_consume_token(19);
                        ++level;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 19: {
                                this.jj_consume_token(19);
                                ++level;
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 19: {
                                        this.jj_consume_token(19);
                                        ++level;
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 19: {
                                                this.jj_consume_token(19);
                                                ++level;
                                                break block0;
                                            }
                                        }
                                        this.jj_la1[9] = this.jj_gen;
                                        break block0;
                                    }
                                }
                                this.jj_la1[10] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[11] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[12] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        return level;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void SetextHeader() throws ParseException {
        Header jjtn000 = new Header(2);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.Line();
            this.jj_consume_token(3);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    block13: while (true) {
                        this.jj_consume_token(10);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 10: {
                                continue block13;
                            }
                        }
                        break;
                    }
                    this.jj_la1[14] = this.jj_gen;
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.setLevel(1);
                    return;
                }
                case 23: {
                    this.jj_consume_token(23);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.setLevel(2);
                    return;
                }
                case 15: {
                    this.jj_consume_token(15);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.setLevel(2);
                    return;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (!(jjte000 instanceof ParseException)) throw (Error)jjte000;
            throw (ParseException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void Ruler() throws ParseException {
        Ruler jjtn000 = new Ruler(3);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    this.InsignificantWhitespace();
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 25: {
                    this.jj_consume_token(25);
                    return;
                }
                case 23: {
                    this.jj_consume_token(23);
                    return;
                }
                case 24: {
                    this.jj_consume_token(24);
                    return;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (!(jjte000 instanceof ParseException)) throw (Error)jjte000;
            throw (ParseException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void Quote() throws ParseException {
        Quote jjtn000 = new Quote(4);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        this.stack.push(jjtn000);
        ++this.currentQuoteLevel;
        try {
            this.QuotePrefix();
            this.BlockElement();
            block13: while (this.QuotedElementLookahead()) {
                this.jj_consume_token(3);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 11: {
                        if (this.jj_2_15(Integer.MAX_VALUE)) {
                            Line jjtn001 = new Line(5);
                            boolean jjtc001 = true;
                            this.jjtree.openNodeScope(jjtn001);
                            try {
                                this.Whitespace();
                                continue block13;
                            }
                            catch (Throwable jjte001) {
                                if (jjtc001) {
                                    this.jjtree.clearNodeScope(jjtn001);
                                    jjtc001 = false;
                                } else {
                                    this.jjtree.popNode();
                                }
                                if (jjte001 instanceof RuntimeException) {
                                    throw (RuntimeException)jjte001;
                                }
                                if (jjte001 instanceof ParseException) {
                                    throw (ParseException)jjte001;
                                }
                                throw (Error)jjte001;
                            }
                            finally {
                                if (jjtc001) {
                                    this.jjtree.closeNodeScope((Node)jjtn001, true);
                                }
                                continue block13;
                            }
                        }
                        if (this.jj_2_16(Integer.MAX_VALUE)) {
                            this.QuotePrefix();
                            if (!this.jj_2_14(1)) continue block13;
                            this.BlockElement();
                            continue block13;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[18] = this.jj_gen;
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            --this.currentQuoteLevel;
            this.stack.pop();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void QuotePrefix() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.InsignificantWhitespace();
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        this.jj_consume_token(11);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void Code() throws ParseException {
        jjtn000 = new Code(6);
        jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.CodeLine();
lbl6:
            // 5 sources

            block16: while (this.CodeLineLookahead()) {
                this.jj_consume_token(3);
                while (this.jj_2_17(0x7FFFFFFF)) {
                    this.QuotePrefix();
                }
                if (this.jj_2_18(0x7FFFFFFF)) {
                    jjtn001 = new Line(5);
                    jjtc001 = true;
                    this.jjtree.openNodeScope(jjtn001);
                    try {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: {
                                this.Whitespace();
                                ** break;
                            }
                            default: {
                                this.jj_la1[21] = this.jj_gen;
                                continue block16;
                            }
                        }
                    }
                    catch (Throwable jjte001) {
                        if (jjtc001) {
                            this.jjtree.clearNodeScope(jjtn001);
                            jjtc001 = false;
                        } else {
                            this.jjtree.popNode();
                        }
                        if (jjte001 instanceof RuntimeException) {
                            throw (RuntimeException)jjte001;
                        }
                        if (jjte001 instanceof ParseException) {
                            throw (ParseException)jjte001;
                        }
                        throw (Error)jjte001;
                    }
                    finally {
                        if (jjtc001) {
                            this.jjtree.closeNodeScope((Node)jjtn001, true);
                        }
                        continue;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: {
                        this.CodeLine();
                        continue block16;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void CodeLine() throws ParseException {
        Line jjtn000 = new Line(5);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.CodeLinePrefix();
            this.CodeText();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void CodeLinePrefix() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                this.jj_consume_token(1);
                this.jj_consume_token(1);
                this.jj_consume_token(1);
                break;
            }
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void CodeText() throws ParseException {
        block48: {
            CodeText jjtn000 = new CodeText(7);
            boolean jjtc000 = true;
            this.jjtree.openNodeScope(jjtn000);
            Token prev = null;
            try {
                while (true) {
                    Token t;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: {
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            break block48;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 4: {
                                    t = this.jj_consume_token(4);
                                    break;
                                }
                                case 6: {
                                    t = this.jj_consume_token(6);
                                    break;
                                }
                                case 5: {
                                    t = this.jj_consume_token(5);
                                    break;
                                }
                                case 7: {
                                    t = this.jj_consume_token(7);
                                    break;
                                }
                                case 35: {
                                    t = this.jj_consume_token(35);
                                    break;
                                }
                                case 38: {
                                    t = this.jj_consume_token(38);
                                    break;
                                }
                                case 28: {
                                    t = this.jj_consume_token(28);
                                    break;
                                }
                                case 26: {
                                    t = this.jj_consume_token(26);
                                    break;
                                }
                                case 27: {
                                    t = this.jj_consume_token(27);
                                    break;
                                }
                                case 8: {
                                    t = this.jj_consume_token(8);
                                    break;
                                }
                                case 9: {
                                    t = this.jj_consume_token(9);
                                    break;
                                }
                                case 29: {
                                    t = this.jj_consume_token(29);
                                    break;
                                }
                                case 30: {
                                    t = this.jj_consume_token(30);
                                    break;
                                }
                                case 31: {
                                    t = this.jj_consume_token(31);
                                    break;
                                }
                                case 10: {
                                    t = this.jj_consume_token(10);
                                    break;
                                }
                                case 37: {
                                    t = this.jj_consume_token(37);
                                    break;
                                }
                                case 11: {
                                    t = this.jj_consume_token(11);
                                    break;
                                }
                                case 32: {
                                    t = this.jj_consume_token(32);
                                    break;
                                }
                                case 36: {
                                    t = this.jj_consume_token(36);
                                    break;
                                }
                                case 12: {
                                    t = this.jj_consume_token(12);
                                    break;
                                }
                                case 13: {
                                    t = this.jj_consume_token(13);
                                    break;
                                }
                                case 14: {
                                    t = this.jj_consume_token(14);
                                    break;
                                }
                                case 15: {
                                    t = this.jj_consume_token(15);
                                    break;
                                }
                                case 23: {
                                    t = this.jj_consume_token(23);
                                    break;
                                }
                                case 16: {
                                    t = this.jj_consume_token(16);
                                    break;
                                }
                                case 17: {
                                    t = this.jj_consume_token(17);
                                    break;
                                }
                                case 18: {
                                    t = this.jj_consume_token(18);
                                    break;
                                }
                                case 19: {
                                    t = this.jj_consume_token(19);
                                    break;
                                }
                                case 20: {
                                    t = this.jj_consume_token(20);
                                    break;
                                }
                                case 21: {
                                    t = this.jj_consume_token(21);
                                    break;
                                }
                                case 1: {
                                    t = this.jj_consume_token(1);
                                    break;
                                }
                                case 22: {
                                    t = this.jj_consume_token(22);
                                    break;
                                }
                                case 24: {
                                    t = this.jj_consume_token(24);
                                    break;
                                }
                                case 25: {
                                    t = this.jj_consume_token(25);
                                    break;
                                }
                                default: {
                                    this.jj_la1[25] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            jjtn000.append(t.image);
                            break;
                        }
                        case 2: {
                            t = this.jj_consume_token(2);
                            jjtn000.append(this.toWhitespace(prev, t));
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    prev = t;
                }
            }
            finally {
                if (jjtc000) {
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                }
            }
        }
    }

    public final void ResourceDefinition() throws ParseException {
        ResourceDefinition jjtn000 = new ResourceDefinition(8);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String n = null;
        try {
            block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    this.jj_consume_token(1);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            this.jj_consume_token(1);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 1: {
                                    this.jj_consume_token(1);
                                    break block2;
                                }
                            }
                            this.jj_la1[27] = this.jj_gen;
                            break block2;
                        }
                    }
                    this.jj_la1[28] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                }
            }
            this.jj_consume_token(12);
            n = this.refname();
            this.jj_consume_token(17);
            jjtn000.setId(n);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    this.jj_consume_token(1);
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                }
            }
            this.jj_consume_token(8);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: {
                    this.Whitespace();
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                }
            }
            Resource resource = this.Resource();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.setResource(resource);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void List() throws ParseException {
        org.tautua.markdownpapers.ast.List jjtn000 = new org.tautua.markdownpapers.ast.List(9);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        this.stack.push(jjtn000);
        try {
            block32: {
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 11: {
                            break;
                        }
                        default: {
                            this.jj_la1[32] = this.jj_gen;
                            break block32;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            this.jj_consume_token(1);
                            continue block24;
                        }
                        case 2: {
                            this.jj_consume_token(2);
                            continue block24;
                        }
                        case 11: {
                            this.jj_consume_token(11);
                            continue block24;
                        }
                    }
                    break;
                }
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.Item();
            block25: while (this.ItemLookahead()) {
                block33: {
                    this.jj_consume_token(3);
                    block26: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: 
                            case 11: {
                                break;
                            }
                            default: {
                                this.jj_la1[34] = this.jj_gen;
                                break block33;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block26;
                            }
                            case 2: {
                                this.jj_consume_token(2);
                                continue block26;
                            }
                            case 11: {
                                this.jj_consume_token(11);
                                continue block26;
                            }
                        }
                        break;
                    }
                    this.jj_la1[35] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 16: 
                    case 22: 
                    case 32: {
                        this.Item();
                        continue block25;
                    }
                }
                this.jj_la1[36] = this.jj_gen;
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            this.stack.pop();
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void Item() throws ParseException {
        Item jjtn000 = new Item(10);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        this.stack.push(jjtn000);
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    t = this.jj_consume_token(16);
                    break;
                }
                case 15: {
                    t = this.jj_consume_token(15);
                    break;
                }
                case 22: {
                    t = this.jj_consume_token(22);
                    break;
                }
                case 32: {
                    t = this.jj_consume_token(32);
                    jjtn000.makeOrdered();
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    this.jj_consume_token(1);
                    break;
                }
                case 2: {
                    this.jj_consume_token(2);
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            jjtn000.setIndentation(t.beginColumn);
            this.Paragraph();
            while (this.jj_2_19(1)) {
                if (this.ParagraphLookahead()) {
                    this.jj_consume_token(3);
                    while (this.jj_2_20(Integer.MAX_VALUE)) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: {
                                this.Whitespace();
                                break;
                            }
                            default: {
                                this.jj_la1[39] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(3);
                    }
                    this.Paragraph();
                    jjtn000.makeLoose();
                    continue;
                }
                if (this.ListLookahead()) {
                    this.jj_consume_token(3);
                    while (this.jj_2_21(Integer.MAX_VALUE)) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: {
                                this.Whitespace();
                                break;
                            }
                            default: {
                                this.jj_la1[40] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(3);
                    }
                    this.List();
                    continue;
                }
                if (this.LooseLookahead()) {
                    this.jj_consume_token(3);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: {
                            this.Whitespace();
                            break;
                        }
                        default: {
                            this.jj_la1[41] = this.jj_gen;
                        }
                    }
                    jjtn000.makeLoose();
                    continue;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            Item item = (Item)this.stack.pop();
            org.tautua.markdownpapers.ast.List list = (org.tautua.markdownpapers.ast.List)this.stack.peek();
            if (list.getIndentation() == 0) {
                list.setIndentation(item.getIndentation());
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void Paragraph() throws ParseException {
        Paragraph jjtn000 = new Paragraph(11);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            this.Line();
            while (this.LineLookahead()) {
                block20: {
                    this.jj_consume_token(3);
                    block14: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: 
                            case 11: {
                                break;
                            }
                            default: {
                                this.jj_la1[42] = this.jj_gen;
                                break block20;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                this.jj_consume_token(1);
                                continue block14;
                            }
                            case 2: {
                                this.jj_consume_token(2);
                                continue block14;
                            }
                            case 11: {
                                this.jj_consume_token(11);
                                continue block14;
                            }
                        }
                        break;
                    }
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.Line();
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void Line() throws ParseException {
        Line jjtn000 = new Line(5);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            while (true) {
                block2 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: {
                        this.CharRef();
                        break;
                    }
                    case 28: {
                        this.CodeSpan();
                        break;
                    }
                    case 29: 
                    case 30: 
                    case 31: {
                        this.Emphasis();
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                        if (this.jj_2_22(Integer.MAX_VALUE)) {
                            this.InlineURL();
                            break;
                        }
                        if (this.jj_2_23(Integer.MAX_VALUE)) {
                            this.Tag();
                            break;
                        }
                        if (this.jj_2_24(Integer.MAX_VALUE)) {
                            this.Image();
                            break;
                        }
                        if (this.jj_2_25(Integer.MAX_VALUE)) {
                            this.Link();
                            break;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: 
                            case 26: 
                            case 27: 
                            case 32: 
                            case 37: 
                            case 38: {
                                this.Text();
                                break block2;
                            }
                        }
                        this.jj_la1[45] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (this.TextLookahead()) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void Text() throws ParseException {
        Text jjtn000 = new Text(12);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            String v = this.Anything();
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.append(v);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void CharRef() throws ParseException {
        CharRef jjtn000 = new CharRef(13);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: {
                    t = this.jj_consume_token(36);
                    break;
                }
                case 35: {
                    t = this.jj_consume_token(35);
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.setValue(t.image);
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void CodeSpan() throws ParseException {
        CodeSpan jjtn000 = new CodeSpan(14);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            Token t = this.jj_consume_token(28);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.setText(this.val(t));
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void Emphasis() throws ParseException {
        Emphasis jjtn000 = new Emphasis(15);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    Token t = this.jj_consume_token(29);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.makeItalic(this.val(t));
                    return;
                }
                case 30: {
                    Token t = this.jj_consume_token(30);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.makeBold(this.val(t));
                    return;
                }
                case 31: {
                    Token t = this.jj_consume_token(31);
                    this.jjtree.closeNodeScope((Node)jjtn000, true);
                    jjtc000 = false;
                    jjtn000.makeItalicAndBold(this.val(t));
                    return;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    public final void Comment() throws ParseException {
        Comment jjtn000 = new Comment(16);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        StringBuilder buff = new StringBuilder();
        try {
            this.jj_consume_token(26);
            block8: while (this.jj_2_26(1)) {
                if (this.getToken(1).none(3, 27)) {
                    String v = this.Anything();
                    buff.append(v);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: {
                        Token t = this.jj_consume_token(3);
                        buff.append(t.image);
                        continue block8;
                    }
                }
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            jjtn000.setText(buff.toString());
            this.jj_consume_token(27);
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (jjte000 instanceof ParseException) {
                throw (ParseException)jjte000;
            }
            throw (Error)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void InlineURL() throws ParseException {
        InlineUrl jjtn000 = new InlineUrl(17);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        StringBuilder buff = new StringBuilder();
        try {
            block18: {
                this.jj_consume_token(14);
                Token t = this.jj_consume_token(38);
                buff.append(t.image);
                this.jj_consume_token(8);
                buff.append(":");
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[49] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(21);
                    buff.append("/");
                }
                t = this.jj_consume_token(38);
                buff.append(t.image);
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 4: 
                        case 10: 
                        case 21: 
                        case 38: {
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                            break block18;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 38: {
                            t = this.jj_consume_token(38);
                            buff.append(t.image);
                            continue block16;
                        }
                        case 21: {
                            this.jj_consume_token(21);
                            buff.append("/");
                            continue block16;
                        }
                        case 4: {
                            this.jj_consume_token(4);
                            buff.append("&");
                            continue block16;
                        }
                        case 10: {
                            this.jj_consume_token(10);
                            buff.append("=");
                            continue block16;
                        }
                    }
                    break;
                }
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(11);
            this.jjtree.closeNodeScope((Node)jjtn000, true);
            jjtc000 = false;
            jjtn000.setUrl(buff.toString());
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void Link() throws ParseException {
        Link jjtn000 = new Link(18);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        String reference = EMPTY_STRING;
        Resource resource = null;
        try {
            this.jj_consume_token(12);
            do {
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: {
                        this.CharRef();
                        break;
                    }
                    case 28: {
                        this.CodeSpan();
                        break;
                    }
                    case 29: 
                    case 30: 
                    case 31: {
                        this.Emphasis();
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        if (this.jj_2_27(Integer.MAX_VALUE)) {
                            this.InlineURL();
                            break;
                        }
                        if (this.jj_2_28(Integer.MAX_VALUE)) {
                            this.Image();
                            break;
                        }
                        if (this.jj_2_29(Integer.MAX_VALUE)) {
                            this.Link();
                            break;
                        }
                        if (this.getToken(1).none(17, 3, 0)) {
                            this.Text();
                            break;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 3: {
                                Text jjtn001 = new Text(12);
                                boolean jjtc001 = true;
                                this.jjtree.openNodeScope(jjtn001);
                                try {
                                    this.jj_consume_token(3);
                                }
                                finally {
                                    if (jjtc001) {
                                        this.jjtree.closeNodeScope((Node)jjtn001, true);
                                    }
                                }
                                ((Text)this.jjtree.peekNode()).append("\n");
                                break block3;
                            }
                        }
                        this.jj_la1[53] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            } while (this.jj_2_30(1));
            this.jj_consume_token(17);
            if (!this.jj_2_32(3)) return;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 3: 
                case 12: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: {
                            this.jj_consume_token(1);
                            jjtn000.setWhitespaceAtMiddle();
                            break;
                        }
                        default: {
                            this.jj_la1[54] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 3: {
                            this.jj_consume_token(3);
                            break;
                        }
                        default: {
                            this.jj_la1[55] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(12);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 8: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 18: 
                        case 21: 
                        case 38: {
                            reference = this.refname();
                            break;
                        }
                        default: {
                            this.jj_la1[56] = this.jj_gen;
                        }
                    }
                    jjtn000.setReference(reference);
                    this.jj_consume_token(17);
                    return;
                }
                case 13: {
                    this.jj_consume_token(13);
                    if (this.jj_2_31(1)) {
                        resource = this.Resource();
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: {
                            this.Whitespace();
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                        }
                    }
                    jjtn000.setResource(resource);
                    this.jj_consume_token(18);
                    return;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (!(jjte000 instanceof ParseException)) throw (Error)jjte000;
            throw (ParseException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void Image() throws ParseException {
        Image jjtn000 = new Image(19);
        boolean jjtc000 = true;
        this.jjtree.openNodeScope(jjtn000);
        Resource resource = null;
        try {
            this.jj_consume_token(7);
            this.jj_consume_token(12);
            String text = this.refname();
            jjtn000.setText(text);
            this.jj_consume_token(17);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 12: 
                case 13: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 12: {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 1: {
                                    this.jj_consume_token(1);
                                    break;
                                }
                                default: {
                                    this.jj_la1[59] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(12);
                            String reference = this.refname();
                            jjtn000.setReference(reference);
                            this.jj_consume_token(17);
                            return;
                        }
                        case 13: {
                            this.jj_consume_token(13);
                            if (this.jj_2_33(1)) {
                                resource = this.Resource();
                                jjtn000.setResource(resource);
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 1: 
                                case 2: {
                                    this.Whitespace();
                                    break;
                                }
                                default: {
                                    this.jj_la1[60] = this.jj_gen;
                                }
                            }
                            this.jj_consume_token(18);
                            return;
                        }
                    }
                    this.jj_la1[61] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    return;
                }
            }
        }
        catch (Throwable jjte000) {
            if (jjtc000) {
                this.jjtree.clearNodeScope(jjtn000);
                jjtc000 = false;
            } else {
                this.jjtree.popNode();
            }
            if (jjte000 instanceof RuntimeException) {
                throw (RuntimeException)jjte000;
            }
            if (!(jjte000 instanceof ParseException)) throw (Error)jjte000;
            throw (ParseException)jjte000;
        }
        finally {
            if (jjtc000) {
                this.jjtree.closeNodeScope((Node)jjtn000, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Tag() throws ParseException {
        block33: {
            ArrayList<TagAttribute> attributes;
            block32: {
                attributes = new ArrayList<TagAttribute>();
                if (!this.jj_2_35(2)) break block32;
                this.jj_consume_token(14);
                this.jj_consume_token(21);
                Token t = this.jj_consume_token(38);
                ClosingTag jjtn001 = new ClosingTag(20);
                boolean jjtc001 = true;
                this.jjtree.openNodeScope(jjtn001);
                try {
                    this.jj_consume_token(11);
                }
                finally {
                    if (jjtc001) {
                        this.jjtree.closeNodeScope((Node)jjtn001, true);
                    }
                }
                ClosingTag closing = (ClosingTag)this.jjtree.peekNode();
                closing.setName(t.image);
                if (this.markupStack.size() > 0) {
                    OpeningTag opening = (OpeningTag)this.markupStack.peek();
                    if (opening.getName().equals(closing.getName())) {
                        opening.setClosingTag(closing);
                        this.markupStack.pop();
                    } else {
                        this.markupStack.clear();
                    }
                }
                break block33;
            }
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    this.jj_consume_token(14);
                    Token t = this.jj_consume_token(38);
                    while (this.jj_2_34(Integer.MAX_VALUE)) {
                        block23: while (true) {
                            this.jj_consume_token(1);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 1: {
                                    continue block23;
                                }
                            }
                            break;
                        }
                        this.jj_la1[63] = this.jj_gen;
                        TagAttribute attribute = this.TagAttribute();
                        attributes.add(attribute);
                    }
                    block24: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 1: {
                                break;
                            }
                            default: {
                                this.jj_la1[64] = this.jj_gen;
                                break block24;
                            }
                        }
                        this.jj_consume_token(1);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            this.jj_consume_token(21);
                            EmptyTag jjtn002 = new EmptyTag(21);
                            boolean jjtc002 = true;
                            this.jjtree.openNodeScope(jjtn002);
                            try {
                                this.jj_consume_token(11);
                            }
                            finally {
                                if (jjtc002) {
                                    this.jjtree.closeNodeScope((Node)jjtn002, true);
                                }
                            }
                            EmptyTag emptytag = (EmptyTag)this.jjtree.peekNode();
                            emptytag.setName(t.image);
                            emptytag.setAttributes(attributes);
                            break block3;
                        }
                        case 11: {
                            OpeningTag jjtn003 = new OpeningTag(22);
                            boolean jjtc003 = true;
                            this.jjtree.openNodeScope(jjtn003);
                            try {
                                this.jj_consume_token(11);
                            }
                            finally {
                                if (jjtc003) {
                                    this.jjtree.closeNodeScope((Node)jjtn003, true);
                                }
                            }
                            OpeningTag opening = (OpeningTag)this.jjtree.peekNode();
                            opening.setName(t.image);
                            opening.setAttributes(attributes);
                            this.markupStack.push(opening);
                            break block3;
                        }
                    }
                    this.jj_la1[65] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final TagAttribute TagAttribute() throws ParseException {
        StringBuilder buff = new StringBuilder();
        Token attrName = this.jj_consume_token(38);
        this.jj_consume_token(10);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                block42: while (true) {
                    Token t;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 13: 
                        case 14: 
                        case 18: 
                        case 20: 
                        case 21: 
                        case 28: 
                        case 37: 
                        case 38: {
                            break;
                        }
                        default: {
                            this.jj_la1[67] = this.jj_gen;
                            break block42;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 28: {
                            t = this.jj_consume_token(28);
                            break;
                        }
                        case 37: {
                            t = this.jj_consume_token(37);
                            break;
                        }
                        case 1: {
                            t = this.jj_consume_token(1);
                            break;
                        }
                        case 2: {
                            t = this.jj_consume_token(2);
                            break;
                        }
                        case 38: {
                            t = this.jj_consume_token(38);
                            break;
                        }
                        case 4: {
                            t = this.jj_consume_token(4);
                            break;
                        }
                        case 13: {
                            t = this.jj_consume_token(13);
                            break;
                        }
                        case 18: {
                            t = this.jj_consume_token(18);
                            break;
                        }
                        case 14: {
                            t = this.jj_consume_token(14);
                            break;
                        }
                        case 11: {
                            t = this.jj_consume_token(11);
                            break;
                        }
                        case 21: {
                            t = this.jj_consume_token(21);
                            break;
                        }
                        case 5: {
                            t = this.jj_consume_token(5);
                            break;
                        }
                        case 20: {
                            t = this.jj_consume_token(20);
                            break;
                        }
                        case 6: {
                            t = this.jj_consume_token(6);
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    buff.append(t.image);
                }
                this.jj_consume_token(9);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                block43: while (true) {
                    Token t;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 9: 
                        case 11: 
                        case 13: 
                        case 14: 
                        case 18: 
                        case 21: 
                        case 28: 
                        case 37: 
                        case 38: {
                            break;
                        }
                        default: {
                            this.jj_la1[69] = this.jj_gen;
                            break block43;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 28: {
                            t = this.jj_consume_token(28);
                            break;
                        }
                        case 37: {
                            t = this.jj_consume_token(37);
                            break;
                        }
                        case 1: {
                            t = this.jj_consume_token(1);
                            break;
                        }
                        case 2: {
                            t = this.jj_consume_token(2);
                            break;
                        }
                        case 38: {
                            t = this.jj_consume_token(38);
                            break;
                        }
                        case 4: {
                            t = this.jj_consume_token(4);
                            break;
                        }
                        case 13: {
                            t = this.jj_consume_token(13);
                            break;
                        }
                        case 18: {
                            t = this.jj_consume_token(18);
                            break;
                        }
                        case 14: {
                            t = this.jj_consume_token(14);
                            break;
                        }
                        case 11: {
                            t = this.jj_consume_token(11);
                            break;
                        }
                        case 21: {
                            t = this.jj_consume_token(21);
                            break;
                        }
                        case 5: {
                            t = this.jj_consume_token(5);
                            break;
                        }
                        case 9: {
                            t = this.jj_consume_token(9);
                            break;
                        }
                        case 6: {
                            t = this.jj_consume_token(6);
                            break;
                        }
                        default: {
                            this.jj_la1[70] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    buff.append(t.image);
                }
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new TagAttribute(attrName.image, buff.toString());
    }

    public final String refname() throws ParseException {
        StringBuilder buff = new StringBuilder();
        block18: while (true) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 4: {
                    t = this.jj_consume_token(4);
                    break;
                }
                case 5: {
                    t = this.jj_consume_token(5);
                    break;
                }
                case 8: {
                    t = this.jj_consume_token(8);
                    break;
                }
                case 10: {
                    t = this.jj_consume_token(10);
                    break;
                }
                case 11: {
                    t = this.jj_consume_token(11);
                    break;
                }
                case 12: {
                    t = this.jj_consume_token(12);
                    break;
                }
                case 13: {
                    t = this.jj_consume_token(13);
                    break;
                }
                case 14: {
                    t = this.jj_consume_token(14);
                    break;
                }
                case 18: {
                    t = this.jj_consume_token(18);
                    break;
                }
                case 21: {
                    t = this.jj_consume_token(21);
                    break;
                }
                case 1: {
                    t = this.jj_consume_token(1);
                    break;
                }
                case 2: {
                    t = this.jj_consume_token(2);
                    break;
                }
                case 38: {
                    t = this.jj_consume_token(38);
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buff.append(t.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 21: 
                case 38: {
                    continue block18;
                }
            }
            break;
        }
        this.jj_la1[73] = this.jj_gen;
        return buff.toString();
    }

    public final Resource Resource() throws ParseException {
        String hint = null;
        String url = this.url();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: {
                this.Whitespace();
                hint = this.title();
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
            }
        }
        return new Resource(url, hint);
    }

    public final String url() throws ParseException {
        String text;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                text = this.urltext();
                this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                if (this.jj_2_36(1)) {
                    text = this.urltext();
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return text;
    }

    public final String urltext() throws ParseException {
        StringBuilder buff = new StringBuilder();
        do {
            Token t;
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 38: {
                    t = this.jj_consume_token(38);
                    break;
                }
                case 4: {
                    t = this.jj_consume_token(4);
                    break;
                }
                case 13: {
                    t = this.jj_consume_token(13);
                    ++this.parentheses;
                    break;
                }
                default: {
                    this.jj_la1[76] = this.jj_gen;
                    if (this.parentheses > 0) {
                        t = this.jj_consume_token(18);
                        --this.parentheses;
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            t = this.jj_consume_token(12);
                            break block0;
                        }
                        case 17: {
                            t = this.jj_consume_token(17);
                            break block0;
                        }
                        case 8: {
                            t = this.jj_consume_token(8);
                            break block0;
                        }
                        case 21: {
                            t = this.jj_consume_token(21);
                            break block0;
                        }
                        case 5: {
                            t = this.jj_consume_token(5);
                            break block0;
                        }
                        case 19: {
                            t = this.jj_consume_token(19);
                            break block0;
                        }
                        case 10: {
                            t = this.jj_consume_token(10);
                            break block0;
                        }
                    }
                    this.jj_la1[77] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buff.append(t.image);
        } while (this.jj_2_37(1));
        this.parentheses = 0;
        return buff.toString();
    }

    public final String title() throws ParseException {
        String text;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                text = this.titletext(9);
                this.jj_consume_token(9);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                text = this.titletext(20);
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return text;
    }

    public final String titletext(int quoteType) throws ParseException {
        StringBuilder buff = new StringBuilder();
        while (this.QuoteInsideTitleLookahead(quoteType)) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 38: {
                    t = this.jj_consume_token(38);
                    break;
                }
                case 1: {
                    t = this.jj_consume_token(1);
                    break;
                }
                case 2: {
                    t = this.jj_consume_token(2);
                    break;
                }
                case 4: {
                    t = this.jj_consume_token(4);
                    break;
                }
                case 13: {
                    t = this.jj_consume_token(13);
                    break;
                }
                case 18: {
                    t = this.jj_consume_token(18);
                    break;
                }
                case 21: {
                    t = this.jj_consume_token(21);
                    break;
                }
                case 5: {
                    t = this.jj_consume_token(5);
                    break;
                }
                case 20: {
                    t = this.jj_consume_token(20);
                    break;
                }
                case 9: {
                    t = this.jj_consume_token(9);
                    break;
                }
                default: {
                    this.jj_la1[79] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            buff.append(t.image);
        }
        return buff.toString();
    }

    public final String Anything() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                t = this.jj_consume_token(4);
                break;
            }
            case 5: {
                t = this.jj_consume_token(5);
                break;
            }
            case 6: {
                t = this.jj_consume_token(6);
                break;
            }
            case 7: {
                t = this.jj_consume_token(7);
                break;
            }
            case 38: {
                t = this.jj_consume_token(38);
                break;
            }
            case 27: {
                t = this.jj_consume_token(27);
                break;
            }
            case 26: {
                t = this.jj_consume_token(26);
                break;
            }
            case 8: {
                t = this.jj_consume_token(8);
                break;
            }
            case 9: {
                t = this.jj_consume_token(9);
                break;
            }
            case 10: {
                t = this.jj_consume_token(10);
                break;
            }
            case 37: {
                t = this.jj_consume_token(37);
                t.image = this.val(t);
                break;
            }
            case 11: {
                t = this.jj_consume_token(11);
                break;
            }
            case 12: {
                t = this.jj_consume_token(12);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            case 14: {
                t = this.jj_consume_token(14);
                break;
            }
            case 15: {
                t = this.jj_consume_token(15);
                break;
            }
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 32: {
                t = this.jj_consume_token(32);
                break;
            }
            case 16: {
                t = this.jj_consume_token(16);
                break;
            }
            case 17: {
                t = this.jj_consume_token(17);
                break;
            }
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 19: {
                t = this.jj_consume_token(19);
                break;
            }
            case 20: {
                t = this.jj_consume_token(20);
                break;
            }
            case 21: {
                t = this.jj_consume_token(21);
                break;
            }
            case 1: {
                t = this.jj_consume_token(1);
                break;
            }
            case 22: {
                t = this.jj_consume_token(22);
                break;
            }
            case 24: {
                t = this.jj_consume_token(24);
                break;
            }
            case 2: {
                t = this.jj_consume_token(2);
                break;
            }
            case 25: {
                t = this.jj_consume_token(25);
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    private boolean jj_3R_108() {
        return this.jj_3R_133();
    }

    private boolean jj_3R_114() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_156() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(28)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(37)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(1)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(2)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(38)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(4)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(13)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(18)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(14)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(11)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(21)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(5)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(9)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(6)) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_83() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_39() {
        return this.jj_3R_84();
    }

    private boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_83()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(3)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(0)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_12() {
        return this.jj_3R_40();
    }

    private boolean jj_3_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(16)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(15)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(22)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(32)) {
                        return true;
                    }
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(2)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_36() {
        return this.jj_3R_84();
    }

    private boolean jj_3_10() {
        return this.jj_3R_38();
    }

    private boolean jj_3_9() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_153() {
        Token xsp;
        if (this.jj_scan_token(20)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_156());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(20);
    }

    private boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(23)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(24)) {
                    return true;
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(3)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(0)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_84() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_114()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_7() {
        return this.jj_3R_35();
    }

    private boolean jj_3_6() {
        if (this.jj_3R_34()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(3)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(0)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_131() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(2)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_106() {
        Token xsp;
        if (this.jj_3R_131()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_131());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_13() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_78() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_77() {
        return this.jj_3R_112();
    }

    private boolean jj_3R_76() {
        return this.jj_3R_111();
    }

    private boolean jj_3R_75() {
        return this.jj_3R_110();
    }

    private boolean jj_3R_74() {
        return this.jj_3R_109();
    }

    private boolean jj_3R_73() {
        return this.jj_3R_106();
    }

    private boolean jj_3_4() {
        return this.jj_3R_32();
    }

    private boolean jj_3R_72() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_155() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(28)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(37)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(1)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(2)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(38)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(4)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(13)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(18)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(14)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(11)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(21)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(5)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(20)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(6)) {
                                                                return true;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_72()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_73()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_74()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_75()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_76()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_77()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_78()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_13()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3R_71() {
        return this.jj_3R_108();
    }

    private boolean jj_3R_103() {
        return this.jj_3R_32();
    }

    private boolean jj_3R_152() {
        Token xsp;
        if (this.jj_scan_token(9)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_155());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_5()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_67() {
        return this.jj_3R_103();
    }

    private boolean jj_3_34() {
        Token xsp;
        if (this.jj_scan_token(1)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = xsp;
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_147() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_152()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_153()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_123() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(3)) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_122() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_121() {
        Token xsp;
        if (this.jj_scan_token(1)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        this.jj_scanpos = xsp;
        return this.jj_3R_147();
    }

    private boolean jj_3R_92() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(38)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_121());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(1));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_123()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_35() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_148() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_35()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_92()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_33() {
        return this.jj_3R_61();
    }

    private boolean jj_3R_125() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_33()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_148()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_93() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_124()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_125()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_124() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_69()) {
            return true;
        }
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_102() {
        return this.jj_3R_106();
    }

    private boolean jj_3_31() {
        return this.jj_3R_61();
    }

    private boolean jj_3R_49() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_69()) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_93()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_101() {
        return this.jj_3R_69();
    }

    private boolean jj_3R_63() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_102()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_100() {
        return this.jj_scan_token(1);
    }

    private boolean jj_3_29() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_62() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_100()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(3)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_101()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(17);
    }

    private boolean jj_3_28() {
        return this.jj_3R_49();
    }

    private boolean jj_3_27() {
        return this.jj_3R_47();
    }

    private boolean jj_3_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_60() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_59() {
        return this.jj_3R_98();
    }

    private boolean jj_3R_58() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_57() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_56() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_55() {
        return this.jj_3R_97();
    }

    private boolean jj_3R_54() {
        return this.jj_3R_96();
    }

    private boolean jj_3R_53() {
        return this.jj_3R_95();
    }

    private boolean jj_3_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_54()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_55()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_56()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_57()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_58()) {
                                this.jj_scanpos = xsp;
                                this.jj_lookingAhead = true;
                                this.jj_semLA = this.getToken(1).none(17, 3, 0);
                                this.jj_lookingAhead = false;
                                if (!this.jj_semLA || this.jj_3R_59()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_60()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_50() {
        Token xsp;
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3_30()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_30());
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(17)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_32()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_120() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_119() {
        return this.jj_scan_token(4);
    }

    private boolean jj_3R_118() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_91() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_117()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_118()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_119()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_120()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_117() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_90() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_47() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_90());
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(38)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_91());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_51() {
        return this.jj_3R_94();
    }

    private boolean jj_3_26() {
        Token xsp = this.jj_scanpos;
        this.jj_lookingAhead = true;
        this.jj_semLA = this.getToken(1).none(3, 27);
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_51()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_52()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_40() {
        Token xsp;
        if (this.jj_scan_token(26)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_26());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_129() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_128() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_20() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_97() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_127()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_128()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_129()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_127() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3_21() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_96() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3_25() {
        return this.jj_3R_50();
    }

    private boolean jj_3_24() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_95() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(36)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(35)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_23() {
        return this.jj_3R_48();
    }

    private boolean jj_3_22() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_98() {
        return this.jj_3R_94();
    }

    private boolean jj_3R_144() {
        return this.jj_3R_98();
    }

    private boolean jj_3R_143() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_142() {
        return this.jj_3R_49();
    }

    private boolean jj_3R_141() {
        return this.jj_3R_48();
    }

    private boolean jj_3R_140() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_139() {
        return this.jj_3R_97();
    }

    private boolean jj_3R_138() {
        return this.jj_3R_96();
    }

    private boolean jj_3R_137() {
        return this.jj_3R_95();
    }

    private boolean jj_3R_113() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_137()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_138()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_139()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_140()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_141()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_142()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_143()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_144()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_79() {
        Token xsp;
        if (this.jj_3R_113()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_113());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_41() {
        return this.jj_3R_79();
    }

    private boolean jj_3R_46() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_151() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3_19() {
        Token xsp = this.jj_scanpos;
        this.jj_lookingAhead = true;
        this.jj_semLA = this.ParagraphLookahead();
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_44()) {
            this.jj_scanpos = xsp;
            this.jj_lookingAhead = true;
            this.jj_semLA = this.ListLookahead();
            this.jj_lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_45()) {
                this.jj_scanpos = xsp;
                this.jj_lookingAhead = true;
                this.jj_semLA = this.LooseLookahead();
                this.jj_lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_46()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_136() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(16)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(15)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(22)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_151()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_126() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_104() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(2)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(11)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_112() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_135());
        this.jj_scanpos = xsp;
        return this.jj_3R_136();
    }

    private boolean jj_3R_94() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(4)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(5)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(6)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(7)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(38)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(27)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(26)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(8)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(9)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(10)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_126()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(11)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(12)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(13)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(14)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(15)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(23)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(32)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(16)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(17)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(18)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(19)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(20)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(21)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(1)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(22)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(24)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(2)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(25)) {
                                                                                                                            return true;
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_70() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_68() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_104()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_146() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_32() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_68()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_3R_69()) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_70()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_61();
    }

    private boolean jj_3R_157() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(38)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(1)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(2)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(4)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(18)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(21)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(5)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(20)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(9)) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_154() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_157());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_150() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_3R_154()) {
            return true;
        }
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_149() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_3R_154()) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private boolean jj_3_14() {
        return this.jj_3R_33();
    }

    private boolean jj_3R_132() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_149()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_150()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_145() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(4)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(6)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(5)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(7)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(35)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(38)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(28)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(26)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(27)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(8)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(9)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(29)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(30)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(31)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(10)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(37)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(11)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(32)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(36)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(12)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(13)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(14)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(15)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(23)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(16)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(17)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(18)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(19)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(20)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(21)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(1)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(22)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(24)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(25)) {
                                                                                                                                                return true;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_116() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_145()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_146()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_89() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_65() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(0)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_86() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_116());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(38)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(4)) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_65()) {
                    this.jj_scanpos = xsp;
                    this.jj_lookingAhead = true;
                    this.jj_semLA = this.parentheses > 0;
                    this.jj_lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_66()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(12)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(17)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(8)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(21)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(5)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(19)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(10)) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_17() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_85() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_115()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(2)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_115() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_scan_token(1)) {
            return true;
        }
        return this.jj_scan_token(1);
    }

    private boolean jj_3R_64() {
        Token xsp;
        if (this.jj_3_37()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_37());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_37() {
        if (this.jj_3R_85()) {
            return true;
        }
        return this.jj_3R_86();
    }

    private boolean jj_3_36() {
        return this.jj_3R_64();
    }

    private boolean jj_3_16() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_130() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_64()) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_88() {
        return this.jj_3R_106();
    }

    private boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_88()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(3);
    }

    private boolean jj_3_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(0)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_99() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_36()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_110() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_87() {
        return this.jj_3R_84();
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_87()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_107() {
        if (this.jj_3R_106()) {
            return true;
        }
        return this.jj_3R_132();
    }

    private boolean jj_3R_61() {
        if (this.jj_3R_99()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_107()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_111() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_134() {
        return this.jj_3R_84();
    }

    private boolean jj_3R_82() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3R_81() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_109() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_134()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_scan_token(25)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(23)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(24)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_80() {
        Token xsp;
        if (this.jj_scan_token(10)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(10));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_105() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(4)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(5)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(8)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(10)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(11)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(12)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(13)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(14)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(18)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(21)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(1)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(2)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(38)) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        return this.jj_3R_33();
    }

    private boolean jj_3R_69() {
        Token xsp;
        if (this.jj_3R_105()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_105());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_34() {
        if (this.jj_3R_79()) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_81()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_82()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_133() {
        return this.jj_scan_token(19);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{8, 524288, 6, 6, 2, 2, 6, 9, 524288, 524288, 524288, 524288, 524288, 524288, 1024, 0x808400, 2, 0x3800000, 2054, 2, 2, 6, 6, 6, -10, -14, -10, 2, 2, 2, 2, 6, 2054, 2054, 2054, 2054, 4292608, 4292608, 6, 6, 6, 6, 2054, 2054, -268435456, 0xFFFFFF6, 0, -536870912, 8, 0x200000, 2098192, 2098192, -268435456, 8, 2, 8, 2391350, 6, 12298, 2, 6, 12290, 12290, 2, 2, 0x200800, 16384, 271870070, 271870070, 270822006, 270822006, 0x100200, 2391350, 2391350, 6, 16384, 8208, 2757920, 0x100200, 3416630, 0xFFFFFF6};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 121, 121, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 24, 97, 24, 0, 0, 0, 64, 64, 24, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 96, 96, 96, 0, 64, 64, 0, 0, 64, 0, 0, 64, 97};
    }

    public Parser(InputStream stream) {
        this(stream, null);
    }

    public Parser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jjtree.reset();
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[39];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 81; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 39; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 37; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        Parser.jj_la1_init_0();
        Parser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

