/*
 * Decompiled with CFR 0.152.
 */
package org.tautua.markdownpapers;

import java.io.IOException;
import org.tautua.markdownpapers.ast.CharRef;
import org.tautua.markdownpapers.ast.Code;
import org.tautua.markdownpapers.ast.CodeSpan;
import org.tautua.markdownpapers.ast.CodeText;
import org.tautua.markdownpapers.ast.Comment;
import org.tautua.markdownpapers.ast.Document;
import org.tautua.markdownpapers.ast.Emphasis;
import org.tautua.markdownpapers.ast.Header;
import org.tautua.markdownpapers.ast.Image;
import org.tautua.markdownpapers.ast.InlineUrl;
import org.tautua.markdownpapers.ast.Item;
import org.tautua.markdownpapers.ast.Line;
import org.tautua.markdownpapers.ast.LineBreak;
import org.tautua.markdownpapers.ast.Link;
import org.tautua.markdownpapers.ast.List;
import org.tautua.markdownpapers.ast.Node;
import org.tautua.markdownpapers.ast.Paragraph;
import org.tautua.markdownpapers.ast.Quote;
import org.tautua.markdownpapers.ast.Resource;
import org.tautua.markdownpapers.ast.ResourceDefinition;
import org.tautua.markdownpapers.ast.Ruler;
import org.tautua.markdownpapers.ast.SimpleNode;
import org.tautua.markdownpapers.ast.Tag;
import org.tautua.markdownpapers.ast.TagAttribute;
import org.tautua.markdownpapers.ast.Text;
import org.tautua.markdownpapers.ast.Visitor;
import org.tautua.markdownpapers.util.Utils;

public class HtmlEmitter
implements Visitor {
    private Appendable buffer;

    public HtmlEmitter(Appendable buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(CharRef node) {
        this.append(node.getValue());
    }

    @Override
    public void visit(Code node) {
        this.append("<pre><code>");
        this.visitChildrenAndAppendSeparator(node, '\n');
        this.append("</code></pre>");
        this.append('\n');
    }

    @Override
    public void visit(CodeSpan node) {
        this.append("<code>");
        this.escapeAndAppend(node.getText());
        this.append("</code>");
    }

    @Override
    public void visit(CodeText node) {
        this.escapeAndAppend(node.getValue());
    }

    @Override
    public void visit(Comment node) {
        this.append("<!--");
        this.append(node.getText());
        this.append("-->");
    }

    @Override
    public void visit(Document node) {
        this.visitChildrenAndAppendSeparator(node, '\n');
    }

    @Override
    public void visit(Emphasis node) {
        switch (node.getType()) {
            case ITALIC: {
                this.append("<em>");
                this.append(node.getText());
                this.append("</em>");
                break;
            }
            case BOLD: {
                this.append("<strong>");
                this.append(node.getText());
                this.append("</strong>");
                break;
            }
            case ITALIC_AND_BOLD: {
                this.append("<strong><em>");
                this.append(node.getText());
                this.append("</em></strong>");
            }
        }
    }

    @Override
    public void visit(Header node) {
        String level = String.valueOf(node.getLevel());
        this.append("<h");
        this.append(level);
        this.append(">");
        node.childrenAccept(this);
        this.append("</h");
        this.append(level);
        this.append(">");
        this.append('\n');
    }

    @Override
    public void visit(Image node) {
        Resource resource = node.getResource();
        if (resource == null) {
            this.append("<img src=\"\" alt=\"");
            this.escapeAndAppend(node.getText());
            this.append("\"/>");
        } else {
            this.append("<img");
            this.append(" src=\"");
            this.escapeAndAppend(resource.getLocation());
            if (node.getText() != null) {
                this.append("\" alt=\"");
                this.escapeAndAppend(node.getText());
            }
            if (resource.getHint() != null) {
                this.append("\" title=\"");
                this.escapeAndAppend(resource.getHint());
            }
            this.append("\"/>");
        }
    }

    @Override
    public void visit(InlineUrl node) {
        this.append("<a href=\"");
        this.escapeAndAppend(node.getUrl());
        this.append("\">");
        this.escapeAndAppend(node.getUrl());
        this.append("</a>");
    }

    @Override
    public void visit(Item node) {
        this.append("<li>");
        node.childrenAccept(this);
        this.append("</li>");
        this.append('\n');
    }

    @Override
    public void visit(Line node) {
        node.childrenAccept(this);
    }

    @Override
    public void visit(LineBreak node) {
        Line l = (Line)node.jjtGetParent();
        if (!l.isEnding()) {
            this.append("<br/>");
        }
    }

    @Override
    public void visit(Link node) {
        Resource resource = node.getResource();
        if (resource == null) {
            if (node.isReferenced()) {
                this.append("[");
                node.childrenAccept(this);
                this.append("]");
                if (node.getReference() != null) {
                    if (node.hasWhitespaceAtMiddle()) {
                        this.append(' ');
                    }
                    this.append("[");
                    this.append(node.getReference());
                    this.append("]");
                }
            } else {
                this.append("<a href=\"\">");
                node.childrenAccept(this);
                this.append("</a>");
            }
        } else {
            this.append("<a");
            this.append(" href=\"");
            this.escapeAndAppend(resource.getLocation());
            if (resource.getHint() != null) {
                this.append("\" title=\"");
                this.escapeAndAppend(resource.getHint());
            }
            this.append("\">");
            node.childrenAccept(this);
            this.append("</a>");
        }
    }

    @Override
    public void visit(ResourceDefinition node) {
    }

    @Override
    public void visit(List node) {
        if (node.isOrdered()) {
            this.append("<ol>");
            this.append('\n');
            node.childrenAccept(this);
            this.append("</ol>");
        } else {
            this.append("<ul>");
            this.append('\n');
            node.childrenAccept(this);
            this.append("</ul>");
        }
        this.append('\n');
    }

    @Override
    public void visit(Paragraph node) {
        Node parent = node.jjtGetParent();
        if (parent instanceof Item && !((Item)parent).isLoose()) {
            this.visitChildrenAndAppendSeparator(node, '\n');
            return;
        }
        this.append("<p>");
        this.visitChildrenAndAppendSeparator(node, '\n');
        this.append("</p>");
        this.append('\n');
    }

    @Override
    public void visit(Ruler node) {
        this.append("<hr/>");
        this.append('\n');
    }

    @Override
    public void visit(Quote node) {
        this.append("<blockquote>");
        this.append('\n');
        node.childrenAccept(this);
        this.append("</blockquote>");
        this.append('\n');
    }

    @Override
    public void visit(SimpleNode node) {
        throw new IllegalArgumentException("can not process this element");
    }

    @Override
    public void visit(Tag node) {
        this.append("<");
        this.append(node.getName());
        for (TagAttribute attribute : node.getAttributes()) {
            this.append(' ');
            this.append(attribute.getName());
            this.append("=\"");
            this.append(attribute.getValue());
            this.append("\"");
        }
        if (node.jjtGetNumChildren() == 0) {
            this.append("/>");
        } else {
            this.append(">");
            node.childrenAccept(this);
            this.append("</");
            this.append(node.getName());
            this.append(">");
        }
    }

    @Override
    public void visit(Text node) {
        this.escapeAndAppend(node.getValue());
    }

    void visitChildrenAndAppendSeparator(Node node, char separator) {
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            node.jjtGetChild(i).accept(this);
            if (i >= count - 1) continue;
            this.append(separator);
        }
    }

    void escapeAndAppend(String val) {
        for (char character : val.toCharArray()) {
            this.append(Utils.escape(character));
        }
    }

    void append(String val) {
        try {
            this.buffer.append(val);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void append(char val) {
        try {
            this.buffer.append(val);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

