/*
 * Decompiled with CFR 0.152.
 */
package models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import models.IMenu;
import play.Logger;
import play.db.jpa.GenericModel;
import play.db.jpa.JPABase;
import play.db.jpa.JPQL;
import play.db.jpa.Model;
import play.mvc.Scope;
import play.utils.Utils;

@Entity
@Table(name="_menu")
public class _Menu
extends Model
implements IMenu {
    @Column(unique=true)
    public String name;
    public String cssClass;
    public String url;
    public String title;
    public String context;
    @Transient
    public Set<String> labels;
    private String labelStr_;
    @ManyToOne
    public _Menu parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    public List<_Menu> children;

    @PrePersist
    private void setLabels_() {
        Logger.debug((String)"saving labels ...", (Object[])new Object[0]);
        if (null == this.labels) {
            return;
        }
        this.labelStr_ = Utils.join(this.labels, (String)",");
    }

    @PostLoad
    private void loadLabels_() {
        Logger.debug((String)"loading labels ...", (Object[])new Object[0]);
        if (this.labelStr_ == null) {
            this.labelStr_ = "";
        }
        this.labels = new HashSet<String>(Arrays.asList(this.labelStr_.split(",")));
    }

    public String toString() {
        return this.name;
    }

    public static _Menu findByName(String name) {
        return (_Menu)_Menu.find("byName", name).first();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    @Override
    public String getCssClass() {
        return this.cssClass;
    }

    @Override
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    @Override
    public void setLabels(Set<String> label) {
        if (null == label) {
            return;
        }
        this.labels = new HashSet<String>(label);
    }

    @Override
    public IMenu getParentMenu() {
        return this.parent;
    }

    @Override
    public List<IMenu> getSubMenus() {
        ArrayList<IMenu> l = new ArrayList<IMenu>(this.children);
        return l;
    }

    @Override
    public List<IMenu> getSubMenusByContext(String context) {
        ArrayList<IMenu> l = new ArrayList<IMenu>();
        for (_Menu m : this.children) {
            if (!context.equalsIgnoreCase(m.getContext())) continue;
            l.add(m);
        }
        return l;
    }

    @Override
    public List<IMenu> getSubMenusByLabel(String label) {
        ArrayList<IMenu> l = new ArrayList<IMenu>();
        for (_Menu m : this.children) {
            if (!m.hasLabel(label)) continue;
            l.add(m);
        }
        return l;
    }

    @Override
    public List<IMenu> getTopLevelMenus() {
        return _Menu.find("parent is null", new Object[0]).fetch();
    }

    @Override
    public List<IMenu> getTopLevelMenusByContext(String context) {
        return _Menu.find("parent is null and context = ?", context).fetch();
    }

    @Override
    public List<IMenu> getTopLevelMenusByLabel(String label) {
        List<IMenu> l0 = this.getTopLevelMenus();
        ArrayList<IMenu> l = new ArrayList<IMenu>();
        for (IMenu m : l0) {
            if (!m.hasLabel(label)) continue;
            l.add(m);
        }
        return l;
    }

    public static <T extends JPABase> T create(String name, Scope.Params params) {
        try {
            return (T)JPQL.instance.create("_Menu", name, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static long count() {
        return JPQL.instance.count("_Menu");
    }

    public static long count(String query, Object ... params) {
        return JPQL.instance.count("_Menu", query, params);
    }

    public static <T extends JPABase> List<T> findAll() {
        return JPQL.instance.findAll("_Menu");
    }

    public static <T extends JPABase> T findById(Object id) {
        try {
            return (T)JPQL.instance.findById("_Menu", id);
        }
        catch (Exception e) {
            Logger.warn((Throwable)e, (String)"Error findById(%1$s) for entity class: ", (Object[])new Object[]{id, "_Menu"});
            return null;
        }
    }

    public static GenericModel.JPAQuery find(String query, Object ... params) {
        return JPQL.instance.find("_Menu", query, params);
    }

    public static GenericModel.JPAQuery all() {
        return JPQL.instance.all("_Menu");
    }

    public static int delete(String query, Object ... params) {
        return JPQL.instance.delete("_Menu", query, params);
    }

    public static int deleteAll() {
        return JPQL.instance.deleteAll("_Menu");
    }
}

