/*
 * Decompiled with CFR 0.152.
 */
package play.modules.menu;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import models._Menu;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.jpa.JPAPlugin;
import play.mvc.Http;
import play.mvc.Scope;
import play.test.Fixtures;

public class MenuPlugin
extends PlayPlugin {
    public void onConfigurationRead() {
        if (!Boolean.parseBoolean(Play.configuration.getProperty("menu.no_def_impl", "false"))) {
            String jpaEntities = Play.configuration.getProperty("jpa.entities", "").trim();
            jpaEntities = !"".equals(jpaEntities) ? jpaEntities + ",models._Menu" : "models._Menu";
            Play.configuration.put("jpa.entities", jpaEntities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterApplicationStart() {
        if (Boolean.parseBoolean(Play.configuration.getProperty("menu.no_def_impl", "false"))) {
            Logger.info((String)"default JPA menu model disabled", (Object[])new Object[0]);
            return;
        }
        Logger.info((String)"loading menu conf...", (Object[])new Object[0]);
        JPAPlugin.startTx((boolean)false);
        try {
            if (_Menu.count() > 0L) {
                return;
            }
            Fixtures.load((String)"_menu.yml");
        }
        catch (Exception e) {
            Logger.warn((Throwable)e, (String)"error loading menu from menu.yml", (Object[])new Object[0]);
        }
        finally {
            JPAPlugin.closeTx((boolean)false);
        }
        Logger.info((String)"Menu loaded", (Object[])new Object[0]);
    }

    public void beforeActionInvocation(Method actionMethod) {
        if (Boolean.parseBoolean(Play.configuration.getProperty("menu.no_def_impl", "false"))) {
            return;
        }
        if (_Menu.count() == 0L) {
            return;
        }
        Scope.RenderArgs binding = Scope.RenderArgs.current();
        Http.Request request = Http.Request.current();
        binding.put("_menu_current", (Object)request.url);
        List<Object> topMenuList = new ArrayList();
        _Menu m = new _Menu();
        String ctx = Scope.Session.current().get("_menu.context");
        binding.put("_menu_context", (Object)ctx);
        String label = Scope.Session.current().get("_menu_label");
        binding.put("_menu_label", (Object)label);
        topMenuList = m.getTopLevelMenus();
        binding.put("_menu_top_list", topMenuList);
    }
}

