/*
 * Decompiled with CFR 0.152.
 */
package play.modules.menu;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import models.IMenu;
import play.Play;
import play.PlayPlugin;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.Scope;

public class MenuPlugin
extends PlayPlugin {
    private static IMenu prototype_ = null;
    private static Pattern p1_ = null;
    private static Pattern p2_ = null;

    public MenuPlugin() {
        p1_ = Pattern.compile("'(.*)'");
        p2_ = Pattern.compile("@\\{([\\w\\.]*).*\\}");
    }

    public static void setMenuClass(Class clz) {
        try {
            prototype_ = (IMenu)clz.newInstance();
            prototype_.loadMenu();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setMenuClass(String clzStr) {
        try {
            Class clz = Play.classloader.loadClass(clzStr);
            MenuPlugin.setMenuClass(clz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IMenu menuInstance() {
        return prototype_;
    }

    public void onConfigurationRead() {
        String jpaEntities = Play.configuration.getProperty("jpa.entities", "").trim();
        jpaEntities = !"".equals(jpaEntities) ? jpaEntities + ",models._Menu" : "models._Menu";
        Play.configuration.put("jpa.entities", jpaEntities);
    }

    private void init_() {
        String menuClass = Play.configuration.getProperty("menu.class", "models._Menu");
        MenuPlugin.setMenuClass(menuClass);
    }

    public void afterApplicationStart() {
        this.init_();
    }

    public void beforeActionInvocation(Method actionMethod) {
        Scope.RenderArgs binding = Scope.RenderArgs.current();
        Http.Request request = Http.Request.current();
        binding.put("_menu_current", (Object)request.url);
        MenuPlugin.setRenderArgs_("_menu_context");
        MenuPlugin.setRenderArgs_("_menu_label");
    }

    private static void setRenderArgs_(String name) {
        String val = Scope.Params.current().get(name);
        if (null == val) {
            val = Scope.Session.current().get(name);
        }
        if (null != val) {
            Scope.RenderArgs.current().put(name, (Object)val);
        }
    }

    public static String url(IMenu menu) {
        String s = menu.getUrl();
        if (null == s) {
            return null;
        }
        Matcher m = p1_.matcher(s = s.trim());
        if (m.find()) {
            s = m.group(1);
        }
        if ((m = p2_.matcher(s)).find()) {
            s = m.group(1);
            return Router.reverse((String)s).url;
        }
        return s;
    }
}

