/*
 * Decompiled with CFR 0.152.
 */
package models._menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import models._menu.IMenu;
import play.Logger;
import play.db.jpa.GenericModel;
import play.db.jpa.JPABase;
import play.db.jpa.JPQL;
import play.db.jpa.Model;
import play.utils.Utils;

@Entity
@Table(name="play_menu")
public class JPAMenu
extends Model
implements IMenu {
    @Column
    public String name;
    public String cssClass;
    public String url;
    public String title;
    public String context;
    @Transient
    public Set<String> labels;
    private String labelStr_;
    @ManyToOne
    public JPAMenu parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    public List<JPAMenu> children;

    @PrePersist
    private void setLabels_() {
        Logger.debug((String)"saving labels ...", (Object[])new Object[0]);
        if (null == this.labels) {
            return;
        }
        this.labelStr_ = Utils.join(this.labels, (String)",");
    }

    @PostLoad
    private void loadLabels_() {
        Logger.debug((String)"loading labels ...", (Object[])new Object[0]);
        this.labels = this.labelStr_ == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(this.labelStr_.split(",")));
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.url.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JPAMenu) {
            JPAMenu that = (JPAMenu)o;
            return that._key().equals(this._key());
        }
        return false;
    }

    public static JPAMenu findByName(String name) {
        return (JPAMenu)JPAMenu.find("byName", name).first();
    }

    @Override
    public Object _getId() {
        return this.getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    @Override
    public String getCssClass() {
        return this.cssClass;
    }

    @Override
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public boolean hasLabel(String label) {
        if (null == label) {
            return this.labels.size() == 0;
        }
        return this.labels.contains(label);
    }

    @Override
    public void setLabels(Collection<String> label) {
        if (null == label) {
            return;
        }
        this.labels = new HashSet<String>(label);
    }

    @Override
    public IMenu getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IMenu parent) {
        this.parent = (JPAMenu)parent;
    }

    @Override
    public List<IMenu> getSubMenus() {
        ArrayList<IMenu> l = new ArrayList<IMenu>(this.children);
        return l;
    }

    @Override
    public List<IMenu> getSubMenusByLabel(String label) {
        ArrayList<IMenu> l = new ArrayList<IMenu>();
        for (JPAMenu m : this.children) {
            if (!m.hasLabel(label)) continue;
            l.add(m);
        }
        return l;
    }

    @Override
    public List<IMenu> _topLevelMenus() {
        return JPAMenu.find("parent is null", new Object[0]).fetch();
    }

    @Override
    public List<IMenu> _topLevelMenusByLabel(String label) {
        List<IMenu> l0 = this._topLevelMenus();
        ArrayList<IMenu> l = new ArrayList<IMenu>();
        for (IMenu m : l0) {
            if (!m.hasLabel(label)) continue;
            l.add(m);
        }
        return l;
    }

    @Override
    public List<IMenu> _all() {
        return JPAMenu.findAll();
    }

    @Override
    public IMenu _newInstance() {
        return new JPAMenu();
    }

    @Override
    public long _count() {
        return JPAMenu.count();
    }

    @Override
    public IMenu _findById(String id) {
        return (JPAMenu)JPAMenu.findById(id);
    }

    @Override
    public void _purge() {
        JPAMenu.deleteAll();
    }

    public static long count() {
        return JPQL.instance.count("JPAMenu");
    }

    public static <T extends JPABase> List<T> findAll() {
        return JPQL.instance.findAll("JPAMenu");
    }

    public static <T extends JPABase> T findById(Object id) {
        try {
            return (T)JPQL.instance.findById("JPAMenu", id);
        }
        catch (Exception e) {
            Logger.warn((Throwable)e, (String)"Error findById(%1$s) for entity class: ", (Object[])new Object[]{id, "JPAMenu"});
            return null;
        }
    }

    public static GenericModel.JPAQuery find(String query, Object ... params) {
        return JPQL.instance.find("JPAMenu", query, params);
    }

    public static int deleteAll() {
        return JPQL.instance.deleteAll("JPAMenu");
    }
}

