/*
 * Decompiled with CFR 0.152.
 */
package play.modules.menu;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import models._menu.IMenu;
import models._menu.JPAMenu;
import org.yaml.snakeyaml.Yaml;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.jpa.JPAPlugin;
import play.modules.menu.MenuCache;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.Scope;
import play.templates.TemplateLoader;
import play.vfs.VirtualFile;

public class MenuPlugin
extends PlayPlugin {
    public static final String VERSION = "1.1b";
    private static IMenu fact_ = null;
    private static final Pattern P_K = Pattern.compile("([^(]+)\\(([^)]+)\\)");
    private static Pattern p1_ = null;
    private static Pattern p2_ = null;
    private static MenuCache cache_ = new MenuCache();

    public MenuPlugin() {
        p1_ = Pattern.compile("'(.*)'");
        p2_ = Pattern.compile("@\\{([\\w\\.]*).*\\}");
    }

    private static String msg_(String msg, Object ... args) {
        return String.format("MenuPlugin-1.1b> %1$s", String.format(msg, args));
    }

    private static void setMenuClass_(String clzStr) {
        Logger.info((String)MenuPlugin.msg_("set menu class: %s", clzStr), (Object[])new Object[0]);
        try {
            Class clz = Play.classloader.loadClass(clzStr);
            fact_ = (IMenu)clz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IMenu menuInstance() {
        try {
            return fact_._newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isJPAModel_() {
        return JPAMenu.class.equals(fact_.getClass());
    }

    public void onConfigurationRead() {
        this.init_();
        if (MenuPlugin.isJPAModel_()) {
            String jpaEntities = Play.configuration.getProperty("jpa.entities", "").trim();
            jpaEntities = !"".equals(jpaEntities) ? jpaEntities + ",models._menu.JPAMenu" : "models._menu.JPAMenu";
            Play.configuration.put("jpa.entities", jpaEntities);
        }
    }

    private void init_() {
        Properties p = Play.configuration;
        String menuClass = p.getProperty("menu.class");
        if (null == menuClass) {
            for (PlayPlugin pp : Play.pluginCollection.getEnabledPlugins()) {
                String cn = pp.getClass().getName();
                if (!cn.contains("Morphia") && !cn.contains("Mongo")) continue;
                menuClass = "models._menu.MongoMenu";
                break;
            }
        }
        if (null == menuClass) {
            menuClass = "models._menu.JPAMenu";
        }
        MenuPlugin.setMenuClass_(menuClass);
    }

    public static void load(String ... ymlFiles) {
        VirtualFile vf = MenuPlugin.virtualFile_(ymlFiles);
        if (null == vf) {
            return;
        }
        MenuPlugin._purge();
        MenuPlugin.load_(vf);
    }

    private static void load_(VirtualFile yamlFile) {
        Logger.info((String)MenuPlugin.msg_("loading menu from yaml file: %s", yamlFile.relativePath()), (Object[])new Object[0]);
        String renderedYaml = TemplateLoader.load((VirtualFile)yamlFile).render();
        Yaml yaml = new Yaml();
        try {
            MenuPlugin.startTx_();
            Object o = yaml.load(renderedYaml);
            if (o instanceof LinkedHashMap) {
                HashMap<String, IMenu> all = new HashMap<String, IMenu>();
                Map objects = (Map)o;
                HashMap<Object, String> parents = new HashMap<Object, String>();
                for (Object key : objects.keySet()) {
                    String id = key.toString().trim();
                    Matcher matcher = P_K.matcher(id);
                    if (matcher.matches()) {
                        id = matcher.group(2);
                    }
                    Map mm = (Map)objects.get(key);
                    String name = (String)mm.get("name");
                    String url = (String)mm.get("url");
                    String cssClass = (String)mm.get("cssClass");
                    String title = (String)mm.get("title");
                    List labels = (List)mm.get("labels");
                    String parent = (String)mm.get("parent");
                    IMenu menu = MenuPlugin.menuInstance();
                    menu.setName(name);
                    menu.setUrl(url);
                    menu.setCssClass(cssClass);
                    menu.setTitle(title);
                    if (null != labels) {
                        menu.setLabels(labels);
                    }
                    menu._save();
                    if (null != parent) {
                        parents.put(menu._getId(), parent);
                    }
                    all.put(id, menu);
                }
                for (IMenu menu : all.values()) {
                    String parent = (String)parents.get(menu._getId());
                    if (null == parent) continue;
                    if (all.containsKey(parent)) {
                        menu.setParent((IMenu)all.get(parent));
                        menu._save();
                        continue;
                    }
                    throw new RuntimeException("cannot find parent[" + parent + "] in men yaml file : " + yamlFile.relativePath());
                }
            } else {
                throw new RuntimeException("menu yml format not reconized: " + yamlFile.relativePath());
            }
            MenuPlugin.commitTx_();
        }
        catch (Exception e) {
            MenuPlugin.rollbackTx_();
            throw new RuntimeException(e);
        }
    }

    private static VirtualFile virtualFile_(String ... fileNames) {
        if (fileNames.length == 0) {
            return null;
        }
        for (String fn : fileNames) {
            VirtualFile vf = VirtualFile.search((Collection)Play.javaPath, (String)fn);
            if (null == vf) continue;
            return vf;
        }
        return null;
    }

    private void load_() {
        MenuPlugin.startTx_();
        IMenu m = MenuPlugin.menuInstance();
        if (0L < m._count()) {
            if ("yml".equalsIgnoreCase(Play.configuration.getProperty("menu.loadFrom", "db"))) {
                Logger.info((String)MenuPlugin.msg_("Force loading menus from yaml file. clean up menu database ...", new Object[0]), (Object[])new Object[0]);
                m._purge();
            } else {
                MenuPlugin.commitTx_();
                return;
            }
        }
        MenuPlugin.commitTx_();
        String fileName = Play.configuration.getProperty("menu.yamlFile", "_menu.yml");
        VirtualFile yamlFile = MenuPlugin.virtualFile_(fileName);
        if (yamlFile == null) {
            Logger.warn((String)MenuPlugin.msg_("Couldn't find menu plugin initial file: %s", fileName), (Object[])new Object[0]);
            return;
        }
        MenuPlugin.load_(yamlFile);
    }

    private static void startTx_() {
        if (MenuPlugin.isJPAModel_()) {
            JPAPlugin.startTx((boolean)false);
        }
    }

    private static void commitTx_() {
        if (MenuPlugin.isJPAModel_()) {
            JPAPlugin.closeTx((boolean)false);
        }
    }

    private static void rollbackTx_() {
        if (MenuPlugin.isJPAModel_()) {
            JPAPlugin.closeTx((boolean)true);
        }
    }

    public void afterApplicationStart() {
        this.load_();
    }

    public void beforeActionInvocation(Method actionMethod) {
        Scope.RenderArgs binding = Scope.RenderArgs.current();
        Http.Request request = Http.Request.current();
        binding.put("_menu_current", (Object)request.url);
        MenuPlugin.setRenderArgs_("_menu_context");
        MenuPlugin.setRenderArgs_("_menu_label");
    }

    private static void setRenderArgs_(String name) {
        String val = Scope.Params.current().get(name);
        if (null == val) {
            val = Scope.Session.current().get(name);
        }
        if (null != val) {
            Scope.RenderArgs.current().put(name, (Object)val);
        }
    }

    public static String url(IMenu menu) {
        String s = menu.getUrl();
        if (null == s) {
            return null;
        }
        Matcher m = p1_.matcher(s = s.trim());
        if (m.find()) {
            s = m.group(1);
        }
        if ((m = p2_.matcher(s)).find()) {
            s = m.group(1);
            return Router.reverse((String)s).url;
        }
        return s;
    }

    static List<IMenu> allMenus() {
        return fact_._all();
    }

    public static MenuPlugin instance() {
        return (MenuPlugin)Play.pluginCollection.getPluginInstance(MenuPlugin.class);
    }

    private static boolean cacheEnabled_() {
        String s = Play.configuration.getProperty("menu.cache", "false");
        return Boolean.parseBoolean(s);
    }

    public static List<IMenu> getSubMenus(IMenu parentMenu) {
        if (MenuPlugin.cacheEnabled_()) {
            return cache_.getSubMenus(parentMenu);
        }
        return parentMenu.getSubMenus();
    }

    public static List<IMenu> getSubMenusByLabel(IMenu parentMenu, String label) {
        if (MenuPlugin.cacheEnabled_()) {
            return cache_.getSubMenusByLabel(parentMenu, label);
        }
        return parentMenu.getSubMenusByLabel(label);
    }

    public static IMenu _find(String id) {
        if (MenuPlugin.cacheEnabled_()) {
            return cache_._find(id);
        }
        return fact_._findById(id);
    }

    public static List<IMenu> _topLevelMenus() {
        if (MenuPlugin.cacheEnabled_()) {
            return cache_._topLevelMenus();
        }
        return fact_._topLevelMenus();
    }

    public static List<IMenu> _topLevelMenusByLabel(String label) {
        if (MenuPlugin.cacheEnabled_()) {
            return cache_._topLevelMenusByLabel(label);
        }
        return fact_._topLevelMenusByLabel(label);
    }

    public static void _purge() {
        fact_._purge();
    }
}

