/*
 * Decompiled with CFR 0.152.
 */
package play.modules.messages;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import play.Play;
import play.libs.IO;
import play.modules.messages.MessagesResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessagesResource
extends MessagesResource {
    File targetDir = new File(Play.configuration.getProperty("messages.targetDir", "conf"));

    @Override
    public List<String> loadKeepList() {
        try {
            File file = new File(this.targetDir, "messages.keep");
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            List result = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            IOUtils.closeQuietly((InputStream)in);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> loadIgnoreList() {
        try {
            File file = new File(this.targetDir, "messages.ignore");
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            List result = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            IOUtils.closeQuietly((InputStream)in);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> loadMessages(String language) {
        try {
            File file = new File(this.targetDir, "messages." + language);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            Properties properties = IO.readUtf8Properties((InputStream)in);
            IOUtils.closeQuietly((InputStream)in);
            return new HashMap<Object, Object>(properties);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveKeepList(List<String> list) {
        File file = new File(this.targetDir, "messages.keep");
        try {
            Collections.sort(list);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.writeLines(list, null, (OutputStream)out, (String)"UTF-8");
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveIgnoreList(List<String> list) {
        File file = new File(this.targetDir, "messages.ignore");
        try {
            Collections.sort(list);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.writeLines(list, null, (OutputStream)out, (String)"UTF-8");
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveMessages(String language, Map<String, String> messages, List<String> removeList) {
        try {
            File file = new File(this.targetDir, "messages." + language);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            Properties properties = new Properties();
            properties.putAll(messages);
            for (String key : removeList) {
                properties.remove(key);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter stringWriter = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            properties.store(stringWriter, "");
            IOUtils.closeQuietly((Writer)stringWriter);
            InputStreamReader lineReader = new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), "UTF-8");
            String propertiesAsString = IOUtils.toString((Reader)lineReader);
            String[] lines = StringUtils.split((String)propertiesAsString, (String)"\n");
            ArrayList<String> list = new ArrayList<String>();
            for (String line : lines) {
                if (line.trim().length() <= 0 || line.startsWith("#")) continue;
                list.add(line);
            }
            Collections.sort(list);
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            String content = StringUtils.join(list, (String)"\n");
            content = "# Saved by @messages on " + new Date() + "\n" + content;
            IOUtils.write((String)content, (Writer)fileWriter);
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

