/*
 * Decompiled with CFR 0.152.
 */
package play.modules.messages;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageKeyMatcher {
    String REGEXP1 = "\\QMessages.get(\"\\E([^\"]*)\"";
    String REGEXP2 = "\\QValidation\\E\\Q.addError(\\E[^,]*,[^\"]*[\"]([^\"]*)\"";
    String REGEXP3 = "\\Q&{\\E[']([^']*)[']";
    String REGEXP4 = "\\Qmessages\\E\\Q.get(\"\\E([^\"]*)\"";
    String REGEXP5 = "\\Qmessages\\E\\Q.get('\\E([^']*)'";
    String REGEXP6 = "\\Qi18n('\\E([^']*)'";
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public MessageKeyMatcher() {
        this.patterns.add(Pattern.compile(this.REGEXP1));
        this.patterns.add(Pattern.compile(this.REGEXP2));
        this.patterns.add(Pattern.compile(this.REGEXP3));
        this.patterns.add(Pattern.compile(this.REGEXP4));
        this.patterns.add(Pattern.compile(this.REGEXP5));
        this.patterns.add(Pattern.compile(this.REGEXP6));
    }

    public List<String> match(String s) {
        ArrayList<String> list = new ArrayList<String>();
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(s);
            int start = 0;
            while (matcher.find(start) && matcher.groupCount() == 1) {
                list.add(matcher.group(1));
                start = matcher.end();
            }
        }
        return list;
    }
}

