/*
 * Decompiled with CFR 0.152.
 */
package play.modules.messages;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import play.Play;
import play.modules.messages.MessageKeyMatcher;
import play.utils.HTML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceKeys {
    private Map<String, KeySourceList> keys = new HashMap<String, KeySourceList>();

    public static SourceKeys lookUp() {
        String[] paths;
        SourceKeys foundKeys = new SourceKeys();
        MessageKeyMatcher matcher = new MessageKeyMatcher();
        String s = Play.configuration.getProperty("messages.srcDir", "app");
        for (String path : paths = s.split(Pattern.quote(","))) {
            Iterator iterator = FileUtils.iterateFiles((File)new File(path), (String[])new String[]{"java", "html", "js"}, (boolean)true);
            while (iterator.hasNext()) {
                try {
                    File file = (File)iterator.next();
                    List lines = IOUtils.readLines((Reader)new FileReader(file));
                    int i = 0;
                    for (String line : lines) {
                        List<String> keys = matcher.match(line);
                        for (String key : keys) {
                            String snippet = SourceKeys.getSnippet(key, i, lines);
                            foundKeys.addKey(key, file, snippet, i);
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return foundKeys;
    }

    private static String getSnippet(String key, int line, List<String> lines) {
        int start = Math.max(0, line - 2);
        int end = Math.min(line + 2, lines.size() - 1);
        StringBuilder snippet = new StringBuilder();
        for (int i = start; i <= end; ++i) {
            String s = lines.get(i);
            s = HTML.htmlEscape((String)s);
            if (i == line) {
                s = s.replace(key, "</pre><pre class=\"k\">" + key + "</pre><pre class=\"co\">");
            }
            snippet.append("<div class=\"line").append(i % 2 == 0 ? " even" : " odd").append(i == line ? " focus" : "").append("\"><pre class=\"lno\">").append(String.format("% 4d", i + 1)).append(":</pre><pre class=\"co\">").append(s).append("</pre></div>");
        }
        return snippet.toString();
    }

    public void addKey(String foundKey, File file, String snippet, int lineNo) {
        KeySourceList key = this.keys.get(foundKey);
        if (key == null) {
            key = new KeySourceList(foundKey);
            this.keys.put(foundKey, key);
        }
        key.addSource(file, snippet, lineNo);
    }

    public KeySourceList getKeySourceList(String key) {
        KeySourceList list = this.keys.get(key);
        if (list == null) {
            list = new KeySourceList(key);
        }
        return list;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        TreeMap<String, KeySourceList> map = new TreeMap<String, KeySourceList>(this.keys);
        for (String key : map.keySet()) {
            builder.append(map.get(key));
            builder.append("\n");
        }
        return builder.toString();
    }

    public Set<String> keySet() {
        return this.keys.keySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeySourceList {
        public HashMap<String, SourceFile> sourceFiles = new HashMap();
        public String foundKey;

        public KeySourceList(String foundKey) {
            this.foundKey = foundKey;
        }

        public List<SourceFile> listSourceFiles() {
            ArrayList<SourceFile> list = new ArrayList<SourceFile>(this.sourceFiles.values());
            Collections.sort(list);
            return list;
        }

        public void addSource(File file, String snippet, int lineNo) {
            SourceFile sourceFile = this.sourceFiles.get(file.getPath());
            if (sourceFile == null) {
                sourceFile = new SourceFile(file.getPath());
                this.sourceFiles.put(file.getPath(), sourceFile);
            }
            sourceFile.addSnippet(snippet, lineNo);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class SourceFile
        implements Comparable<SourceFile> {
            public String path;
            public List<Snippet> snippets = new ArrayList<Snippet>();

            public SourceFile(String path) {
                this.path = path;
            }

            public void addSnippet(String snippet, int lineNo) {
                this.snippets.add(new Snippet(snippet, lineNo));
            }

            public List<Snippet> listSnippets() {
                Collections.sort(this.snippets);
                return this.snippets;
            }

            @Override
            public int compareTo(SourceFile o) {
                return this.path.compareTo(o.path);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Snippet
            implements Comparable<Snippet> {
                public String snippet;
                public int lineNo;

                public Snippet(String snippet, int lineNo) {
                    this.snippet = snippet;
                    this.lineNo = lineNo;
                }

                @Override
                public int compareTo(Snippet o) {
                    return new Integer(this.lineNo).compareTo(o.lineNo);
                }
            }
        }
    }
}

