/*
 * Decompiled with CFR 0.152.
 */
package play.modules.messages;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import play.Play;
import play.libs.IO;
import play.modules.messages.MessagesResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessagesResource
extends MessagesResource {
    protected File targetDir;
    String defaultLanguage;

    public DefaultMessagesResource() {
        String applicationPath = Play.applicationPath.getPath();
        String separator = System.getProperty("file.separator");
        this.targetDir = new File(applicationPath + separator + Play.configuration.getProperty("messages.targetDir", "conf"));
        this.defaultLanguage = Play.configuration.getProperty("messages.defaultLanguage", "");
    }

    @Override
    public List<String> loadKeepList() {
        try {
            File file = new File(this.targetDir, "messages.keep");
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            List result = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            IOUtils.closeQuietly((InputStream)in);
            return result;
        }
        catch (FileNotFoundException e) {
            return new ArrayList<String>();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> loadIgnoreList() {
        try {
            File file = new File(this.targetDir, "messages.ignore");
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            List result = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            IOUtils.closeQuietly((InputStream)in);
            return result;
        }
        catch (FileNotFoundException e) {
            return new ArrayList<String>();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> loadMessages(String language) {
        try {
            File file = this.getMessagesFile(language);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            Properties properties = IO.readUtf8Properties((InputStream)in);
            IOUtils.closeQuietly((InputStream)in);
            return new HashMap<Object, Object>(properties);
        }
        catch (FileNotFoundException e) {
            return new HashMap<String, String>();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void save(String language, String key, String value) {
        Map<String, String> messages = this.loadMessages(language);
        messages.put(key, value);
        this.saveMessages(language, messages);
    }

    @Override
    public void keep(String key) {
        List<String> keepList = this.loadKeepList();
        if (!keepList.contains(key)) {
            keepList.add(key);
            this.saveKeepList(keepList);
        }
    }

    @Override
    public void removeKeep(String key) {
        List<String> keepList = this.loadKeepList();
        if (keepList.contains(key)) {
            keepList.remove(key);
            this.saveKeepList(keepList);
        }
    }

    @Override
    public void removeAll(String language, List<String> keys) {
        Map<String, String> messages = this.loadMessages(language);
        messages.keySet().removeAll(keys);
        this.saveMessages(language, messages);
    }

    @Override
    public void ignoreAll(List<String> keys) {
        List<String> ignoreList = this.loadIgnoreList();
        ignoreList.removeAll(keys);
        ignoreList.addAll(keys);
        this.saveIgnoreList(ignoreList);
    }

    @Override
    public void unignoreAll(List<String> keys) {
        List<String> ignoreList = this.loadIgnoreList();
        ignoreList.removeAll(keys);
        this.saveIgnoreList(ignoreList);
    }

    protected void saveKeepList(List<String> list) {
        File file = new File(this.targetDir, "messages.keep");
        try {
            Collections.sort(list);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.writeLines(list, null, (OutputStream)out, (String)"UTF-8");
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void saveIgnoreList(List<String> list) {
        File file = new File(this.targetDir, "messages.ignore");
        try {
            Collections.sort(list);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            IOUtils.writeLines(list, null, (OutputStream)out, (String)"UTF-8");
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void saveMessages(String language, Map<String, String> messages) {
        try {
            File file = this.getMessagesFile(language);
            Properties properties = new Properties();
            properties.putAll(messages);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter stringWriter = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            properties.store(stringWriter, "");
            IOUtils.closeQuietly((Writer)stringWriter);
            InputStreamReader lineReader = new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), "UTF-8");
            String propertiesAsString = IOUtils.toString((Reader)lineReader);
            String[] lines = StringUtils.split((String)propertiesAsString, (String)"\n");
            ArrayList<String> list = new ArrayList<String>();
            for (String line : lines) {
                if (line.trim().length() <= 0 || line.startsWith("#")) continue;
                list.add(line);
            }
            Collections.sort(list);
            BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            String content = StringUtils.join(list, (String)"\n");
            content = "# Saved by @messages on " + new Date() + "\n" + content;
            IOUtils.write((String)content, (Writer)fileWriter);
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getMessagesFile(String language) {
        if (language.equals(DEFAULT_LANGUAGE)) {
            return new File(this.targetDir, this.defaultLanguage.isEmpty() ? "messages" : "messages." + this.defaultLanguage);
        }
        return new File(this.targetDir, "messages." + language);
    }
}

