package tags.mocha;

import groovy.lang.Closure;

import java.io.PrintWriter;
import java.util.Map;

import play.Play;
import play.exceptions.TemplateCompilationException;
import play.mvc.Scope.RenderArgs;
import play.mvc.Router.ActionDefinition;
import play.templates.FastTags;
import play.templates.GroovyTemplate.ExecutableTemplate;
import play.templates.JavaExtensions;

@SuppressWarnings("nls")
public final class mochaTags extends FastTags {

    /**
     * <p>Generates an HTML5 <code>&lt;mochaInclude&gt;</code> element with some values derived from a given field.</p>
     * 
     * @param args      The tag attributes.
     * @param body      The tag body.
     * @param out       The print writer to use.
     * @param template  The parent template.
     * @param fromLine  The current execution line.
     */
    public static void _mochaDesktop(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {
        out.println("<div id=\"desktop\"");
        for (Map.Entry<?, ?> e : args.entrySet()) {
            try {
                out.print(" " + (String) e.getKey() + "=");
                out.print("\"" + (String) e.getValue() + "\"");
            } catch (Exception ex) {
            }
        }
        out.println(">");
        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException ex) {
        }
        out.println("</div>");
    }

    public static void _mochaPage(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {
        out.println("<div id=\"pageWrapper\"");
        for (Map.Entry<?, ?> e : args.entrySet()) {
            try {
                out.print(" " + (String) e.getKey() + "=");
                out.print("\"" + (String) e.getValue() + "\"");
            } catch (Exception ex) {
            }
        }
        out.println(">");
        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException ex) {
        }
        out.println("</div>");
    }

    public static void _mochaOpenWindow(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {

        String element = (String) args.get("element");
        String otherClass = (String) args.get("class");
        String id = (String) args.get("id");
        if (element == null) {
            element = "div";
        }

        if (otherClass == null) {
            otherClass = "";
        }

        out.println("<" + element + " class=\"openWindow " + otherClass + "\"");
        if (id != null) {
            out.println(" id=\"" + id + "\"");
        }

        for (Map.Entry<?, ?> e : args.entrySet()) {
            String key = (String) e.getKey();
            String classsName = e.getValue().getClass().getName();

            if (!key.equals("element") && !key.equals("class") && !key.equals("id")) {
                out.print(" data-window-" + key + "=");
                if (classsName.equals("play.mvc.Router$ActionDefinition")) {
                    ActionDefinition adUrl = (ActionDefinition) e.getValue();
                    out.print("\"" + adUrl.url + "\"");
                } else {
                    try {
                        out.print("\"" + (String) e.getValue() + "\"");
                    } catch (Exception ex) {
                    }

                }
            }
        }
        out.print(">");
        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }
        out.println("</" + element + ">");
    }

    public static void _mochaDock(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {

        out.println("<div id=\"dockWrapper\"");
        for (Map.Entry<?, ?> e : args.entrySet()) {
            out.print(" " + (String) e.getKey() + "=");
            out.print("\"" + (String) e.getValue() + "\"");
        }
        out.print(">");

        out.print("<div id=\"dock\">"
                + "<div id=\"dockPlacement\" ></div>"
                + "<div id=\"dockAutoHide\"></div>"
                + "<div id=\"dockSort\"><div id=\"dockClear\" class=\"clear\"></div>"
                + "</div>");

        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }

        out.println("</div></div>");
    }

    
    public static void _mochaDesktopHeader(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {

        out.println("<div id=\"desktopHeader\"");
        for (Map.Entry<?, ?> e : args.entrySet()) {
            try {
                out.print(" " + (String) e.getKey() + "=");
                out.print("\"" + (String) e.getValue() + "\"");
            } catch (Exception ex) {
            }

        }
        out.print(">");

        out.print("<div id=\"desktopTitlebarWrapper\">");

        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }
        out.println("</div></div>");
    }
                
    public static void _mochaDesktopFooter(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {

        out.println("<div id=\"desktopFooterWrapper\"");
        for (Map.Entry<?, ?> e : args.entrySet()) {
            try {
                out.print(" " + (String) e.getKey() + "=");
                out.print("\"" + (String) e.getValue() + "\"");
            } catch (Exception ex) {
            }

        }
        out.print(">");

        out.print("<div id=\"desktopFooter\">");

        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }
        out.println("</div></div>");
    }

    public static void _mochaCreateTab(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {

        String element = (String) args.get("element");
        String otherClass = (String) args.get("class");
        String id = (String) args.get("id");
        if (element == null) {
            element = "div";
        }

        if (otherClass == null) {
            otherClass = "";
        }

        out.println("<" + element + " class=\"createTab " + otherClass + "\"");
        if (id != null) {
            out.println(" id=\"" + id + "\"");
        }

        for (Map.Entry<?, ?> e : args.entrySet()) {
            String key = (String) e.getKey();
            String classsName = e.getValue().getClass().getName();

            if (!key.equals("element") && !key.equals("class") && !key.equals("id")) {
                out.print(" data-tab-" + key + "=");
                if (classsName.equals("play.mvc.Router$ActionDefinition")) {
                    ActionDefinition adUrl = (ActionDefinition) e.getValue();
                    out.print("\"" + adUrl.url + "\"");
                } else {
                    try {
                        out.print("\"" + (String) e.getValue() + "\"");
                    } catch (Exception ex) {
                    }
                }
            }
        }
        out.print(">");
        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }
        out.println("</" + element + ">");
    }

    public static void _mochaSubmit(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {

        String otherClass = (String) args.get("class");
        String id = (String) args.get("id");

        if (otherClass == null) {
            otherClass = "";
        }

        out.println("<button class=\"ajaxSubmit " + otherClass + "\" type=\"submit\" ");
        if (id != null) {
            out.println(" id=\"" + id + "\"");
        }

        for (Map.Entry<?, ?> e : args.entrySet()) {
            String key = (String) e.getKey();
            String classsName = e.getValue().getClass().getName();

            if (!key.equals("class") && !key.equals("id")) {
                out.print(" " + key + "=");
                try {
                    out.print("\"" + (String) e.getValue() + "\"");
                } catch (Exception ex) {
                }

            }
        }
        out.print(">");
        try {
            out.print(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }
        out.print("</button>");
    }

    public static void _mochaTabs(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {
        String otherClass = (String) args.get("class");
        if (otherClass == null) {
            otherClass = "";
        }

        out.println("<div >");
        out.print("<ul class=\"tab-menu " + otherClass + "\" ");

        for (Map.Entry<?, ?> e : args.entrySet()) {
            String key = (String) e.getKey();
            if (!key.equals("class")) {
                try {
                    out.print(" " + key + "=");
                    out.print("\"" + (String) e.getValue() + "\"");
                } catch (Exception ex) {
                }
            }

        }
        out.print(">");

        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }

        out.println("</ul>");
        out.println("<div class=\"clear\"></div>");
        out.println("</div>");
    }

    public static void _mochaTab(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {
        ActionDefinition tabUrl = (ActionDefinition) args.get("url");
        Boolean selected = (Boolean) args.get("selected");
        String otherClass = (String) args.get("class");
        String title = (String) args.get("title");

        if (otherClass == null) {
            otherClass = "";
        }

        if (title == null) {
            title = "";
        }

        out.print("<li class=\"" + otherClass);
        if (selected != null && selected) {
            out.print(" selected");
        }

        out.print("\" ");

        for (Map.Entry<?, ?> e : args.entrySet()) {
            String key = (String) e.getKey();
            if (!key.equals("selected") && !key.equals("url") && !key.equals("class") && !key.equals("title")) {
                try {
                    out.print(" " + key + "=");
                    out.print("\"" + (String) e.getValue() + "\"");
                } catch (Exception ex) {
                }
            }

        }
        out.println(">");
        out.print("<a href=\"" + tabUrl.url + "\" title=\"" + title + "\" >");
        try {
            out.print(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }
        out.println("</a>");
        out.println("</li>");
    }

    public static void _mochaColumn(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {
        out.println("<div class=\"mochaColumn\" ");

        for (Map.Entry<?, ?> e : args.entrySet()) {
            String key = (String) e.getKey();
            try {
                out.print(" data-column-" + key + "=");
                out.print("\"" + (String) e.getValue() + "\"");
            } catch (Exception ex) {
            }

        }
        out.print(">");
        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }
        out.println("</div>");
    }

    public static void _mochaPanel(final Map<?, ?> args, final Closure body, final PrintWriter out,
            final ExecutableTemplate template, final int fromLine) {
        out.println("<div class=\"mochaPanel\" ");

        for (Map.Entry<?, ?> e : args.entrySet()) {
            String key = (String) e.getKey();
            String classsName = e.getValue().getClass().getName();
            try {
                out.print(" data-panel-" + key + "=");
                if (classsName.equals("play.mvc.Router$ActionDefinition")) {
                    ActionDefinition adUrl = (ActionDefinition) e.getValue();
                    out.print("\"" + adUrl.url + "\"");
                } else {
                    out.print("\"" + (String) e.getValue() + "\"");
                }
            } catch (Exception ex) {
            }
        }
        out.print(">");

        try {
            out.println(JavaExtensions.toString(body));
        } catch (java.lang.NullPointerException e) {
        }
        out.println("</div>");
    }
}