var eventBinder = new Class({
  
    //implements
    Implements: [Options],

    //options
    options: {
    },
    
    //initialization
    initialize: function(options) {
        //set options
        this.setOptions(options);
    },
  
    //CREATE WINDOWS
    createWindow: function(newWindowsOption) {
        var self = this;
        var objWindowOption = self.rewriteOptions('windowOption',newWindowsOption,'data-window-');
        objWindowOption.id = uniqid('window');
        if(objWindowOption['toolbarURL'])
            objWindowOption.toolbar = true;
        
        objWindowOption.onContentLoaded = function(ele){
            //bind the content of windows
            self.binder(ele)
        };
        objWindowOption.toolbarOnload = function(){
            //CREATE TABS
            var idWindow = objWindowOption.id;
            var arrTabs = $(idWindow).getElements('.tab-menu');
            var idTab = arrTabs[0].getProperty('id') + uniqid('id');
            arrTabs[0].setProperty("id",idTab);
            MUI.initializeTabs(arrTabs[0].getProperty('id'),idWindow);
        };
        
        //if type is modal -> create a modal window
        if(objWindowOption.type == 'modal')
            new MUI.Modal(objWindowOption);
        else
            new MUI.Window(objWindowOption);
            
//        var divElement  = new Element('div');
//        divElement.setProperty('id',idWindow+'_helpButton');
//        divElement.setProperty('title','help');
//        divElement.setProperty('class','mochaHelpButton mochaWindowButton replaced');
//        divElement.appendText('?');
//        divElement.inject($$('#'+idWindow+' .mochaControls')[0],'top');
    },
    
    createColumn: function(newColumnOption){
        var objColumnOption = this.rewriteOptions('columnOption',newColumnOption,'data-column-');
        new MUI.Column(objColumnOption);
    },
    createPanel: function(newPanelOption){
        var self = this;
        var objPanelOption = this.rewriteOptions('panelOption',newPanelOption,'data-panel-');
        objPanelOption.id = uniqid('panel');
        objPanelOption.onContentLoaded = function(ele){
            //bind the content of panels
            var idElement = ele.id;
            self.bindWindow(idElement);
            self.bindTab(idElement);
            self.bindForms(idElement);
        }
        objPanelOption.tabsOnload = function(){
            //CREATE TABS
            var idPanel = objPanelOption.id;
            var idTab = $$('#'+idPanel+'_header .tab-menu')[0].getProperty('id');
            MochaUI.initializeTabs(idTab, idPanel);
        }
        new MUI.Panel(objPanelOption);
    },
  
    binder: function (ele){
        var self = this;
        var idElement = '';
        if(ele)
            idElement = ele.id;
        
        //if there are columns, content is bind into panels, else bind content into desktop
        if(!self.bindColumn(idElement)){
            self.bindWindow(idElement);
            self.bindTab(idElement);
            self.bindForms(idElement);
        }
    },
    
    //BIND COLUMNS AND PANELS FROM HTML
    bindColumn : function(idElement){
        var self = this;
        var bolHasColumn = false;
        
        //BIND COLUMNS
        var arrColumn = $$('#'+idElement+' .mochaColumn');
        if(arrColumn[0]){
            bolHasColumn = true;
            arrColumn.each(function(newColumn){
                var columnOption = self.getDataProperties(newColumn);
                var parentElement = newColumn.getParent();
                var arrPanel = new Array();
                
                //BIND PANELS INSIDE COLUMNS
                var allPanels = newColumn.getElements('.mochaPanel');
                if(allPanels[0]){
                    var index = 0;
                    allPanels.each(function(newPanel){
                        var columnParentId = newPanel.getParent().getProperty('data-column-id');
                        arrPanel[index] = self.getDataProperties(newPanel);
                        if(columnParentId)
                            arrPanel[index]['data-panel-column'] = columnParentId;
                        index++;
                    });
                }
                parentElement.removeChild(newColumn);
                self.createColumn(columnOption);
                if(allPanels[0]){
                    arrPanel.each(function(panelOption){
                        self.createPanel(panelOption);
                    });
                }
            });
        }
        return bolHasColumn;
    },
    
    
    //BIND THE CREATION OF WINDOWS DYNAMICALY
    bindWindow : function(idElement){
      var self = this;
      var arrWindowLink = $$('#'+idElement+' .openWindow');
      if(arrWindowLink){
            arrWindowLink.addEvent('click',function(evt){
                new Event(evt).stop()
                var windowsOption = self.getDataProperties(evt.target);
                self.createWindow(windowsOption);
            });
        }  
    },
    
    
    //BIND THE CREATION OF TABS DYNAMICALY
    bindTab : function(idElement){
        var self = this;
        var arrCreateTabLink = $$('#'+idElement+' .createTab');
        if(arrCreateTabLink){
            arrCreateTabLink.addEvent('click',function(evt){
                new Event(evt).stop()
                var url = evt.target.getProperty('data-tab-url');
                var title = evt.target.getProperty('data-tab-title');
                var text = evt.target.getProperty('data-tab-text');
                
                //When you create a panel, its "id" is the id panel ( uniqid(panel) )+_wrapper
                if(idElement.substr(0,5) == 'panel'){
                    var ulElement = $$('#'+idElement+'_wrapper .tab-menu')[0];
                }
                else{
                    var ulElement = $$('#'+idElement+' .tab-menu')[0];
                }
               
                var liElement  = new Element('li');
                var aElement = new Element('a', {
                    href: url,
                    title: title
                });
                aElement.appendText(text);
                aElement.inject(liElement);
                liElement.inject(ulElement);
                
                MUI.initializeTabs(ulElement.getProperty('id'),idElement);
                MUI.selected(liElement, ulElement.getProperty('id'));
                MUI.updateContent({
                    'element':  $(idElement),
                    'url':      url
                });
            });
        }
    },
    
    
    //BIND AJAX FORM
    bindForms : function(idElement){
        var self = this;
        var arrSubmitButton = $$('#'+idElement+' .ajaxSubmit');
        if(arrSubmitButton){
            var formElement = arrSubmitButton.getParent(); 
            
            formElement.addEvent('submit', function(evt){
                // Stops the submission of the form.
                new Event(evt).stop();

                // Sends the form to the action path,
                var parentEle = this.getParent();
                this.set('send', {
                    noCache: true,
                    onRequest: function(){
                    // show some rotating loader gif...
                    },
                    onComplete: function(response) {
                        parentEle.set('html',response);
                        self.binder(parentEle);
                    },
                    onFailure: function(){
                        alert("Request Aborted.");
                    }
                }).send();
            });
        }
    },
    
    
    //Rewrite all default options if needed
    rewriteOptions : function(strOptionName,newOptions,prefix){
        var objOption = $unlink(this.options[strOptionName]);
        for(keyName in objOption){
            if(typeof newOptions[prefix+keyName] != undefined){
                if(prefix == 'data-panel-'){
                }
                if(newOptions[prefix+keyName.toLowerCase()]){
                    objOption[keyName] = newOptions[prefix+keyName.toLowerCase()];
                }
            }
        }
        return objOption;
    },
    
    
    //Get All "data-" properties of an HTML DOM Element
    getDataProperties : function(ele){
        var arrDataProperties = new Array();
        if(ele){
            var objProperties = ele.attributes;
            for(index in objProperties){
                if(typeof objProperties[index] == 'object' && objProperties[index].name.substring(0,5) == 'data-'){
                    arrDataProperties[objProperties[index].name.toLowerCase()] = objProperties[index].value;
                }
            }
        }
        return arrDataProperties;
    }
});