window.addEvent('load', function(){
    MUI.myChain = new Chain();
	MUI.myChain.chain(
		function(){MUI.Desktop.initialize();},
		function(){MUI.Dock.initialize();}
	).callChain();
    var evtBinder = new eventBinder(g_options);
    evtBinder.binder();
});


//ALL ELEMENTS DEFAULT OPTION, YOU CAN OVERRIDE ALL OF THEM TO SET THE PARAMETER AS PROPERTY IN MARKUPS
g_options = {
        windowOption : {
            contentURL: null,
            type: 'window',
            url: null,
            title: 'Use "title" property to set a title',
            width: 600,
            height: 300,
            loadMethod: 'xhr',
            position: 'bottom',
            
            
            icon:              false,
            require:           {
                css:           [],
                images:        [],
                js:            [],
                onload:        null
            },
            method:	       'get',
            data:              null,

            closeAfter:        false,

            // xhr options
            evalScripts:       true,
            evalResponse:      false,

            // html options
            content:           'Window content',

            // Toolbar
            toolbar:           false,
            toolbarPosition:   'top',
            toolbarHeight:     29,
            toolbarURL:        null,
            toolbarData:	   null,
            toolbarContent:    '',
            toolbarOnload:     $empty,

            // Toolbar
            toolbar2:           false,
            toolbar2Position:   'bottom',
            toolbar2Height:     29,
            toolbar2URL:        'pages/lipsum.html',
            toolbar2Data:	    null,
            toolbar2Content:    '',
            toolbar2Onload:     $empty,

            // Container options
            container:         null,
            restrict:          true,
            shape:             'box',

            // Window Controls
            collapsible:       true,
            minimizable:       true,
            maximizable:       true,
            closable:          true,

            // Close options
            storeOnClose:       false,

            // Modal options
            modalOverlayClose: true,

            // Draggable
            draggable:         null,
            draggableGrid:     false,
            draggableLimit:    false,
            draggableSnap:     false,

            // Resizable
            resizable:         true,
            resizeLimit:       {
                'x': [250, 2500], 
                'y': [125, 2000]
                },

            // Style options:
            addClass:          '',
            headerHeight:      25,
            footerHeight:      25,
            cornerRadius:      8,
            x:                 null,
            y:                 null,
            scrollbars:        true,
            padding:   		   {
                top: 10, 
                right: 12, 
                bottom: 10, 
                left: 12
            },
            shadowBlur:        5,
            shadowOffset:      {
                'x': 0, 
                'y': 1
            },
            controlsOffset:    {
                'right': 6, 
                'top': 6
            },
            useCanvas:         true,
            useCanvasControls: true,
            useSpinner:        true,

            // Color options:
            headerStartColor:  [250, 250, 250],
            headerStopColor:   [229, 229, 229],
            bodyBgColor:       [229, 229, 229],
            minimizeBgColor:   [255, 255, 255],
            minimizeColor:     [0, 0, 0],
            maximizeBgColor:   [255, 255, 255],
            maximizeColor:     [0, 0, 0],
            closeBgColor:      [255, 255, 255],
            closeColor:        [0, 0, 0],
            resizableColor:    [254, 254, 254],

            // Events
            onBeforeBuild:     $empty,
            onContentLoaded:   $empty,
            onFocus:           $empty,
            onBlur:            $empty,
            onResize:          $empty,
            onMinimize:        $empty,
            onMaximize:        $empty,
            onRestore:         $empty,
            onClose:           $empty,
            onCloseComplete:   $empty
        },
        columnOption : {
            id: uniqid('column'),
            placement: 'main',
            width: 220,
            resizeLimit: [200, 300],
            sortable: true,
            isCollapsed: false,
            container:     null, //It's automaticaly fill

            // Events
            onResize:     $empty,
            onCollapse:   $empty,
            onExpand:     $empty
        },
        panelOption : {
            contentURL: null,
            title: 'Use "title" property to set a title',
            column: null,       //It's automaticaly fill
            require:  {
                css: ['/public/stylesheets/'+MUI.themePath() + 'css/Tabs.css']
            },
            loadMethod: 'xhr',
            sections: null,
            
            // xhr options
            method:             'get',
            data:               null,
            evalScripts:        true,
            evalResponse:       false,

            // html options
            content:            'Panel content',

            // Tabs
            tabsURL:            null,
            tabsData:           null,
            tabsOnload:         $empty,

            header:             true,
            headerToolbox:      false,
            headerToolboxURL:   'pages/lipsum.html',
            headerToolboxOnload: $empty,

            // Style options:
            height:             330,
            addClass:           '',
            scrollbars:         true,
            padding:   		    {
                top: 8, 
                right: 8, 
                bottom: 8, 
                left: 8
            },

            // Other:
            collapsible:	    true,

            // Events
            onBeforeBuild:       $empty,
            onContentLoaded:     $empty,
            onResize:            $empty,
            onCollapse:          $empty,
            onExpand:            $empty
        }
    };

function uniqid (prefix, more_entropy) {
    // +   original by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // +    revised by: Kankrelune (http://www.webfaktory.info/)
    // %        note 1: Uses an internal counter (in php_js global) to avoid collision
    // *     example 1: uniqid();
    // *     returns 1: 'a30285b160c14'
    // *     example 2: uniqid('foo');
    // *     returns 2: 'fooa30285b1cd361'
    // *     example 3: uniqid('bar', true);
    // *     returns 3: 'bara20285b23dfd1.31879087'
    if (typeof prefix == 'undefined') {
        prefix = "";
    }
 
    var retId;
    var formatSeed = function (seed, reqWidth) {
        seed = parseInt(seed, 10).toString(16); // to hex str
        if (reqWidth < seed.length) { // so long we split
            return seed.slice(seed.length - reqWidth);
        }
        if (reqWidth > seed.length) { // so short we pad
            return Array(1 + (reqWidth - seed.length)).join('0') + seed;
        }
        return seed;
    };
 
    // BEGIN REDUNDANT
    if (!this.php_js) {
        this.php_js = {};
    }
    // END REDUNDANT
    if (!this.php_js.uniqidSeed) { // init seed with big random int
        this.php_js.uniqidSeed = Math.floor(Math.random() * 0x75bcd15);
    }
    this.php_js.uniqidSeed++;
 
    retId = prefix; // start with prefix, add current milliseconds hex string
    retId += formatSeed(parseInt(new Date().getTime() / 1000, 10), 8);
    retId += formatSeed(this.php_js.uniqidSeed, 5); // add seed hex string
    if (more_entropy) {
        // for more entropy we add a float lower to 10
        retId += (Math.random() * 10).toFixed(8).toString();
    }
 
    return retId;
}

