/*
 * Decompiled with CFR 0.152.
 */
package play.modules.mongo;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ObjectId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import play.modules.mongo.MongoDB;
import play.modules.mongo.MongoMapper;
import play.modules.mongo.MongoModel;

public class MongoCursor {
    public DBCursor cursor;
    public Class clazz;

    public MongoCursor(DBCursor cursor, Class clazz) {
        this.cursor = cursor;
        this.clazz = clazz;
    }

    public <T extends MongoModel> List<T> fetch(int page, int length) {
        ArrayList<MongoModel> resultList = new ArrayList<MongoModel>();
        if (length != 0) {
            this.cursor.limit(length);
        }
        if (page > 1) {
            this.cursor.skip((page - 1) * length);
        }
        while (this.cursor.hasNext()) {
            DBObject dbObject = this.cursor.next();
            Map map = dbObject.toMap();
            try {
                ObjectId id = ObjectId.massageToObjectId(map.remove("_id"));
                MongoModel model = (MongoModel)MongoMapper.convertValue(map, this.clazz);
                model.set_id(id);
                resultList.add(model);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public <T extends MongoModel> List<T> fetch(int limit) {
        return this.fetch(1, limit);
    }

    public <T extends MongoModel> List<T> fetch() {
        return this.fetch(0);
    }

    public <T extends MongoModel> T first() {
        return (T)((MongoModel)this.fetch(1, 1).get(0));
    }

    public MongoCursor from(int from) {
        this.cursor.skip(from);
        return this;
    }

    public MongoCursor order(String orderBy) {
        DBObject order = MongoDB.createOrderDbObject(orderBy);
        this.cursor.sort(order);
        return this;
    }
}

