/*
 * Decompiled with CFR 0.152.
 */
package play.modules.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ObjectId;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import play.Logger;
import play.Play;
import play.modules.mongo.MongoCursor;
import play.modules.mongo.MongoMapper;
import play.modules.mongo.MongoModel;

public class MongoDB {
    private static Mongo mongo;
    private static DB db;
    private static String host;
    private static Integer port;
    private static String dbname;

    public static DB db() {
        if (db == null) {
            if (Play.configuration.containsKey("mongo.username") && Play.configuration.containsKey("mongo.password")) {
                String username = Play.configuration.getProperty("mongo.username");
                String passwd = Play.configuration.getProperty("mongo.password");
                MongoDB.init(username, passwd);
            } else {
                MongoDB.init();
            }
        }
        return db;
    }

    public static void init() {
        if (host == null || port == null || dbname == null) {
            host = Play.configuration.getProperty("mongo.host", "localhost");
            port = Integer.parseInt(Play.configuration.getProperty("mongo.port", "27017"));
            dbname = Play.configuration.getProperty("mongo.database", "play." + Play.configuration.getProperty("application.name"));
        }
        Logger.info((String)("initializing DB [" + host + "][" + port + "][" + dbname + "]"), (Object[])new Object[0]);
        try {
            mongo = new Mongo(host, port.intValue());
            db = mongo.getDB(dbname);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (MongoException e) {
            e.printStackTrace();
        }
    }

    public static void init(String username, String password) {
        MongoDB.init();
        db.authenticate(username, password.toCharArray());
    }

    public static void index(String collectionName, String indexString) {
        DBCollection c = MongoDB.db().getCollection(collectionName);
        DBObject indexKeys = MongoDB.createOrderDbObject(indexString);
        c.ensureIndex(indexKeys);
    }

    public static void dropIndex(String collectionName, String indexString) {
        DBCollection c = MongoDB.db().getCollection(collectionName);
        DBObject indexKeys = MongoDB.createOrderDbObject(indexString);
        c.dropIndex(indexKeys);
    }

    public static void dropIndexes(String collectionName) {
        DBCollection c = MongoDB.db().getCollection(collectionName);
        c.dropIndexes();
    }

    public static String[] getIndexes(String collectionName) {
        ArrayList<String> indexNames = new ArrayList<String>();
        DBCollection c = MongoDB.db().getCollection(collectionName);
        List indexes = c.getIndexInfo();
        for (DBObject o : indexes) {
            indexNames.add((String)o.get("name"));
        }
        return indexNames.toArray(new String[indexNames.size()]);
    }

    public static void addUser(String username, String passwd, boolean readOnly) {
        MongoDB.db().addUser(username, passwd.toCharArray());
        DBCollection c = MongoDB.db().getCollection("system.users");
        DBObject userObj = c.findOne((DBObject)new BasicDBObject("user", (Object)username));
        if (userObj != null) {
            userObj.put("readOnly", (Object)readOnly);
            c.save(userObj);
        }
    }

    public static void removeUser(String username) {
        DBCollection c = MongoDB.db().getCollection("system.users");
        DBObject userObj = c.findOne((DBObject)new BasicDBObject("user", (Object)username));
        if (userObj != null) {
            c.remove(userObj);
        }
    }

    public static boolean authenticate(String username, String password) {
        return MongoDB.db().authenticate(username, password.toCharArray());
    }

    public static long count(String collectionName) {
        return MongoDB.db().getCollection(collectionName).getCount();
    }

    public static long count(String collectionName, String query, Object[] params) {
        return MongoDB.db().getCollection(collectionName).getCount(MongoDB.createQueryDbObject(query, params));
    }

    public static MongoCursor find(String collectionName, String query, Object[] params, Class clazz) {
        return new MongoCursor(MongoDB.db().getCollection(collectionName).find(MongoDB.createQueryDbObject(query, params)), clazz);
    }

    public static MongoCursor find(String collectionName, Class clazz) {
        return new MongoCursor(MongoDB.db().getCollection(collectionName).find(), clazz);
    }

    public static <T extends MongoModel> T save(String collectionName, T model) {
        BasicDBObject dbObject = new BasicDBObject(MongoMapper.convertValue(model, Map.class));
        if (model.get_id() == null) {
            MongoDB.db().getCollection(collectionName).insert((DBObject)dbObject);
            model.set_id(ObjectId.massageToObjectId((Object)dbObject.get("_id")));
        } else {
            dbObject.removeField("_id");
            MongoDB.db().getCollection(collectionName).update((DBObject)new BasicDBObject("_id", (Object)model.get_id()), (DBObject)dbObject);
        }
        return model;
    }

    public static <T extends MongoModel> void delete(String collectionName, T model) {
        BasicDBObject dbObject = new BasicDBObject("_id", (Object)model.get_id());
        MongoDB.db().getCollection(collectionName).remove((DBObject)dbObject);
    }

    public static long delete(String collectionName, String query, Object[] params) {
        DBObject dbObject = MongoDB.createQueryDbObject(query, params);
        long deleteCount = MongoDB.db().getCollection(collectionName).getCount(dbObject);
        MongoDB.db().getCollection(collectionName).remove(dbObject);
        return deleteCount;
    }

    public static long deleteAll(String collectionName) {
        long deleteCount = MongoDB.count(collectionName);
        MongoDB.db().getCollection(collectionName).drop();
        return deleteCount;
    }

    public static DBObject createQueryDbObject(String query, Object[] values) {
        String keys = MongoDB.extractKeys(query);
        BasicDBObject object = new BasicDBObject();
        String[] keyList = keys.split(",");
        if (keyList.length > values.length) {
            throw new IllegalArgumentException("Not enough values for the keys provided");
        }
        int i = 0;
        while (i < keyList.length) {
            object.put(keyList[i].trim(), values[i]);
            ++i;
        }
        return object;
    }

    public static DBObject createOrderDbObject(String query) {
        String keys = MongoDB.extractKeys(query);
        BasicDBObject object = new BasicDBObject();
        String[] keyList = keys.split(",");
        int i = 0;
        while (i < keyList.length) {
            int value = 1;
            if (keyList[i].charAt(0) == '-') {
                value = -1;
                keyList[i] = keyList[i].substring(1);
            }
            object.put(keyList[i].trim(), (Object)value);
            ++i;
        }
        return object;
    }

    private static String extractKeys(String queryString) {
        String[] parts;
        queryString = queryString.substring(2);
        ArrayList<String> keys = new ArrayList<String>();
        String[] stringArray = parts = queryString.split("And");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.charAt(0) == '-') {
                keys.add(String.valueOf(part.charAt(0)) + String.valueOf(part.charAt(1)).toLowerCase() + part.substring(2));
            } else {
                keys.add(String.valueOf(String.valueOf(part.charAt(0)).toLowerCase()) + part.substring(1));
            }
            ++n2;
        }
        return StringUtils.join((Object[])keys.toArray(), (String)",");
    }
}

