/*
 * Decompiled with CFR 0.152.
 */
package play.modules.mongo;

import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import play.Logger;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;

public class MongoEnhancer
extends Enhancer {
    public static final String PACKAGE_NAME = "play.modules.mongo";
    public static final String OBJECT_ANNOTATION_NAME = "play.modules.mongo.MongoObject";
    public static final String ENTITY_ANNOTATION_NAME = "play.modules.mongo.MongoEntity";
    public static final String ENTITY_ANNOTATION_VALUE = "value";

    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        CtClass ctClass = this.makeClass(applicationClass);
        if (!this.hasAnnotation(ctClass, ENTITY_ANNOTATION_NAME)) {
            return;
        }
        this.enhanceMongoEntity(ctClass, applicationClass);
    }

    private void enhanceMongoEntity(CtClass ctClass, ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        this.classPool.importPackage(PACKAGE_NAME);
        String entityName = ctClass.getName();
        String collectionName = "\"default\"";
        AnnotationsAttribute attr = MongoEnhancer.getAnnotations((CtClass)ctClass);
        Annotation annotation = attr.getAnnotation(ENTITY_ANNOTATION_NAME);
        if (annotation.getMemberValue(ENTITY_ANNOTATION_VALUE) != null) {
            collectionName = annotation.getMemberValue(ENTITY_ANNOTATION_VALUE).toString();
        }
        Logger.debug((String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + "-->enhancing MongoEntity-->" + ctClass.getName() + "-->collection-->" + collectionName), (Object[])new Object[0]);
        CtMethod getCollectionName = CtMethod.make((String)("public static java.lang.String getCollectionName() { return " + collectionName + ";}"), (CtClass)ctClass);
        ctClass.addMethod(getCollectionName);
        CtField idField = new CtField(this.classPool.get("com.mongodb.ObjectId"), "_id", ctClass);
        idField.setModifiers(2);
        ctClass.addField(idField);
        CtMethod get_id = CtMethod.make((String)"public com.mongodb.ObjectId get_id() { return _id;}", (CtClass)ctClass);
        ctClass.addMethod(get_id);
        CtMethod set_id = CtMethod.make((String)"public void set_id(com.mongodb.ObjectId _id) { this._id = _id;}", (CtClass)ctClass);
        ctClass.addMethod(set_id);
        CtMethod count = CtMethod.make((String)"public static long count() { return MongoDB.count(getCollectionName());}", (CtClass)ctClass);
        ctClass.addMethod(count);
        CtMethod count2 = CtMethod.make((String)"public static long count(java.lang.String query, java.lang.Object[] params) { return MongoDB.count(getCollectionName(), query, params); }", (CtClass)ctClass);
        ctClass.addMethod(count2);
        CtMethod find = CtMethod.make((String)("public static MongoCursor find(String query, Object[] params){ return MongoDB.find(getCollectionName(),query,params," + entityName + ".class); }"), (CtClass)ctClass);
        ctClass.addMethod(find);
        CtMethod find2 = CtMethod.make((String)("public static MongoCursor find(){ return MongoDB.find(getCollectionName()," + entityName + ".class); }"), (CtClass)ctClass);
        ctClass.addMethod(find2);
        CtMethod delete = CtMethod.make((String)"public void delete() { MongoDB.delete(getCollectionName(), this); }", (CtClass)ctClass);
        ctClass.addMethod(delete);
        CtMethod delete2 = CtMethod.make((String)"public static long delete(String query, Object[] params) { return MongoDB.delete(getCollectionName(), query, params); }", (CtClass)ctClass);
        ctClass.addMethod(delete2);
        CtMethod deleteAll = CtMethod.make((String)"public static long deleteAll() { return MongoDB.deleteAll(getCollectionName()); }", (CtClass)ctClass);
        ctClass.addMethod(deleteAll);
        CtMethod save = CtMethod.make((String)("public MongoModel save() { return (MongoModel)MongoDB.save(" + entityName + ".getCollectionName(), this); }"), (CtClass)ctClass);
        ctClass.addMethod(save);
        CtMethod index = CtMethod.make((String)("public static void index(String indexString) { MongoDB.index(" + entityName + ".getCollectionName(), indexString); }"), (CtClass)ctClass);
        ctClass.addMethod(index);
        CtMethod dropIndex = CtMethod.make((String)("public static void dropIndex(String indexString) { MongoDB.dropIndex(" + entityName + ".getCollectionName(), indexString); }"), (CtClass)ctClass);
        ctClass.addMethod(dropIndex);
        CtMethod dropIndexes = CtMethod.make((String)("public static void dropIndexes() { MongoDB.dropIndexes(" + entityName + ".getCollectionName()); }"), (CtClass)ctClass);
        ctClass.addMethod(dropIndexes);
        CtMethod getIndexes = CtMethod.make((String)("public static String[] getIndexes() { return MongoDB.getIndexes(" + entityName + ".getCollectionName()); }"), (CtClass)ctClass);
        ctClass.addMethod(getIndexes);
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.detach();
    }
}

