/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

public final class StringParseUtil {
    public static boolean parseBoolean(String s, boolean d) {
        if (s == null) {
            return d;
        }
        if ((s = s.trim()).length() == 0) {
            return d;
        }
        char c = s.charAt(0);
        if (c == 't' || c == 'T' || c == 'y' || c == 'Y') {
            return true;
        }
        if (c == 'f' || c == 'F' || c == 'n' || c == 'N') {
            return false;
        }
        return d;
    }

    public static int parseInt(String s, int def) {
        return StringParseUtil.parseInt(s, def, null, true);
    }

    public static Number parseIntRadix(String s, int radix) {
        if (s == null) {
            return Double.NaN;
        }
        if ((s = s.trim()).length() == 0) {
            return Double.NaN;
        }
        int firstDigit = -1;
        int i = 0;
        if (s.charAt(0) == '-') {
            i = 1;
        }
        while (i < s.length() && Character.digit(s.charAt(i), radix) != -1) {
            ++i;
        }
        try {
            return Long.parseLong(s.substring(0, i), radix);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static int parseInt(String s, int def, int[] lastIdx, boolean allowNegative) {
        int lastDigit;
        boolean useLastIdx;
        boolean bl = useLastIdx = lastIdx != null && lastIdx.length > 0;
        if (useLastIdx) {
            lastIdx[0] = -1;
        }
        if (s == null) {
            return def;
        }
        if ((s = s.trim()).length() == 0) {
            return def;
        }
        int firstDigit = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            firstDigit = i;
            break;
        }
        if (firstDigit < 0) {
            return def;
        }
        for (lastDigit = firstDigit + 1; lastDigit < s.length() && Character.isDigit(s.charAt(lastDigit)); ++lastDigit) {
        }
        if (allowNegative && firstDigit > 0 && s.charAt(firstDigit - 1) == '-') {
            --firstDigit;
        }
        if (useLastIdx) {
            lastIdx[0] = lastDigit;
        }
        return Integer.parseInt(s.substring(firstDigit, lastDigit));
    }

    public static Number parseNumber(String s, Number def) {
        int lastDigit;
        if (s == null) {
            return def;
        }
        if ((s = s.trim()).length() == 0) {
            return def;
        }
        int firstDigit = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            firstDigit = i;
            break;
        }
        if (firstDigit < 0) {
            return def;
        }
        for (lastDigit = firstDigit + 1; lastDigit < s.length() && Character.isDigit(s.charAt(lastDigit)); ++lastDigit) {
        }
        boolean isDouble = false;
        if (firstDigit > 0 && s.charAt(firstDigit - 1) == '.') {
            --firstDigit;
            isDouble = true;
        }
        if (firstDigit > 0 && s.charAt(firstDigit - 1) == '-') {
            --firstDigit;
        }
        if (lastDigit < s.length() && s.charAt(lastDigit) == '.') {
            ++lastDigit;
            while (lastDigit < s.length() && Character.isDigit(s.charAt(lastDigit))) {
                ++lastDigit;
            }
            isDouble = true;
        }
        if (lastDigit < s.length() && s.charAt(lastDigit) == 'E') {
            ++lastDigit;
            while (lastDigit < s.length() && Character.isDigit(s.charAt(lastDigit))) {
                ++lastDigit;
            }
            isDouble = true;
        }
        String actual = s.substring(firstDigit, lastDigit);
        if (isDouble || actual.length() > 17) {
            return Double.parseDouble(actual);
        }
        if (actual.length() > 10) {
            return Long.parseLong(actual);
        }
        return Integer.parseInt(actual);
    }

    public static Number parseStrict(String s) {
        if (s.length() == 0) {
            return 0;
        }
        if (s.charAt(0) == '+') {
            s = s.substring(1);
        }
        if (s.matches("(\\+|-)?Infinity")) {
            if (s.startsWith("-")) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (s.indexOf(46) != -1 || s.equals("-0")) {
            return Double.parseDouble(s);
        }
        if (s.toLowerCase().indexOf("0x") > -1) {
            int coef;
            int n = coef = s.charAt(0) == '-' ? -1 : 1;
            if (s.length() > 17) {
                throw new RuntimeException("Can't handle a number this big: " + s);
            }
            if (s.length() > 9) {
                return (long)coef * Long.parseLong(s.substring((int)((double)coef * -0.5 + 2.5)), 16);
            }
            return coef * Integer.parseInt(s.substring((int)((double)coef * -0.5 + 2.5)), 16);
        }
        int e = s.toLowerCase().indexOf(101);
        if (e > 0) {
            double num = Double.parseDouble(s.substring(0, e));
            int exp = Integer.parseInt(s.substring(e + 1));
            return num * Math.pow(10.0, exp);
        }
        if (s.length() > 17) {
            return Double.parseDouble(s);
        }
        if (s.length() > 9) {
            return Long.parseLong(s);
        }
        return Integer.parseInt(s);
    }

    public static int parseIfInt(String s, int def) {
        if (s == null || s.length() == 0) {
            return def;
        }
        s = s.trim();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return def;
        }
        return Integer.parseInt(s);
    }
}

