/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia;

import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.Id;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.annotation.Annotation;
import play.Logger;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.modules.morphia.utils.IdGenerator;

public class MorphiaEnhancer
extends Enhancer {
    public static final String PACKAGE_NAME = "play.modules.morphia";

    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        Logger.debug((String)("Morphia> start to enhance class:" + applicationClass.name), (Object[])new Object[0]);
        this.enhanceThisClass_(applicationClass);
    }

    void enhanceThisClass_(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        boolean embedded;
        boolean addId;
        CtClass ctClass = this.makeClass(applicationClass);
        if (this.hasAnnotation(ctClass, Entity.class.getName()) || this.hasAnnotation(ctClass, Embedded.class.getName())) {
            addId = true;
            embedded = false;
            if (this.hasAnnotation(ctClass, Embedded.class.getName())) {
                addId = false;
                embedded = true;
            } else {
                for (CtField cf : ctClass.getDeclaredFields()) {
                    if (!this.hasAnnotation(cf, Id.class.getName())) continue;
                    addId = false;
                    break;
                }
                for (CtField cf : ctClass.getFields()) {
                    if (!this.hasAnnotation(cf, Id.class.getName())) continue;
                    addId = false;
                    break;
                }
            }
        } else {
            return;
        }
        this.enhance_(ctClass, applicationClass, addId, embedded);
    }

    private void enhance_(CtClass ctClass, ApplicationClasses.ApplicationClass applicationClass, boolean addId, boolean embedded) throws Exception {
        CtMethod findById;
        Logger.debug((String)("Morphia: enhancing MorphiaEntity: " + ctClass.getName()), (Object[])new Object[0]);
        this.classPool.importPackage(PACKAGE_NAME);
        String entityName = ctClass.getName();
        String className = entityName + ".class";
        CtField mf = CtField.make((String)("protected static play.db.Model.Factory mf = MorphiaPlugin.MorphiaModelLoader.getFactory(" + className + ");"), (CtClass)ctClass);
        ctClass.addField(mf);
        CtMethod getModelFactory = CtMethod.make((String)"public static play.db.Model.Factory getModelFactory() { return mf; }", (CtClass)ctClass);
        ctClass.addMethod(getModelFactory);
        if (addId) {
            Logger.debug((String)"Adding id methods to system managed ID entity: %1$s", (Object[])new Object[]{ctClass.getName()});
            Logger.debug((String)"type name: %1$s", (Object[])new Object[]{IdGenerator.getIdTypeName()});
            CtField idField = new CtField(this.classPool.get(IdGenerator.getIdTypeName()), "_id", ctClass);
            idField.setModifiers(2);
            AnnotationsAttribute aa = new AnnotationsAttribute(ctClass.getClassFile().getConstPool(), "RuntimeVisibleAnnotations");
            Annotation idAnn = new Annotation(Id.class.getName(), ctClass.getClassFile().getConstPool());
            aa.addAnnotation(idAnn);
            idField.getFieldInfo().addAttribute((AttributeInfo)aa);
            ctClass.addField(idField);
            Logger.debug((String)"ID field added to entity[%2$s]: %1$s", (Object[])new Object[]{idField.getSignature(), ctClass.getName()});
            CtMethod getId = CtMethod.make((String)"public Object getId() { return _id;}", (CtClass)ctClass);
            ctClass.addMethod(getId);
            CtMethod setId = CtMethod.make((String)("protected void setId_(Object id) { _id = (" + IdGenerator.getIdTypeName() + ")play.modules.morphia.utils.IdGenerator.processId(id);}"), (CtClass)ctClass);
            ctClass.addMethod(setId);
        } else if (!embedded) {
            Logger.debug((String)"adding id methods to user defined id entity: %1$s", (Object[])new Object[]{ctClass.getName()});
            boolean hasGetId = false;
            for (CtMethod cm : ctClass.getDeclaredMethods()) {
                if (!"getId".equals(cm.getName()) || !cm.getDeclaringClass().equals(ctClass)) continue;
                hasGetId = true;
                break;
            }
            if (!hasGetId) {
                CtMethod getId = CtMethod.make((String)"public Object getId() { return mf.keyValue(this);}", (CtClass)ctClass);
                ctClass.addMethod(getId);
            }
            CtMethod isUserDefinedId = CtMethod.make((String)"protected boolean isUserDefinedId_() {return true;}", (CtClass)ctClass);
            ctClass.addMethod(isUserDefinedId);
        } else {
            Logger.debug((String)"adding id methods to embedded entity: %1$s", (Object[])new Object[]{ctClass.getName()});
            CtMethod setId = CtMethod.make((String)"protected void setId_(Object id) {throw new UnsupportedOperationException(\"embedded object does not support this method\");}", (CtClass)ctClass);
            ctClass.addMethod(setId);
            CtMethod isEmbedded = CtMethod.make((String)"protected boolean isEmbedded_() {return true;}", (CtClass)ctClass);
            ctClass.addMethod(isEmbedded);
        }
        CtMethod all = CtMethod.make((String)("public static play.modules.morphia.Model.MorphiaQuery all() { return new play.modules.morphia.Model.MorphiaQuery(" + className + "); }"), (CtClass)ctClass);
        ctClass.addMethod(all);
        CtMethod create = CtMethod.make((String)("public static play.modules.morphia.Model create(String name, play.mvc.Scope.Params params) { Object o = play.Play.classloader.loadClass(\"" + entityName + "\").newInstance(); return ((play.modules.morphia.Model)o).edit(name, params.all()); }"), (CtClass)ctClass);
        ctClass.addMethod(create);
        CtMethod createQuery = CtMethod.make((String)("public static play.modules.morphia.Model.MorphiaQuery createQuery() { return new play.modules.morphia.Model.MorphiaQuery(" + className + "); }"), (CtClass)ctClass);
        ctClass.addMethod(createQuery);
        CtMethod find = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery find() { return createQuery(); }", (CtClass)ctClass);
        ctClass.addMethod(find);
        CtMethod find2 = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery find(String keys, java.lang.Object[] params) { return createQuery().findBy(keys.substring(2), params); }", (CtClass)ctClass);
        ctClass.addMethod(find2);
        CtMethod findAll = CtMethod.make((String)"public java.util.List findAll() {return all().asList();}", (CtClass)ctClass);
        ctClass.addMethod(findAll);
        CtMethod filter = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery filter(String property, Object value) { return (play.modules.morphia.Model.MorphiaQuery)find().filter(property, value); }", (CtClass)ctClass);
        ctClass.addMethod(filter);
        CtMethod get = CtMethod.make((String)"public static play.modules.morphia.Model get() { return (play.modules.morphia.Model)find().get(); }", (CtClass)ctClass);
        ctClass.addMethod(get);
        if (addId) {
            findById = CtMethod.make((String)"public static play.modules.morphia.Model findById(java.lang.Object id) { return filter(\"_id\", play.modules.morphia.utils.IdGenerator.processId(id)).get(); }", (CtClass)ctClass);
            ctClass.addMethod(findById);
        } else if (!embedded) {
            findById = CtMethod.make((String)"public static play.modules.morphia.Model findById(java.lang.Object id) { return (play.modules.morphia.Model)mf.findById(id); }", (CtClass)ctClass);
            ctClass.addMethod(findById);
        }
        CtMethod count = CtMethod.make((String)("public static long count() { return ds().getCount(" + className + "); }"), (CtClass)ctClass);
        ctClass.addMethod(count);
        CtMethod count2 = CtMethod.make((String)"public static long count(String keys, Object[] params) { return find(keys, params).count(); }", (CtClass)ctClass);
        ctClass.addMethod(count2);
        CtMethod deleteAll = CtMethod.make((String)"public static long deleteAll() { return delete(all()); }", (CtClass)ctClass);
        ctClass.addMethod(deleteAll);
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.detach();
    }
}

