/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBAddress;
import com.mongodb.DBApiLayer;
import com.mongodb.DBTCPConnector;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mongo {
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 1;
    final ServerAddress _addr;
    final List<ServerAddress> _addrs;
    final MongoOptions _options;
    final DBTCPConnector _connector;
    final ConcurrentMap<String, DB> _dbs = new ConcurrentHashMap<String, DB>();
    private WriteConcern _concern = WriteConcern.NORMAL;

    public static DB connect(DBAddress addr) {
        return new Mongo(addr).getDB(addr.getDBName());
    }

    public Mongo() throws UnknownHostException, MongoException {
        this(new ServerAddress());
    }

    public Mongo(String host) throws UnknownHostException, MongoException {
        this(new ServerAddress(host));
    }

    public Mongo(String host, MongoOptions options) throws UnknownHostException, MongoException {
        this(new ServerAddress(host), options);
    }

    public Mongo(String host, int port) throws UnknownHostException, MongoException {
        this(new ServerAddress(host, port));
    }

    public Mongo(ServerAddress addr) throws MongoException {
        this(addr, new MongoOptions());
    }

    public Mongo(ServerAddress addr, MongoOptions options) throws MongoException {
        this._addr = addr;
        this._addrs = null;
        this._options = options;
        this._connector = new DBTCPConnector(this, this._addr);
        this._connector._pickInitial();
    }

    public Mongo(ServerAddress left, ServerAddress right) throws MongoException {
        this(left, right, new MongoOptions());
    }

    public Mongo(ServerAddress left, ServerAddress right, MongoOptions options) throws MongoException {
        this._addr = null;
        this._addrs = Arrays.asList(left, right);
        this._options = options;
        this._connector = new DBTCPConnector(this, this._addrs);
        this._connector._pickInitial();
    }

    public Mongo(List<ServerAddress> replicaSetSeeds) throws MongoException {
        this(replicaSetSeeds, new MongoOptions());
    }

    public Mongo(List<ServerAddress> replicaSetSeeds, MongoOptions options) throws MongoException {
        this._addr = null;
        this._addrs = replicaSetSeeds;
        this._options = options;
        this._connector = new DBTCPConnector(this, this._addrs);
        this._connector._pickInitial();
    }

    public DB getDB(String dbname) {
        DB db = (DB)this._dbs.get(dbname);
        if (db != null) {
            return db;
        }
        db = new DBApiLayer(this, dbname, this._connector);
        DB temp = this._dbs.putIfAbsent(dbname, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    public List<String> getDatabaseNames() throws MongoException {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("listDatabases", (Object)1);
        CommandResult res = this.getDB("admin").command(cmd);
        if (res.getInt("ok", 0) != 1) {
            throw new MongoException("error listing databases : " + res);
        }
        List l = (List)res.get("databases");
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : l) {
            list.add(((BasicDBObject)o).getString("name"));
        }
        return list;
    }

    public void dropDatabase(String dbName) throws MongoException {
        this.getDB(dbName).dropDatabase();
    }

    public String getVersion() {
        return "2.1";
    }

    public String debugString() {
        return this._connector.debugString();
    }

    public String getConnectPoint() {
        return this._connector.getConnectPoint();
    }

    public ServerAddress getAddress() {
        return this._connector.getAddress();
    }

    public List<ServerAddress> getAllAddress() {
        List<ServerAddress> result = this._connector.getAllAddress();
        if (result == null) {
            return Arrays.asList(this.getAddress());
        }
        return result;
    }

    public void close() {
        this._connector.close();
    }

    public void setWriteConcern(WriteConcern concern) {
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        return this._concern;
    }
}

