/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.DatastoreImpl;
import com.google.code.morphia.Key;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Transient;
import com.google.code.morphia.query.Criteria;
import com.google.code.morphia.query.CriteriaContainer;
import com.google.code.morphia.query.CriteriaContainerImpl;
import com.google.code.morphia.query.FieldEnd;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.QueryImpl;
import com.google.code.morphia.query.UpdateOperations;
import com.google.code.morphia.query.UpdateOpsImpl;
import com.google.code.morphia.query.UpdateResults;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.NoResultException;
import org.apache.commons.lang.StringUtils;
import org.bson.types.CodeWScope;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.data.binding.BeanWrapper;
import play.data.binding.Binder;
import play.data.binding.ParamNode;
import play.data.binding.RootParamNode;
import play.data.validation.Validation;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.morphia.AggregationResult;
import play.modules.morphia.Blob;
import play.modules.morphia.MorphiaEvent;
import play.modules.morphia.MorphiaPlugin;
import play.modules.morphia.utils.IdGenerator;
import play.modules.morphia.utils.StringUtil;
import play.mvc.Scope;

public class Model
implements Serializable,
play.db.Model {
    public static final String ALL = "__all__";
    private static final long serialVersionUID = -719759872826848048L;
    @Transient
    private transient boolean saved_ = false;
    protected final transient Map<String, Boolean> blobFieldsTracker = new HashMap<String, Boolean>();

    public Object _key() {
        return this.getId();
    }

    public void _save() {
        this.save();
    }

    public void _delete() {
        if (this.isNew()) {
            return;
        }
        this._h_OnDelete();
        Model.ds().delete((Object)this);
        this._h_Deleted();
    }

    @Deprecated
    public static <T extends Model> T create(Class<?> type, String name, Map<String, String[]> params, Annotation[] annotations) {
        RootParamNode rootParamNode = ParamNode.convert(params);
        return Model.create((ParamNode)rootParamNode, name, type, annotations);
    }

    public static <T extends Model> T create(ParamNode rootParamNode, String name, Class<?> type, Annotation[] annotations) {
        try {
            Constructor<?> c = type.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            Object model = c.newInstance(new Object[0]);
            return Model.edit(rootParamNode, name, model, annotations);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Model> T edit(ParamNode rootParamNode, String name, Object o, Annotation[] annotations) {
        ParamNode paramNode = rootParamNode.getChild(name, true);
        ArrayList removedNodesList = new ArrayList();
        try {
            BeanWrapper bw = new BeanWrapper(o.getClass());
            HashSet fields = new HashSet();
            Class<?> clazz = o.getClass();
            while (!clazz.equals(Object.class)) {
                Collections.addAll(fields, clazz.getDeclaredFields());
                clazz = clazz.getSuperclass();
            }
            for (Field field : fields) {
                boolean isEntity = false;
                String relation = null;
                boolean multiple = false;
                boolean isEmbedded = field.isAnnotationPresent(Embedded.class);
                if (isEmbedded || field.isAnnotationPresent(Reference.class)) {
                    Class<?>[] supers;
                    isEntity = true;
                    multiple = false;
                    Class<?> clz = field.getType();
                    for (Class<?> c : supers = clz.getInterfaces()) {
                        if (!c.equals(Collection.class)) continue;
                        multiple = true;
                        break;
                    }
                    String string = relation = multiple ? ((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]).getName() : clz.getName();
                }
                if (!isEntity) continue;
                ParamNode fieldParamNode = paramNode.getChild(field.getName(), true);
                Class c = Play.classloader.loadClass(relation);
                if (!Model.class.isAssignableFrom(c)) continue;
                String keyName = Model.Manager.factoryFor((Class)c).keyName();
                if (multiple && Collection.class.isAssignableFrom(field.getType())) {
                    String[] ids;
                    AbstractCollection l = new ArrayList();
                    if (SortedSet.class.isAssignableFrom(field.getType())) {
                        l = new TreeSet();
                    } else if (Set.class.isAssignableFrom(field.getType())) {
                        l = new HashSet();
                    }
                    if ((ids = fieldParamNode.getChild(keyName, true).getValues()) == null) continue;
                    fieldParamNode.removeChild(keyName, removedNodesList);
                    for (String _id : ids) {
                        if (_id.equals("")) continue;
                        MorphiaQuery q = new MorphiaQuery(c);
                        q.filter(keyName, Binder.directBind((String)rootParamNode.getOriginalKey(), (Annotation[])annotations, (String)_id, (Class)Model.Manager.factoryFor((Class)Play.classloader.loadClass(relation)).keyType(), null));
                        try {
                            l.add(q.get());
                        }
                        catch (NoResultException e) {
                            Validation.addError((String)(name + "." + field.getName()), (String)"validation.notFound", (String[])new String[]{_id});
                        }
                    }
                    bw.set(field.getName(), o, l);
                    continue;
                }
                String[] ids = fieldParamNode.getChild(keyName, true).getValues();
                if (ids != null && ids.length > 0 && !ids[0].equals("")) {
                    MorphiaQuery q = new MorphiaQuery(c);
                    q.filter(keyName, Binder.directBind((String)rootParamNode.getOriginalKey(), (Annotation[])annotations, (String)ids[0], (Class)Model.Manager.factoryFor((Class)Play.classloader.loadClass(relation)).keyType(), null));
                    try {
                        Object to = q.get();
                        Model.edit(paramNode, field.getName(), to, field.getAnnotations());
                        paramNode.removeChild(field.getName(), removedNodesList);
                        bw.set(field.getName(), o, to);
                    }
                    catch (NoResultException e) {
                        Validation.addError((String)fieldParamNode.getOriginalKey(), (String)"validation.notFound", (String[])new String[]{ids[0]});
                        fieldParamNode.removeChild(keyName, removedNodesList);
                        if (fieldParamNode.getAllChildren().size() != 0) continue;
                        paramNode.removeChild(field.getName(), removedNodesList);
                    }
                    continue;
                }
                if (ids == null || ids.length <= 0 || !ids[0].equals("")) continue;
                bw.set(field.getName(), o, null);
                fieldParamNode.removeChild(keyName, removedNodesList);
            }
            ParamNode beanNode = rootParamNode.getChild(name, true);
            Binder.bindBean((ParamNode)beanNode, (Object)o, (Annotation[])annotations);
            Model model = (Model)o;
            return (T)model;
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
        finally {
            ParamNode.restoreRemovedChildren(removedNodesList);
        }
    }

    @Deprecated
    public static <T extends Model> T edit(Object o, String name, Map<String, String[]> params, Annotation[] annotations) {
        RootParamNode rootParamNode = ParamNode.convert(params);
        return Model.edit((ParamNode)rootParamNode, name, o, annotations);
    }

    @Deprecated
    public <T extends Model> T edit(String name, Map<String, String[]> params) {
        RootParamNode rootParamNode = ParamNode.convert(params);
        return Model.edit((ParamNode)rootParamNode, name, this, null);
    }

    public <T extends Model> T edit(ParamNode rootParamNode, String name) {
        Model.edit(rootParamNode, name, this, null);
        return (T)this;
    }

    public boolean validateAndSave() {
        if (Validation.current().valid((Object)this).ok) {
            this.save();
            return true;
        }
        return false;
    }

    public boolean validateAndCreate() {
        if (Validation.current().valid((Object)this).ok) {
            return this.create();
        }
        return false;
    }

    protected boolean isEmbedded_() {
        return false;
    }

    protected boolean isUserDefinedId_() {
        return false;
    }

    protected static Object processId_(Object id) {
        return IdGenerator.processId(id);
    }

    public <T> T getId() {
        return null;
    }

    public <T> T getId(Class<T> clazz) {
        return this.getId();
    }

    public final void setId(Object id) {
        if (null != this.getId()) {
            throw new IllegalStateException("Cannot set ID to entity with ID presented");
        }
        this.setId_(id);
    }

    protected void setId_(Object id) {
        throw new UnsupportedOperationException("Please override this method for user marked Id field entity: " + this.getClass().getName());
    }

    private void generateId_() {
        if (this.isEmbedded_()) {
            return;
        }
        if (null == this.getId()) {
            if (this.isUserDefinedId_()) {
                throw new IllegalStateException("User defined ID should be populated before persist");
            }
            this.setId_(IdGenerator.generateId(this));
        }
    }

    public static Model.Factory getModelFactory() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public String toString() {
        String id = this.getId() == null ? "empty_key" : this.getId().toString();
        return this.getClass().getSimpleName() + "[" + id + "]";
    }

    public int hashCode() {
        Object oid = this.getId();
        return null == oid ? 0 : oid.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        Object oid = this.getId();
        if (oid == null) {
            return false;
        }
        return oid.equals(((Model)other).getId());
    }

    public final boolean isNew() {
        return !this.saved_;
    }

    private void setSaved_() {
        this.saved_ = true;
    }

    public <T extends Model> T merge() {
        return (T)this;
    }

    public <T extends Model> T _update(String fieldExpr, Object ... values) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public <T extends Model> T refresh() {
        return (T)((Model)Model.ds().get((Object)this));
    }

    public static <T extends Model> MorphiaQuery all() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Model create(String name, Scope.Params params) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaQuery q() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaQuery createQuery() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaQuery disableValidation() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static long count() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static long count(String keys, Object ... params) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Set<?> _distinct(String key) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Long _max(String field) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static AggregationResult groupMax(String field, String ... groupKeys) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Long _min(String field) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static AggregationResult groupMin(String field, String ... groupKeys) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Long _average(String field) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static AggregationResult groupAverage(String field, String ... groupKeys) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Long _sum(String field) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static AggregationResult groupSum(String field, String ... groupKeys) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static AggregationResult groupCount(String field, String ... groupKeys) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Map<String, Long> _cloud(String field) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public <T extends Model> T delete() {
        if (this.isNew()) {
            Logger.warn((String)"invocation of delete on new entity ignored", (Object[])new Object[0]);
            return (T)this;
        }
        this._delete();
        return (T)this;
    }

    private void _h_OnDelete() {
        Model.postEvent_(MorphiaEvent.ON_DELETE, this);
        MorphiaPlugin.onLifeCycleEvent(MorphiaEvent.ON_DELETE, this);
        this.h_OnDelete();
        this.deleteBlobs();
    }

    protected void h_OnDelete() {
    }

    private void _h_Deleted() {
        this.h_Deleted();
        MorphiaPlugin.onLifeCycleEvent(MorphiaEvent.DELETED, this);
        Model.postEvent_(MorphiaEvent.DELETED, this);
    }

    protected void h_Deleted() {
    }

    protected void h_OnBatchDelete(MorphiaQuery q) {
    }

    protected void h_BatchDeleted(MorphiaQuery q) {
    }

    protected void deleteBlobs() {
    }

    protected void deleteBlobsInBatch(MorphiaQuery q) {
    }

    public boolean create() {
        if (this.isNew()) {
            this._save();
            return true;
        }
        return false;
    }

    public static long delete(MorphiaQuery query) {
        return query.delete();
    }

    public static long deleteAll() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaQuery find() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaQuery find(String keys, Object ... params) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T> List<T> findAll() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> T findById(Object id) {
        throw new UnsupportedOperationException("Embedded entity does not support this method");
    }

    public static <T extends Model> MorphiaQuery q(String keys, Object value) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaQuery filter(String property, Object value) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaUpdateOperations createUpdateOperations() {
        throw new UnsupportedClassVersionError("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaUpdateOperations o() {
        throw new UnsupportedClassVersionError("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> T get() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Datastore ds() {
        return MorphiaPlugin.ds();
    }

    public static DBCollection col() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static DB db() {
        return Model.ds().getDB();
    }

    public <T extends Model> T save() {
        this.save2();
        return (T)this;
    }

    public Key<? extends Model> save2() {
        boolean isNew = this.isNew();
        Model.postEvent_(isNew ? MorphiaEvent.ON_ADD : MorphiaEvent.ON_UPDATE, this);
        if (isNew) {
            this._h_OnAdd();
        } else {
            this._h_OnUpdate();
        }
        Key k = Model.ds().save((Object)this);
        this.saveBlobs();
        if (isNew) {
            this.setSaved_();
            this._h_Added();
        } else {
            this._h_Updated();
        }
        return k;
    }

    public static <T extends Model> WriteResult insert(T entity) {
        Morphia morphia = MorphiaPlugin.morphia();
        DBObject o = morphia.toDBObject(entity);
        return Model.col().insert(new DBObject[]{o});
    }

    public static <T extends Model> WriteResult insert(T entity, WriteConcern concern) {
        Morphia morphia = MorphiaPlugin.morphia();
        DBObject o = morphia.toDBObject(entity);
        return Model.col().insert(o, concern);
    }

    public static <T extends Model> WriteResult insert(List<T> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        Model t = (Model)entities.get(0);
        ArrayList<DBObject> l = new ArrayList<DBObject>(entities.size());
        Morphia morphia = MorphiaPlugin.morphia();
        boolean populateId = !MorphiaPlugin.getIdType().isObjectId();
        for (Model entity : entities) {
            if (populateId) {
                entity.setId(IdGenerator.generateId(entity));
            }
            l.add(morphia.toDBObject((Object)entity));
        }
        return t.ds().getCollection(t.getClass()).insert(l);
    }

    public static <T extends Model> WriteResult insert(List<T> entities, WriteConcern concern) {
        if (entities.isEmpty()) {
            return null;
        }
        Model t = (Model)entities.get(0);
        ArrayList<DBObject> l = new ArrayList<DBObject>(entities.size());
        Morphia morphia = MorphiaPlugin.morphia();
        for (Model entity : entities) {
            l.add(morphia.toDBObject((Object)entity));
        }
        return t.col().insert(l, concern);
    }

    public static <T extends Model> WriteResult insert(T[] entities, WriteConcern concern) {
        if (entities.length == 0) {
            return null;
        }
        return Model.insert((WriteConcern)concern, entities);
    }

    public static <T extends Model> WriteResult insert(T ... entities) {
        if (entities.length == 0) {
            return null;
        }
        T t = entities[0];
        ArrayList<DBObject> l = new ArrayList<DBObject>(entities.length);
        Morphia morphia = MorphiaPlugin.morphia();
        for (T entity : entities) {
            l.add(morphia.toDBObject(entity));
        }
        return Model.col().insert(l);
    }

    public static <T extends Model> WriteResult insert(WriteConcern writeConcern, T[] entities) {
        if (entities.length == 0) {
            return null;
        }
        T t = entities[0];
        ArrayList<DBObject> l = new ArrayList<DBObject>(entities.length);
        Morphia morphia = MorphiaPlugin.morphia();
        for (T entity : entities) {
            l.add(morphia.toDBObject(entity));
        }
        return Model.col().insert(l, writeConcern);
    }

    public final void _h_OnLoad() {
        Model.postEvent_(MorphiaEvent.ON_LOAD, this);
        MorphiaPlugin.onLifeCycleEvent(MorphiaEvent.ON_LOAD, this);
        this.h_OnLoad();
    }

    protected void h_OnLoad() {
    }

    public final void _h_Loaded() {
        this.setSaved_();
        this.loadBlobs();
        this.h_Loaded();
        MorphiaPlugin.onLifeCycleEvent(MorphiaEvent.LOADED, this);
        Model.postEvent_(MorphiaEvent.LOADED, this);
    }

    protected void h_Loaded() {
    }

    private void _h_Added() {
        this.h_Added();
        MorphiaPlugin.onLifeCycleEvent(MorphiaEvent.ADDED, this);
        Model.postEvent_(MorphiaEvent.ADDED, this);
    }

    protected void h_Added() {
    }

    private void _h_Updated() {
        this.h_Updated();
        MorphiaPlugin.onLifeCycleEvent(MorphiaEvent.UPDATED, this);
        Model.postEvent_(MorphiaEvent.UPDATED, this);
    }

    protected void h_Updated() {
    }

    private void _h_OnAdd() {
        Model.postEvent_(MorphiaEvent.ON_ADD, this);
        MorphiaPlugin.onLifeCycleEvent(MorphiaEvent.ON_ADD, this);
        this.h_OnAdd();
        this.generateId_();
    }

    protected void h_OnAdd() {
    }

    private void _h_OnUpdate() {
        Model.postEvent_(MorphiaEvent.ON_UPDATE, this);
        MorphiaPlugin.onLifeCycleEvent(MorphiaEvent.ON_UPDATE, this);
        this.h_OnUpdate();
    }

    protected void h_OnUpdate() {
    }

    protected void saveBlobs() {
    }

    protected void loadBlobs() {
    }

    protected final boolean blobChanged(String fieldName) {
        return this.blobFieldsTracker.containsKey(fieldName) && this.blobFieldsTracker.get(fieldName) != false;
    }

    protected final void setBlobChanged(String fieldName) {
        this.blobFieldsTracker.put(fieldName, true);
    }

    public String getBlobFileName(String fieldName) {
        return Model.getBlobFileName(this.getClass().getSimpleName(), this.getId(), fieldName);
    }

    public static String getBlobFileName(String className, Object id, String fieldName) {
        return String.format("%s_%s", StringUtils.capitalize((String)fieldName), id);
    }

    public static void removeGridFSFiles(String className, Object id, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            String fileName = Model.getBlobFileName(className, id, fieldName);
            Blob.delete(fileName);
        }
    }

    public static void removeGridFSFiles(MorphiaQuery q, String ... fieldNames) {
        q.retrievedFields(true, "_id");
        for (Key key : q.fetchKeys()) {
            Object id = key.getId();
            Model.removeGridFSFiles(q.getEntityClass().getSimpleName(), id, fieldNames);
        }
    }

    public long _getCreated() {
        throw new UnsupportedOperationException("Please annotate model with @AutoTimestamp annotation");
    }

    public long _getModified() {
        throw new UnsupportedOperationException("Please annotate model with @AutoTimestamp annotation");
    }

    private static void postEvent_(MorphiaEvent event, Object context) {
        if (MorphiaPlugin.postPluginEvent) {
            PlayPlugin.postEvent((String)event.getId(), (Object)context);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface BatchDeleted {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnBatchDelete {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Deleted {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnDelete {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Updated {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Added {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnUpdate {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnAdd {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Loaded {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnLoad {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface NoId {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Column {
        public String value() default ".";

        public Class<?> concreteClass() default Object.class;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface NoAutoTimestamp {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface AutoTimestamp {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ByPass {
    }

    public static class MorphiaQuery {
        private QueryImpl<? extends Model> q_;
        private Class<? extends Model> c_;

        public static Datastore ds() {
            return MorphiaPlugin.ds();
        }

        public Query<? extends Model> getMorphiaQuery() {
            return this.q_;
        }

        public DBObject getQueryObject() {
            return this.q_.getQueryObject();
        }

        public DBCollection col() {
            return MorphiaQuery.ds().getCollection(this.c_);
        }

        private MorphiaQuery() {
        }

        public MorphiaQuery(Class<? extends Model> clazz) {
            this.q_ = (QueryImpl)MorphiaQuery.ds().createQuery(clazz);
            this.c_ = clazz;
        }

        public MorphiaQuery(Class<? extends Model> clazz, DBCollection coll, Datastore ds) {
            this.q_ = new QueryImpl(clazz, coll, ds);
            this.c_ = clazz;
        }

        public MorphiaQuery(Class<? extends Model> clazz, DBCollection coll, Datastore ds, int offset, int limit) {
            this.q_ = new QueryImpl(clazz, coll, ds, offset, limit);
            this.c_ = clazz;
        }

        public long delete() {
            long l = this.count();
            Model.postEvent_(MorphiaEvent.ON_BATCH_DELETE, this);
            MorphiaPlugin.onBatchLifeCycleEvent(MorphiaEvent.ON_BATCH_DELETE, this);
            Model m = null;
            try {
                Constructor<? extends Model> c = this.c_.getDeclaredConstructor(new Class[0]);
                if (!c.isAccessible()) {
                    c.setAccessible(true);
                }
                m = c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot init model class", e);
            }
            if (null != m) {
                m.h_OnBatchDelete(this);
                m.deleteBlobsInBatch(this);
            }
            MorphiaQuery.ds().delete(this.q_);
            if (null != m) {
                m.h_BatchDeleted(this);
            }
            Model.postEvent_(MorphiaEvent.BATCH_DELETED, this);
            return l;
        }

        public long count() {
            return this.q_.countAll();
        }

        public MorphiaQuery findBy(String query, Object ... params) {
            if (null == params) {
                params = new Object[]{null};
            }
            if (null == query || params.length == 0) {
                throw new IllegalArgumentException("Invalid query or params");
            }
            if (query.startsWith("by")) {
                query = query.substring(2);
            }
            String[] keys = query.split("(And|[,;\\s]+)");
            if (params.length != 1 && keys.length != params.length) {
                throw new IllegalArgumentException("Query key number does not match the params number");
            }
            Object oneVal = params.length == 1 ? params[0] : null;
            for (int i = 0; i < keys.length; ++i) {
                StringBuilder sb = new StringBuilder(keys[i]);
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                this.q_.filter(sb.toString(), params.length > 1 ? params[i] : oneVal);
            }
            return this;
        }

        public String toString() {
            return this.q_.toString();
        }

        public <T> T first() {
            return this.get();
        }

        public <T> MorphiaQuery from(int position) {
            this.q_.offset(position);
            return this;
        }

        public <T extends Model> List<T> fetchAll() {
            return this.q_.asList();
        }

        public <T extends Model> List<T> fetch(int max) {
            return this.q_.limit(max).asList();
        }

        public <T extends Model> List<T> fetch(int page, int length) {
            if (page < 1) {
                page = 1;
            }
            return this.q_.offset((page - 1) * length).limit(length).asList();
        }

        public Model _get() {
            return (Model)this.q_.get();
        }

        public <T extends Model> T get() {
            return (T)((Model)this.q_.get());
        }

        public <T extends Model> MorphiaQuery filter(String condition, Object value) {
            this.q_.filter(condition, value);
            return this;
        }

        public <T extends Model> Key<T> getKey() {
            return this.q_.getKey();
        }

        public <T extends Model> Iterator<T> iterator() {
            return this.q_.iterator();
        }

        public <T extends Model> List<T> asList() {
            return this.q_.asList();
        }

        public <T extends Model> List<Key<T>> asKeyList() {
            return this.q_.asKeyList();
        }

        public <T extends Model> Iterable<T> fetch() {
            return this.q_.fetch();
        }

        public Set<?> distinct(String key) {
            key = MorphiaPlugin.mongoColName(this.c_, key);
            return new HashSet(this.col().distinct(key.toString(), this.getQueryObject()));
        }

        public Map<String, Long> cloud(String field) {
            field = MorphiaPlugin.mongoColName(this.c_, field);
            String map = String.format("function() {if (!this.%s) return; for (index in this.%s) emit(this.tags[index], 1);}", field, field);
            String reduce = "function(previous, current) {var count = 0; for (index in current) count += current[index]; return count;}";
            MapReduceCommand cmd = new MapReduceCommand(this.col(), map, reduce, null, MapReduceCommand.OutputType.INLINE, this.q_.getQueryObject());
            MapReduceOutput out = this.col().mapReduce(cmd);
            HashMap<String, Long> m = new HashMap<String, Long>();
            for (DBObject dbo : out.results()) {
                m.put((String)dbo.get("_id"), ((Double)dbo.get("value")).longValue());
            }
            return m;
        }

        public List<BasicDBObject> group(String groupKeys, DBObject initial, String reduce, String finalize) {
            BasicDBObject key = new BasicDBObject();
            if (!StringUtil.isEmpty(groupKeys)) {
                String[] sa;
                if (groupKeys.startsWith("by")) {
                    groupKeys = groupKeys.substring(2);
                }
                for (String s : sa = groupKeys.split("(And|[\\s,;]+)")) {
                    key.put(MorphiaPlugin.mongoColName(this.c_, s), (Object)true);
                }
            }
            return (List)MorphiaQuery.ds().getCollection(this.c_).group((DBObject)key, this.q_.getQueryObject(), initial, reduce, finalize);
        }

        private AggregationResult aggregate_(String field, String mappedField, DBObject initial, Long initVal, String reduce, String finalize, String ... groupKeys) {
            if (null == initial) {
                initial = new BasicDBObject();
            }
            initial.put(mappedField, (Object)initVal);
            return new AggregationResult(this.group(StringUtil.join(",", groupKeys), initial, reduce, finalize), field, this.c_);
        }

        public AggregationResult groupMax(String field, String ... groupKeys) {
            String mappedField = MorphiaPlugin.mongoColName(this.c_, field);
            String reduce = String.format("function(obj, prev){if (obj.%s > prev.%s) prev.%s = obj.%s}", mappedField, mappedField, mappedField, mappedField);
            return this.aggregate_(field, mappedField, null, -9223372036854775807L, reduce, null, groupKeys);
        }

        public Long max(String maxField) {
            return this.groupMax(maxField, new String[0]).getResult();
        }

        public AggregationResult groupMin(String field, String ... groupKeys) {
            String mappedField = MorphiaPlugin.mongoColName(this.c_, field);
            String reduce = String.format("function(obj, prev){if (obj.%s < prev.%s) prev.%s = obj.%s}", mappedField, mappedField, mappedField, mappedField);
            return this.aggregate_(field, mappedField, null, 0x7FFFFFFFFFFFFFFEL, reduce, null, groupKeys);
        }

        public Long min(String minField) {
            return this.groupMin(minField, new String[0]).getResult();
        }

        public AggregationResult groupAverage(String field, String ... groupKeys) {
            String mappedField = MorphiaPlugin.mongoColName(this.c_, field);
            BasicDBObject initial = new BasicDBObject();
            initial.put("__count", (Object)0);
            initial.put("__sum", (Object)0);
            String reduce = String.format("function(obj, prev){prev.__count++; prev.__sum+=obj.%s;}", mappedField);
            String finalize = String.format("function(prev) {prev.%s = prev.__sum / prev.__count;}", mappedField);
            return this.aggregate_(field, mappedField, (DBObject)initial, 0L, reduce, finalize, groupKeys);
        }

        public Long average(String field) {
            return this.groupAverage(field, new String[0]).getResult();
        }

        public AggregationResult groupSum(String field, String ... groupKeys) {
            String mappedField = MorphiaPlugin.mongoColName(this.c_, field);
            String reduce = String.format("function(obj, prev){prev.%s+=obj.%s;}", mappedField, mappedField);
            return this.aggregate_(field, mappedField, null, 0L, reduce, null, groupKeys);
        }

        public Long sum(String field) {
            return this.groupSum(field, new String[0]).getResult();
        }

        public AggregationResult groupCount(String field, String ... groupKeys) {
            String mappedField = MorphiaPlugin.mongoColName(this.c_, field);
            String reduce = String.format("function(obj, prev){prev.%s++;}", mappedField);
            return this.aggregate_(field, mappedField, null, 0L, reduce, null, groupKeys);
        }

        public <T extends Model> Iterable<T> fetchEmptyEntities() {
            return this.q_.fetchEmptyEntities();
        }

        public <T extends Model> FieldEnd<? extends Query<T>> field(String field) {
            return this.q_.field(field);
        }

        public <T extends Model> Iterable<Key<T>> fetchKeys() {
            return this.q_.fetchKeys();
        }

        public <T extends Model> FieldEnd<? extends CriteriaContainerImpl> criteria(String field) {
            return this.q_.criteria(field);
        }

        public <T extends Model> CriteriaContainer and(Criteria ... criteria) {
            return this.q_.and(criteria);
        }

        public long countAll() {
            return this.q_.countAll();
        }

        public <T extends Model> CriteriaContainer or(Criteria ... criteria) {
            return this.q_.or(criteria);
        }

        public <T extends Model> MorphiaQuery where(String js) {
            this.q_.where(js);
            return this;
        }

        public <T extends Model> MorphiaQuery where(CodeWScope js) {
            this.q_.where(js);
            return this;
        }

        public <T extends Model> MorphiaQuery order(String condition) {
            this.q_.order(condition);
            return this;
        }

        public <T extends Model> MorphiaQuery limit(int value) {
            this.q_.limit(value);
            return this;
        }

        public <T extends Model> MorphiaQuery batchSize(int value) {
            this.q_.batchSize(value);
            return this;
        }

        public <T extends Model> MorphiaQuery offset(int value) {
            this.q_.offset(value);
            return this;
        }

        @Deprecated
        public <T extends Model> MorphiaQuery skip(int value) {
            this.q_.skip(value);
            return this;
        }

        public <T extends Model> MorphiaQuery enableValidation() {
            this.q_.enableValidation();
            return this;
        }

        public <T extends Model> MorphiaQuery disableValidation() {
            this.q_.disableValidation();
            return this;
        }

        public <T extends Model> MorphiaQuery hintIndex(String idxName) {
            this.q_.hintIndex(idxName);
            return this;
        }

        public <T extends Model> MorphiaQuery retrievedFields(boolean include, String ... fields) {
            this.q_.retrievedFields(include, fields);
            return this;
        }

        public <T extends Model> MorphiaQuery enableSnapshotMode() {
            this.q_.enableSnapshotMode();
            return this;
        }

        public <T extends Model> MorphiaQuery disableSnapshotMode() {
            this.q_.disableSnapshotMode();
            return this;
        }

        public <T extends Model> MorphiaQuery queryNonPrimary() {
            this.q_.queryNonPrimary();
            return this;
        }

        public <T extends Model> MorphiaQuery queryPrimaryOnly() {
            this.q_.queryPrimaryOnly();
            return this;
        }

        @Deprecated
        public <T extends Model> MorphiaQuery disableTimeout() {
            return this.disableCursorTimeout();
        }

        public <T extends Model> MorphiaQuery disableCursorTimeout() {
            this.q_.disableCursorTimeout();
            return this;
        }

        @Deprecated
        public <T extends Model> MorphiaQuery enableTimeout() {
            return this.enableCursorTimeout();
        }

        public <T extends Model> MorphiaQuery enableCursorTimeout() {
            this.q_.enableCursorTimeout();
            return this;
        }

        public Class<? extends Model> getEntityClass() {
            return this.q_.getEntityClass();
        }

        public MorphiaQuery clone() {
            MorphiaQuery mq = new MorphiaQuery();
            mq.q_ = this.q_.clone();
            return mq;
        }
    }

    public static class MorphiaUpdateOperations {
        private UpdateOpsImpl<? extends Model> u_;
        private Class<? extends Model> c_;
        private boolean multi = true;

        public static Datastore ds() {
            return MorphiaPlugin.ds();
        }

        public UpdateOperations<? extends Model> getMorphiaUpdateOperations() {
            return this.u_;
        }

        public DBObject getUpdateOperationsObject() {
            return this.u_.getOps();
        }

        public DBCollection col() {
            return MorphiaUpdateOperations.ds().getCollection(this.c_);
        }

        private MorphiaUpdateOperations() {
        }

        public MorphiaUpdateOperations(Class<? extends Model> clazz) {
            this.u_ = new UpdateOpsImpl(clazz, ((DatastoreImpl)MorphiaUpdateOperations.ds()).getMapper());
            this.c_ = clazz;
        }

        public MorphiaUpdateOperations multi(boolean multi) {
            this.multi = multi;
            return this;
        }

        public boolean multi() {
            return this.multi;
        }

        public MorphiaUpdateOperations validation(boolean validate) {
            if (validate) {
                this.u_.enableValidation();
            } else {
                this.u_.disableValidation();
            }
            return this;
        }

        public MorphiaUpdateOperations enableValidation() {
            return this.validation(true);
        }

        public MorphiaUpdateOperations disableValidation() {
            return this.validation(false);
        }

        public MorphiaUpdateOperations isolate(boolean isolate) {
            if (!isolate) {
                throw new UnsupportedOperationException("Morphia does not support set isolated to false");
            }
            this.u_.isolated();
            return this;
        }

        public MorphiaUpdateOperations enableIsolate() {
            return this.isolate(true);
        }

        public MorphiaUpdateOperations disableIsolate() {
            return this.isolate(false);
        }

        public MorphiaUpdateOperations isolated() {
            return this.enableIsolate();
        }

        public MorphiaUpdateOperations add(String fieldExpr, Object value) {
            this.u_.add(fieldExpr, value);
            return this;
        }

        public MorphiaUpdateOperations add(String fieldExpr, Object value, boolean addDups) {
            this.u_.add(fieldExpr, value, addDups);
            return this;
        }

        public MorphiaUpdateOperations addAll(String fieldExpr, List<?> values, boolean addDups) {
            this.u_.addAll(fieldExpr, values, addDups);
            return this;
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public MorphiaUpdateOperations dec(String fieldExpr) {
            if (StringUtil.isEmpty(fieldExpr)) {
                throw new IllegalArgumentException("Invalid fieldExpr or params");
            }
            if (fieldExpr.startsWith("by")) {
                fieldExpr = fieldExpr.substring(2);
            }
            String[] keys = fieldExpr.split("(And|[,;\\s]+)");
            for (int i = 0; i < keys.length; ++i) {
                StringBuilder sb = new StringBuilder(keys[i]);
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                this.u_.dec(sb.toString());
            }
            return this;
        }

        public MorphiaUpdateOperations inc(String fieldExpr) {
            if (StringUtil.isEmpty(fieldExpr)) {
                throw new IllegalArgumentException("Invalid fieldExpr or params");
            }
            if (fieldExpr.startsWith("by")) {
                fieldExpr = fieldExpr.substring(2);
            }
            String[] keys = fieldExpr.split("(And|[,;\\s]+)");
            for (int i = 0; i < keys.length; ++i) {
                StringBuilder sb = new StringBuilder(keys[i]);
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                this.u_.inc(sb.toString());
            }
            return this;
        }

        public MorphiaUpdateOperations inc(String fieldExpr, Number ... values) {
            if (null == values) {
                values = new Number[]{null};
            }
            if (StringUtil.isEmpty(fieldExpr) || values.length == 0) {
                throw new IllegalArgumentException("Invalid fieldExpr or params");
            }
            if (fieldExpr.startsWith("by")) {
                fieldExpr = fieldExpr.substring(2);
            }
            String[] keys = fieldExpr.split("(And|[,;\\s]+)");
            if (values.length != 1 && keys.length != values.length) {
                throw new IllegalArgumentException("Query key number does not match the params number");
            }
            Number oneVal = values.length == 1 ? (Number)values[0] : (Number)null;
            for (int i = 0; i < keys.length; ++i) {
                StringBuilder sb = new StringBuilder(keys[i]);
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                this.u_.inc(sb.toString(), oneVal == null ? (Number)values[i] : (Number)oneVal);
            }
            return this;
        }

        public MorphiaUpdateOperations removeAll(String fieldExpr, Object value) {
            this.u_.removeAll(fieldExpr, value);
            return this;
        }

        public MorphiaUpdateOperations removeAll(String fieldExpr, List<?> values) {
            this.u_.removeAll(fieldExpr, values);
            return this;
        }

        public MorphiaUpdateOperations removeFirst(String fieldExpr) {
            this.u_.removeFirst(fieldExpr);
            return this;
        }

        public MorphiaUpdateOperations removeLast(String fieldExpr) {
            this.u_.removeLast(fieldExpr);
            return this;
        }

        public MorphiaUpdateOperations set(String fieldExpr, Object ... values) {
            if (null == values) {
                values = new Object[]{null};
            }
            if (null == fieldExpr || values.length == 0) {
                throw new IllegalArgumentException("Invalid query or params");
            }
            if (fieldExpr.startsWith("by")) {
                fieldExpr = fieldExpr.substring(2);
            }
            String[] keys = fieldExpr.split("(And|[,;\\s]+)");
            if (values.length != 1 && keys.length != values.length) {
                throw new IllegalArgumentException("Query key number does not match the params number");
            }
            Object oneVal = values.length == 1 ? values[0] : null;
            for (int i = 0; i < keys.length; ++i) {
                StringBuilder sb = new StringBuilder(keys[i]);
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                this.u_.set(sb.toString(), oneVal == null ? values[i] : oneVal);
            }
            return this;
        }

        public MorphiaUpdateOperations unset(String fieldExpr) {
            this.u_.unset(fieldExpr);
            return this;
        }

        public <T> T updateFirst(MorphiaQuery q) {
            return this.findAndModify(q);
        }

        public <T> T updateFirst(String query, Object ... params) {
            MorphiaQuery q = new MorphiaQuery(this.c_).findBy(query, params);
            return this.findAndModify(q);
        }

        public <T> T findAndModify(MorphiaQuery q) {
            return (T)MorphiaUpdateOperations.ds().findAndModify(q.getMorphiaQuery(), this.u_);
        }

        public <T> T findAndModify(String query, Object ... params) {
            MorphiaQuery q = new MorphiaQuery(this.c_).findBy(query, params);
            return this.findAndModify(q);
        }

        public <T> T updateFirst(MorphiaQuery q, boolean oldVersion) {
            return this.findAndModify(q, oldVersion);
        }

        public <T> T updateFirst(boolean oldVersion, String query, Object ... params) {
            MorphiaQuery q = new MorphiaQuery(this.c_).findBy(query, params);
            return this.findAndModify(q, oldVersion);
        }

        public <T> T findAndModify(MorphiaQuery q, boolean oldVersion) {
            return (T)MorphiaUpdateOperations.ds().findAndModify(q.getMorphiaQuery(), this.u_, oldVersion);
        }

        public <T> T findAndModify(boolean oldVersion, String query, Object ... params) {
            MorphiaQuery q = new MorphiaQuery(this.c_).findBy(query, params);
            return this.findAndModify(q, oldVersion);
        }

        public <T> T updateFirst(MorphiaQuery q, boolean oldVersion, boolean createIfMissing) {
            return this.findAndModify(q, oldVersion, createIfMissing);
        }

        public <T> T findAndModify(MorphiaQuery q, boolean oldVersion, boolean createIfMissing) {
            return (T)MorphiaUpdateOperations.ds().findAndModify(q.getMorphiaQuery(), this.u_, oldVersion, createIfMissing);
        }

        public <T> UpdateResults<T> update(MorphiaQuery q) {
            return MorphiaUpdateOperations.ds().update(q.getMorphiaQuery(), this.u_);
        }

        public <T> UpdateResults<T> update(String query, Object ... params) {
            MorphiaQuery q = new MorphiaQuery(this.c_).findBy(query, params);
            return MorphiaUpdateOperations.ds().update(q.getMorphiaQuery(), this.u_);
        }

        public <T> UpdateResults<T> update(Model entity) {
            return this.update("_id", entity.getId());
        }

        private <T> UpdateResults<T> update(Query<T> q) {
            return MorphiaUpdateOperations.ds().update(q, this.u_);
        }

        public <T> UpdateResults<T> updateAll() {
            return MorphiaUpdateOperations.ds().update((Query)((QueryImpl)MorphiaUpdateOperations.ds().createQuery(this.c_)), this.u_);
        }
    }
}

