/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia.utils;

import com.google.code.morphia.Datastore;
import org.bson.types.ObjectId;
import play.modules.morphia.Model;
import play.modules.morphia.MorphiaPlugin;
import play.modules.morphia.Seq;

public class IdGenerator {
    public static Datastore ds() {
        return MorphiaPlugin.ds();
    }

    public static Object generateId(Model entity) {
        MorphiaPlugin.IdType t = MorphiaPlugin.getIdType();
        switch (t) {
            case STRING: {
                return IdGenerator.generateStringId(entity);
            }
            case LONG: {
                return IdGenerator.generateLongId(entity);
            }
            case OBJECT_ID: {
                return IdGenerator.generateObjectIdId(entity);
            }
        }
        throw new IllegalStateException("Shouldn't be here. Probably user entity does not override generateId() method for user annotated Id field.");
    }

    public static <T extends Model> String generateStringId(T entity) {
        return IdGenerator.generateStringId(entity.getClass());
    }

    public static <T extends Model> String generateStringId(Class<T> clazz) {
        return MorphiaPlugin.generateStringId();
    }

    public static <T extends Model> Long generateLongId(T entity) {
        return IdGenerator.generateLongId(entity.getClass());
    }

    public static <T extends Model> Long generateLongId(Class<T> clazz) {
        return Seq.nextValue(clazz);
    }

    public static <T extends Model> ObjectId generateObjectIdId(T entity) {
        return new ObjectId();
    }

    public static <T extends Model> ObjectId generateObjectIdId(Class<T> clazz) {
        return new ObjectId();
    }

    public static String getIdTypeName() {
        MorphiaPlugin.IdType t = MorphiaPlugin.getIdType();
        switch (t) {
            case STRING: {
                return String.class.getName();
            }
            case LONG: {
                return Long.class.getName();
            }
            case OBJECT_ID: {
                return ObjectId.class.getName();
            }
        }
        throw new IllegalStateException("How can i get here???");
    }

    public static Object processId(Object id) {
        MorphiaPlugin.IdType t = MorphiaPlugin.getIdType();
        switch (t) {
            case STRING: {
                return IdGenerator.processStringId(id);
            }
            case LONG: {
                return IdGenerator.processLongId(id);
            }
            case OBJECT_ID: {
                return IdGenerator.processObjectId(id);
            }
        }
        return id;
    }

    public static String processStringId(Object id) {
        return null == id ? null : id.toString();
    }

    public static ObjectId processObjectId(Object id) {
        if (id instanceof ObjectId) {
            return (ObjectId)id;
        }
        return null == id ? null : new ObjectId(id.toString());
    }

    public static Long processLongId(Object id) {
        if (id instanceof Long) {
            return (Long)id;
        }
        return null == id ? null : Long.valueOf(Long.parseLong(id.toString()));
    }
}

