/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia.validation;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.OValContext;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.morphia.Model;
import play.modules.morphia.validation.Unique;

public class UniqueCheck
extends AbstractAnnotationCheck<Unique> {
    static final String mes = "validation.unique";
    private String uniqueKeyContext = null;

    public void configure(Unique constraintAnnotation) {
        this.uniqueKeyContext = constraintAnnotation.value();
        this.setMessage(constraintAnnotation.message());
    }

    public Map<String, String> createMessageVariables() {
        TreeMap<String, String> messageVariables = new TreeMap<String, String>();
        messageVariables.put("2-properties", this.uniqueKeyContext);
        return messageVariables;
    }

    private String[] getPropertyNames(String uniqueKey) {
        String completeUniqueKey = this.uniqueKeyContext.length() > 0 ? this.uniqueKeyContext + ";" + uniqueKey : uniqueKey;
        return completeUniqueKey.split("[,;\\s][\\s]*");
    }

    public boolean isSatisfied(Object validatedObject, Object value, OValContext context, Validator validator) {
        this.requireMessageVariablesRecreation();
        if (value == null) {
            return true;
        }
        String[] propertyNames = this.getPropertyNames(((FieldContext)context).getField().getName());
        Model model = (Model)validatedObject;
        Model.Factory factory = Model.Manager.factoryFor(model.getClass());
        String keyProperty = factory.keyName();
        Object keyValue = factory.keyValue((play.db.Model)model);
        boolean isUpdate = keyValue != null;
        String entityName = model.getClass().getName();
        Class<?> clazz = validatedObject.getClass();
        Model.MorphiaQuery q = new Model.MorphiaQuery(clazz);
        Object[] values = new Object[isUpdate ? propertyNames.length + 1 : propertyNames.length];
        boolean index = true;
        for (int i = 0; i < propertyNames.length; ++i) {
            Field field = this.getField(clazz, propertyNames[i]);
            field.setAccessible(true);
            try {
                values[i] = field.get(model);
            }
            catch (Exception ex) {
                throw new UnexpectedException((Throwable)ex);
            }
            q.filter(propertyNames[i], values[i]);
        }
        if (isUpdate) {
            q.field(keyProperty).notEqual(keyValue);
        }
        return q.count() == 0L;
    }

    private Field getField(Class clazz, String fieldName) {
        Class c = clazz;
        try {
            while (!c.equals(Object.class)) {
                try {
                    return c.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    c = c.getSuperclass();
                }
            }
        }
        catch (Exception e) {
            throw new UnexpectedException("Error while determining the field " + fieldName + " for an object of type " + clazz);
        }
        throw new UnexpectedException("Cannot get the field " + fieldName + " for an object of type " + clazz);
    }
}

