/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.converters;

import com.google.code.morphia.converters.SimpleValueConverter;
import com.google.code.morphia.converters.TypeConverter;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.MappingException;

public class ClassConverter
extends TypeConverter
implements SimpleValueConverter {
    public ClassConverter() {
        super(Class.class);
    }

    public Object decode(Class targetClass, Object fromDBObject, MappedField optionalExtraInfo) throws MappingException {
        if (fromDBObject == null) {
            return null;
        }
        String l = fromDBObject.toString();
        try {
            return Class.forName(l);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Cannot create class from Name '" + l + "'", e);
        }
    }

    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        return ((Class)value).getName();
    }
}

