/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia;

import com.google.code.morphia.annotations.Converters;
import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.PrePersist;
import com.google.code.morphia.annotations.Property;
import com.google.code.morphia.annotations.Transient;
import com.google.code.morphia.utils.IndexDirection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.MemberValue;
import play.Logger;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.modules.morphia.Model;
import play.modules.morphia.MorphiaPlugin;
import play.modules.morphia.utils.IdGenerator;
import play.modules.morphia.utils.StringUtil;
import play.modules.morphia.validation.Unique;

public class MorphiaEnhancer
extends Enhancer {
    public static final String PACKAGE_NAME = "play.modules.morphia";

    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        this.enhanceThisClass_(applicationClass);
    }

    void enhanceThisClass_(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        boolean autoTS;
        CtClass modelClass;
        if (applicationClass.name.contains("$anonfun$") || applicationClass.name.contains("$anon$")) {
            return;
        }
        CtClass ctClass = this.makeClass(applicationClass);
        if (!ctClass.subclassOf(modelClass = this.classPool.getCtClass("play.modules.morphia.Model")) && this.hasAnnotation(ctClass, Embedded.class.getName())) {
            this.processFields(ctClass);
            applicationClass.enhancedByteCode = ctClass.toBytecode();
            ctClass.defrost();
            return;
        }
        if (!ctClass.subclassOf(modelClass)) {
            return;
        }
        if (this.hasAnnotation(ctClass, Embedded.class.getName())) {
            throw new Exception(String.format("Error enhancing [%s]: Embedded entity shall NOT extend play.modules.morphia.Model class!", ctClass.getName()));
        }
        boolean addId = this.hasAnnotation(ctClass, Entity.class.getName());
        if (this.hasAnnotation(ctClass, Model.NoId.class.getName())) {
            addId = false;
        } else {
            for (CtField cf : ctClass.getDeclaredFields()) {
                if (!this.hasAnnotation(cf, Id.class.getName()) && !cf.getName().equals("_id")) continue;
                addId = false;
                break;
            }
            for (CtField cf : ctClass.getFields()) {
                if (!this.hasAnnotation(cf, Id.class.getName()) && !cf.getName().equals("_id")) continue;
                addId = false;
                break;
            }
        }
        boolean bl = autoTS = MorphiaPlugin.autoTS_ && this.hasAnnotation(ctClass, Entity.class.getName());
        if (this.hasAnnotation(ctClass, Model.NoAutoTimestamp.class.getName())) {
            autoTS = false;
        } else if (this.hasAnnotation(ctClass, Model.AutoTimestamp.class.getName())) {
            autoTS = true;
        }
        for (CtField cf : ctClass.getDeclaredFields()) {
            if (!cf.getName().equals("_created")) continue;
            autoTS = false;
        }
        for (CtField cf : ctClass.getFields()) {
            if (!cf.getName().equals("_created")) continue;
            autoTS = false;
        }
        this.enhance_(ctClass, applicationClass, addId, autoTS);
    }

    private void enhance_(CtClass ctClass, ApplicationClasses.ApplicationClass applicationClass, boolean addId, boolean autoTS) throws Exception {
        boolean hasBlobField;
        CtMethod findById;
        String entityName = ctClass.getName();
        MorphiaPlugin.debug("enhancing %s ...", entityName);
        this.classPool.importPackage(PACKAGE_NAME);
        String className = entityName + ".class";
        CtField mf = CtField.make((String)("protected static play.db.Model.Factory mf = MorphiaPlugin.MorphiaModelLoader.getFactory(" + className + ");"), (CtClass)ctClass);
        ctClass.addField(mf);
        CtMethod getModelFactory = CtMethod.make((String)"public static play.db.Model.Factory getModelFactory() { return mf; }", (CtClass)ctClass);
        ctClass.addMethod(getModelFactory);
        if (addId) {
            Logger.trace((String)"Adding id methods to system managed ID entity: %1$s", (Object[])new Object[]{ctClass.getName()});
            Logger.trace((String)"type name: %1$s", (Object[])new Object[]{IdGenerator.getIdTypeName()});
            String idType = IdGenerator.getIdTypeName();
            CtField idField = new CtField(this.classPool.get(idType), "_id", ctClass);
            idField.setModifiers(1);
            AnnotationsAttribute aa = new AnnotationsAttribute(ctClass.getClassFile().getConstPool(), "RuntimeVisibleAnnotations");
            Annotation idAnn = new Annotation(Id.class.getName(), ctClass.getClassFile().getConstPool());
            aa.addAnnotation(idAnn);
            idField.getFieldInfo().addAttribute((AttributeInfo)aa);
            ctClass.addField(idField);
            Logger.trace((String)"ID field added to entity[%2$s]: %1$s", (Object[])new Object[]{idField.getSignature(), ctClass.getName()});
            CtMethod getId = CtMethod.make((String)"public Object getId() { return _id;}", (CtClass)ctClass);
            ctClass.addMethod(getId);
            CtMethod setId = CtMethod.make((String)("protected void setId_(Object id) { _id = (" + idType + ")play.modules.morphia.utils.IdGenerator.processId(id);}"), (CtClass)ctClass);
            ctClass.addMethod(setId);
        } else {
            Logger.trace((String)"adding id methods to user defined id entity: %1$s", (Object[])new Object[]{ctClass.getName()});
            boolean hasGetId = false;
            for (CtMethod cm : ctClass.getDeclaredMethods()) {
                if (!"getId".equals(cm.getName()) || !cm.getDeclaringClass().equals(ctClass)) continue;
                hasGetId = true;
                break;
            }
            if (!hasGetId) {
                CtMethod getId = CtMethod.make((String)"public Object getId() { return mf.keyValue(this);}", (CtClass)ctClass);
                ctClass.addMethod(getId);
            }
            CtMethod isUserDefinedId = CtMethod.make((String)"protected boolean isUserDefinedId_() {return super.isUserDefinedId_();}", (CtClass)ctClass);
            ctClass.addMethod(isUserDefinedId);
        }
        if (autoTS) {
            ClassFile classFile = ctClass.getClassFile();
            ConstPool cp = classFile.getConstPool();
            AnnotationsAttribute attribute = new AnnotationsAttribute(cp, "RuntimeVisibleAnnotations");
            Annotation indexAnnotation = new Annotation(cp, ClassPool.getDefault().get("com.google.code.morphia.annotations.Indexed"));
            EnumMemberValue val = new EnumMemberValue(cp);
            val.setType(IndexDirection.class.getName());
            val.setValue(IndexDirection.DESC.name());
            indexAnnotation.addMemberValue("value", (MemberValue)val);
            attribute.addAnnotation(indexAnnotation);
            Logger.trace((String)"create timestamp fields automatically", (Object[])new Object[0]);
            CtField createdField = new CtField(CtClass.longType, "_created", ctClass);
            createdField.getFieldInfo().addAttribute((AttributeInfo)attribute);
            createdField.setModifiers(1);
            ctClass.addField(createdField);
            CtField modifiedField = new CtField(CtClass.longType, "_modified", ctClass);
            modifiedField.getFieldInfo().addAttribute((AttributeInfo)attribute);
            modifiedField.setModifiers(1);
            ctClass.addField(modifiedField);
            CtMethod persistTs = CtMethod.make((String)"void _updateTimestamp() { long now = System.currentTimeMillis(); if (0 == _created) {_created = now;} ;_modified = now;}", (CtClass)ctClass);
            AnnotationsAttribute aa = new AnnotationsAttribute(ctClass.getClassFile().getConstPool(), "RuntimeVisibleAnnotations");
            Annotation prePersistAnn = new Annotation(PrePersist.class.getName(), ctClass.getClassFile().getConstPool());
            aa.addAnnotation(prePersistAnn);
            persistTs.getMethodInfo().addAttribute((AttributeInfo)aa);
            ctClass.addMethod(persistTs);
            CtMethod getCreated = CtMethod.make((String)"public long _getCreated() { return _created; }", (CtClass)ctClass);
            ctClass.addMethod(getCreated);
            CtMethod getModified = CtMethod.make((String)"public long _getModified() { return _modified; }", (CtClass)ctClass);
            ctClass.addMethod(getModified);
        }
        CtMethod createUpdateOperations = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaUpdateOperations createUpdateOperations() { return o(); }", (CtClass)ctClass);
        ctClass.addMethod(createUpdateOperations);
        CtMethod o = CtMethod.make((String)("public static play.modules.morphia.Model.MorphiaUpdateOperations o() { return new play.modules.morphia.Model.MorphiaUpdateOperations(" + className + "); }"), (CtClass)ctClass);
        ctClass.addMethod(o);
        CtMethod all = CtMethod.make((String)("public static play.modules.morphia.Model.MorphiaQuery all() { return new play.modules.morphia.Model.MorphiaQuery(" + className + "); }"), (CtClass)ctClass);
        ctClass.addMethod(all);
        CtMethod create = CtMethod.make((String)("public static play.modules.morphia.Model create(String name, play.mvc.Scope.Params params) { Object o = play.Play.classloader.loadClass(\"" + entityName + "\").newInstance(); return ((play.modules.morphia.Model)o).edit(name, params.all()); }"), (CtClass)ctClass);
        ctClass.addMethod(create);
        CtMethod createQuery = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery createQuery() { return all(); }", (CtClass)ctClass);
        ctClass.addMethod(createQuery);
        CtMethod q = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery q() { return all(); }", (CtClass)ctClass);
        ctClass.addMethod(q);
        CtMethod disableValidation = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery disableValidation() { return all().disableValidation(); }", (CtClass)ctClass);
        ctClass.addMethod(disableValidation);
        CtMethod find = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery find() { return all(); }", (CtClass)ctClass);
        ctClass.addMethod(find);
        CtMethod find2 = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery find(String keys, java.lang.Object[] params) { return createQuery().findBy(keys, params); }", (CtClass)ctClass);
        ctClass.addMethod(find2);
        CtMethod q2 = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery q(String keys, java.lang.Object value) { return createQuery().filter(keys, value); }", (CtClass)ctClass);
        ctClass.addMethod(q2);
        CtMethod findAll = CtMethod.make((String)"public static java.util.List findAll() {return all().asList();}", (CtClass)ctClass);
        ctClass.addMethod(findAll);
        CtMethod filter = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery filter(String property, Object value) { return find().filter(property, value); }", (CtClass)ctClass);
        ctClass.addMethod(filter);
        CtMethod get = CtMethod.make((String)"public static Model get() { return find().get(); }", (CtClass)ctClass);
        ctClass.addMethod(get);
        if (addId) {
            findById = CtMethod.make((String)"public static Model findById(java.lang.Object id) { return filter(\"_id\", play.modules.morphia.utils.IdGenerator.processId(id))._get(); }", (CtClass)ctClass);
            ctClass.addMethod(findById);
        } else {
            findById = CtMethod.make((String)"public static Model findById(java.lang.Object id) { return (Model)mf.findById(id); }", (CtClass)ctClass);
            ctClass.addMethod(findById);
        }
        CtMethod col = CtMethod.make((String)("public static com.mongodb.DBCollection col() { return ds().getCollection(" + className + "); }"), (CtClass)ctClass);
        ctClass.addMethod(col);
        CtMethod count = CtMethod.make((String)("public static long count() { return ds().getCount(" + className + "); }"), (CtClass)ctClass);
        ctClass.addMethod(count);
        CtMethod count2 = CtMethod.make((String)"public static long count(String keys, Object[] params) { return find(keys, params).count(); }", (CtClass)ctClass);
        ctClass.addMethod(count2);
        CtMethod distinct = CtMethod.make((String)String.format("public static java.util.Set _distinct(String key) {return q().distinct(key);}", className), (CtClass)ctClass);
        ctClass.addMethod(distinct);
        CtMethod cloud = CtMethod.make((String)"public static java.util.Map _cloud(String key) {return q().cloud(key);}", (CtClass)ctClass);
        ctClass.addMethod(cloud);
        CtMethod max = CtMethod.make((String)"public static Long _max(String field) {return q().max(field);}", (CtClass)ctClass);
        ctClass.addMethod(max);
        CtMethod groupmax = CtMethod.make((String)"public static AggregationResult groupMax(String field, String[] groupKeys) {return q().groupMax(field, groupKeys);}", (CtClass)ctClass);
        ctClass.addMethod(groupmax);
        CtMethod min = CtMethod.make((String)"public static Long _min(String field) {return q().min(field);}", (CtClass)ctClass);
        ctClass.addMethod(min);
        CtMethod groupMin = CtMethod.make((String)"public static AggregationResult groupMin(String field, String[] groupKeys) {return q().groupMin(field, groupKeys);}", (CtClass)ctClass);
        ctClass.addMethod(groupMin);
        CtMethod average = CtMethod.make((String)"public static Long _average(String field) {return q().average(field);}", (CtClass)ctClass);
        ctClass.addMethod(average);
        CtMethod groupAverage = CtMethod.make((String)"public static AggregationResult groupAverage(String field, String[] groupKeys) {return q().groupAverage(field, groupKeys);}", (CtClass)ctClass);
        ctClass.addMethod(groupAverage);
        CtMethod sum = CtMethod.make((String)"public static Long _sum(String field) {return q().sum(field);}", (CtClass)ctClass);
        ctClass.addMethod(sum);
        CtMethod groupSum = CtMethod.make((String)"public static AggregationResult groupSum(String field, String[] groupKeys) {return q().groupSum(field, groupKeys);}", (CtClass)ctClass);
        ctClass.addMethod(groupSum);
        CtMethod groupCount = CtMethod.make((String)"public static AggregationResult groupCount(String field, String[] groupKeys) {return q().groupCount(field, groupKeys);}", (CtClass)ctClass);
        ctClass.addMethod(groupCount);
        CtMethod deleteAll = CtMethod.make((String)"public static long deleteAll() { return delete(all()); }", (CtClass)ctClass);
        ctClass.addMethod(deleteAll);
        Set<String> blobs = this.processFields(ctClass);
        boolean bl = hasBlobField = blobs.size() > 0;
        if (hasBlobField) {
            this.enhanceBlobMethods(ctClass, blobs);
        }
        this.addLifeCycleMethods(ctClass);
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.defrost();
    }

    private void enhanceBlobMethods(CtClass ctClass, Set<String> blobs) throws CannotCompileException, NotFoundException {
        StringBuilder sb = new StringBuilder("protected void saveBlobs() {");
        for (String blob : blobs) {
            sb.append(String.format("{Blob blob = %s; String name = getBlobFileName(\"%s\"); if (blobChanged(\"%s\")) {play.modules.morphia.Blob.delete(name);} if (null != blob) { com.mongodb.gridfs.GridFSDBFile file = blob.getGridFSFile(); if (null != file) {file.put(\"name\", name); file.save();}}}", blob, blob, blob));
        }
        sb.append("blobFieldsTracker.clear();}");
        CtMethod method = CtMethod.make((String)sb.toString(), (CtClass)ctClass);
        ctClass.addMethod(method);
        String blobList = StringUtil.join(",", blobs, true);
        sb = new StringBuilder("protected void deleteBlobs() { String[] blobs = {").append(blobList).append("}; removeGridFSFiles(\"").append(ctClass.getSimpleName()).append("\", getId(), blobs);}");
        method = CtMethod.make((String)sb.toString(), (CtClass)ctClass);
        ctClass.addMethod(method);
        sb = new StringBuilder("protected void deleteBlobsInBatch(play.modules.morphia.Model.MorphiaQuery q) { String[] blobs = {").append(blobList).append("}; removeGridFSFiles(q, blobs);}");
        method = CtMethod.make((String)sb.toString(), (CtClass)ctClass);
        ctClass.addMethod(method);
        sb = new StringBuilder("protected void loadBlobs() {");
        for (String blob : blobs) {
            sb.append(String.format("{String fileName = getBlobFileName(\"%s\"); Blob b = new Blob(fileName); if (b.exists()) {%s = b;} }", blob, blob));
        }
        sb.append("blobFieldsTracker.clear();}");
        method = CtMethod.make((String)sb.toString(), (CtClass)ctClass);
        ctClass.addMethod(method);
        for (String blob : blobs) {
            String setter = "set" + StringUtil.upperFirstChar(blob);
            CtMethod ctMethod = ctClass.getDeclaredMethod(setter);
            ctMethod.insertAfter(String.format("setBlobChanged(\"%s\");", blob));
        }
    }

    private Set<String> processFields(CtClass ctClass) throws NotFoundException, ClassNotFoundException {
        ArrayList<CtField> fields = new ArrayList<CtField>();
        fields.addAll(Arrays.asList(ctClass.getDeclaredFields()));
        fields.addAll(Arrays.asList(ctClass.getFields()));
        HashSet<String> blobs = new HashSet<String>();
        ArrayList<MemberValue> converterList = new ArrayList<MemberValue>();
        for (CtField cf : fields) {
            MemberValue value;
            Annotation uniqueMorhpia;
            Annotation uniquePlay;
            Annotation propA;
            Annotation colA;
            AnnotationsAttribute attr;
            block20: {
                MemberValue value2;
                Annotation a2;
                CtClass ctReturnType = cf.getType();
                if (ctReturnType != null && ctReturnType.getName().equals("play.modules.morphia.Blob") && cf.getDeclaringClass().getName().equals(ctClass.getName())) {
                    MorphiaEnhancer.createAnnotation((AnnotationsAttribute)MorphiaEnhancer.getAnnotations((CtField)cf), Transient.class);
                    blobs.add(cf.getName());
                    continue;
                }
                if (Modifier.isTransient((int)cf.getModifiers())) {
                    MorphiaEnhancer.createAnnotation((AnnotationsAttribute)MorphiaEnhancer.getAnnotations((CtField)cf), Transient.class);
                    continue;
                }
                if (Modifier.isStatic((int)cf.getModifiers())) continue;
                attr = MorphiaEnhancer.getAnnotations((CtField)cf);
                Annotation[] aa = attr.getAnnotations();
                colA = null;
                propA = null;
                uniquePlay = null;
                uniqueMorhpia = null;
                for (Annotation a2 : aa) {
                    if (a2.getTypeName().equals(Model.Column.class.getName())) {
                        colA = a2;
                        continue;
                    }
                    if (a2.getTypeName().equals(Property.class.getName())) {
                        propA = a2;
                        continue;
                    }
                    if (a2.getTypeName().equals(Unique.class.getName())) {
                        uniqueMorhpia = a2;
                        continue;
                    }
                    if (!a2.getTypeName().equals(play.data.validation.Unique.class.getName())) continue;
                    uniquePlay = a2;
                }
                do {
                    AnnotationsAttribute attrC;
                    CtClass fieldClass = cf.getType();
                    String fieldClassName = fieldClass.getName();
                    if (fieldClass.isPrimitive() || fieldClass.isArray()) break block20;
                    if (fieldClass.isFrozen()) {
                        fieldClass.defrost();
                    }
                    if (null == (a2 = (attrC = MorphiaEnhancer.getAnnotations((CtClass)fieldClass)).getAnnotation(Converters.class.getName()))) break block20;
                } while (null == (value2 = a2.getMemberValue("value")));
                ArrayMemberValue av = (ArrayMemberValue)value2;
                MemberValue[] va = av.getValue();
                converterList.addAll(Arrays.asList(va));
            }
            if (null == propA && null != colA) {
                value = colA.getMemberValue("value");
                MemberValue concreteClass = colA.getMemberValue("concreteClass");
                if (null == value && null == concreteClass) continue;
                propA = new Annotation(Property.class.getName(), ctClass.getClassFile().getConstPool());
                if (null != value) {
                    propA.addMemberValue("value", value);
                }
                if (null != concreteClass) {
                    propA.addMemberValue("concreteClass", concreteClass);
                }
                attr.addAnnotation(propA);
            }
            if (null == uniqueMorhpia && null != uniquePlay) {
                value = uniquePlay.getMemberValue("value");
                MemberValue message = uniquePlay.getMemberValue("message");
                uniqueMorhpia = new Annotation(Unique.class.getName(), ctClass.getClassFile().getConstPool());
                if (null != value) {
                    uniqueMorhpia.addMemberValue("value", value);
                }
                if (null != message) {
                    uniqueMorhpia.addMemberValue("message", message);
                }
                attr.addAnnotation(uniqueMorhpia);
            }
            if (null != uniquePlay) {
                Annotation[] anns = attr.getAnnotations();
                ArrayList<Annotation> newAnns = new ArrayList<Annotation>(anns.length - 1);
                for (Annotation ann : anns) {
                    if (ann.getTypeName().equals(play.data.validation.Unique.class.getName())) continue;
                    newAnns.add(ann);
                }
                attr.setAnnotations(newAnns.toArray(new Annotation[0]));
            }
            cf.getFieldInfo().addAttribute((AttributeInfo)attr);
        }
        if (!converterList.isEmpty()) {
            AnnotationsAttribute clsAttr = MorphiaEnhancer.getAnnotations((CtClass)ctClass);
            Annotation converters = clsAttr.getAnnotation(Converters.class.getName());
            if (null == converters) {
                converters = new Annotation(Converters.class.getName(), ctClass.getClassFile().getConstPool());
            } else {
                converterList.addAll(Arrays.asList(((ArrayMemberValue)converters.getMemberValue("value")).getValue()));
            }
            ArrayMemberValue amv = new ArrayMemberValue(ctClass.getClassFile().getConstPool());
            amv.setValue(converterList.toArray(new MemberValue[0]));
            converters.addMemberValue("value", (MemberValue)amv);
            clsAttr.addAnnotation(converters);
            ctClass.getClassFile().addAttribute((AttributeInfo)clsAttr);
        }
        return blobs;
    }

    private void addLifeCycleMethods(CtClass ctClass) throws Exception {
        for (CtMethod cm : ctClass.getMethods()) {
            this.enhanceLifeCycleMethods(ctClass, cm);
            this.enhanceLifeCycleBatchMethods(ctClass, cm);
        }
        for (CtMethod cm : ctClass.getDeclaredMethods()) {
            if (!Modifier.isPrivate((int)cm.getModifiers())) continue;
            this.enhanceLifeCycleMethods(ctClass, cm);
            this.enhanceLifeCycleBatchMethods(ctClass, cm);
        }
    }

    private void enhanceLifeCycleMethods(CtClass ctClass, CtMethod ctMethod) throws Exception {
        if (ctMethod.getParameterTypes().length > 0) {
            return;
        }
        if (ctMethod.getAnnotations().length == 0) {
            return;
        }
        if (!"void".equals(ctMethod.getReturnType().getName())) {
            return;
        }
        Class[] ca = new Class[]{Model.OnLoad.class, Model.Loaded.class, Model.OnAdd.class, Model.OnUpdate.class, Model.Added.class, Model.Updated.class, Model.OnDelete.class, Model.Deleted.class, Model.OnBatchDelete.class, Model.BatchDeleted.class};
        AnnotationsAttribute aa = MorphiaEnhancer.getAnnotations((CtMethod)ctMethod);
        for (Annotation a : aa.getAnnotations()) {
            for (Class c0 : ca) {
                String nm = c0.getName();
                if (!nm.equals(a.getTypeName())) continue;
                String mn = "h_" + c0.getSimpleName();
                CtMethod m0 = null;
                try {
                    m0 = ctClass.getDeclaredMethod(mn);
                }
                catch (Exception e) {
                    m0 = CtMethod.make((String)String.format("protected void %s(){}", mn, mn), (CtClass)ctClass);
                    ctClass.addMethod(m0);
                }
                String callback = ctMethod.getName();
                Logger.trace((String)"Adding callback[%s] to lifecycle event handler[%s]", (Object[])new Object[]{callback, mn});
                m0.insertAfter(String.format("%s();", callback));
            }
        }
    }

    private void enhanceLifeCycleBatchMethods(CtClass ctClass, CtMethod ctMethod) throws Exception {
        if (ctMethod.getAnnotations().length == 0) {
            return;
        }
        if (!"void".equals(ctMethod.getReturnType().getName())) {
            return;
        }
        CtClass[] params = ctMethod.getParameterTypes();
        if (params.length == 1) {
            CtClass p0 = params[0];
            if (!Model.MorphiaQuery.class.getName().equals(p0.getName())) {
                return;
            }
        } else {
            return;
        }
        Class[] ca = new Class[]{Model.OnBatchDelete.class, Model.BatchDeleted.class};
        AnnotationsAttribute aa = MorphiaEnhancer.getAnnotations((CtMethod)ctMethod);
        for (Annotation a : aa.getAnnotations()) {
            for (Class c0 : ca) {
                String nm = c0.getName();
                if (!nm.equals(a.getTypeName())) continue;
                String mn = "h_" + c0.getSimpleName();
                CtMethod m0 = null;
                try {
                    m0 = ctClass.getDeclaredMethod(mn);
                }
                catch (Exception e) {
                    m0 = CtMethod.make((String)String.format("protected void %s(play.modules.morphia.Model.MorphiaQuery q){}", mn), (CtClass)ctClass);
                    ctClass.addMethod(m0);
                }
                String callback = ctMethod.getName();
                Logger.trace((String)"Adding callback[%s] to lifecycle event handler[%s]", (Object[])new Object[]{callback, mn});
                m0.insertAfter(String.format("%s($$);", callback));
            }
        }
    }
}

