/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.PrePersist;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import play.modules.morphia.MorphiaPlugin;

@Entity(value="ids", noClassnameStored=true)
public class Seq {
    @Id
    final String id;
    protected Long value = 1L;

    @PrePersist
    void prePersist() {
        if (this.value != 1L) {
            throw new IllegalStateException("cannot save Seq");
        }
    }

    public Seq(String name) {
        this.id = name;
    }

    protected Seq() {
        this.id = "";
    }

    public Long getValue() {
        return this.value;
    }

    private int numdigits(long num) {
        if (num < 10L) {
            return 1;
        }
        int len = 0;
        while (num >= 10L) {
            num /= 10L;
            ++len;
        }
        return len;
    }

    public String getAsString(int digits) {
        return this.getAsString("", digits);
    }

    public String getAsString(String prefix, int digits) {
        StringBuilder sb = new StringBuilder(prefix);
        int mydigits = this.numdigits(this.value);
        if (digits < mydigits) {
            sb.append(this.value);
        } else {
            int delta = digits - mydigits;
            for (int i = 0; i < delta; ++i) {
                sb.append(0);
            }
            sb.append(this.value);
        }
        return sb.toString();
    }

    public static long nextValue() {
        return Seq.nextValue(Seq.class);
    }

    public static Seq next() {
        return Seq.next(Seq.class);
    }

    public static long nextValue(Class<?> clz) {
        return Seq.nextValue(clz.getName());
    }

    public static Seq next(Class<?> clz) {
        return Seq.next(clz.getName());
    }

    public static long nextValue(String name) {
        return Seq.next(name).getValue();
    }

    public static Seq next(String name) {
        UpdateOperations o;
        Query q;
        Datastore ds = MorphiaPlugin.ds();
        Seq newId = (Seq)ds.findAndModify(q = ds.find(Seq.class, "_id", (Object)name), o = ds.createUpdateOperations(Seq.class).inc("value"));
        if (null == newId) {
            newId = new Seq(name);
            ds.save((Object)newId);
        }
        return newId;
    }

    public static void initSelf() {
        Seq.init(Seq.class);
    }

    public static void init(String name) {
        Datastore ds = MorphiaPlugin.ds();
        Query q = ds.find(Seq.class, "_id", (Object)name);
        if (0L == q.countAll()) {
            Seq newId = new Seq(name);
            ds.save((Object)newId);
        }
    }

    public static void init(Class<?> clz) {
        Seq.init(clz.getName());
    }
}

