/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Key;
import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.PostLoad;
import com.google.code.morphia.annotations.PostPersist;
import com.google.code.morphia.annotations.PrePersist;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Transient;
import com.google.code.morphia.query.Criteria;
import com.google.code.morphia.query.CriteriaContainer;
import com.google.code.morphia.query.CriteriaContainerImpl;
import com.google.code.morphia.query.FieldEnd;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.QueryImpl;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.bson.types.CodeWScope;
import play.Logger;
import play.Play;
import play.data.binding.BeanWrapper;
import play.data.validation.Validation;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.morphia.MorphiaPlugin;
import play.modules.morphia.utils.IdGenerator;
import play.mvc.Scope;

public class Model
implements Serializable,
play.db.Model {
    private static final long serialVersionUID = -719759872826848048L;
    @Transient
    private transient boolean saved_ = false;

    public Object _key() {
        return this.getId();
    }

    public void _save() {
        this.save();
    }

    public void _delete() {
        Model.ds().delete((Object)this);
    }

    public static <T extends Model> T create(Class<?> type, String name, Map<String, String[]> params, Annotation[] annotations) {
        try {
            Constructor<?> c = type.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            Object model = c.newInstance(new Object[0]);
            return Model.edit(model, name, params, annotations);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Model> T edit(Object o, String name, Map<String, String[]> params, Annotation[] annotations) {
        try {
            BeanWrapper bw = new BeanWrapper(o.getClass());
            HashSet fields = new HashSet();
            Class<?> clazz = o.getClass();
            while (!clazz.equals(Object.class)) {
                Collections.addAll(fields, clazz.getDeclaredFields());
                clazz = clazz.getSuperclass();
            }
            for (Field field : fields) {
                boolean isEntity = false;
                String relation = null;
                boolean multiple = false;
                boolean isEmbedded = field.isAnnotationPresent(Embedded.class);
                if (isEmbedded || field.isAnnotationPresent(Reference.class)) {
                    Class<?>[] supers;
                    isEntity = true;
                    multiple = false;
                    Class<?> clz = field.getType();
                    for (Class<?> c : supers = clz.getInterfaces()) {
                        if (!c.equals(Collection.class)) continue;
                        multiple = true;
                        break;
                    }
                    String string = relation = multiple ? ((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]).getName() : clz.getName();
                }
                if (!isEntity) continue;
                Logger.debug((String)"loading relation: %1$s", (Object[])new Object[]{relation});
                Class c = Play.classloader.loadClass(relation);
                if (!Model.class.isAssignableFrom(c)) continue;
                String keyName = null;
                if (!isEmbedded) {
                    Model.Factory f = MorphiaPlugin.MorphiaModelLoader.getFactory(o.getClass());
                    keyName = f.keyName();
                }
                if (multiple && Collection.class.isAssignableFrom(field.getType())) {
                    AbstractCollection l = new ArrayList();
                    if (SortedSet.class.isAssignableFrom(field.getType())) {
                        l = new TreeSet();
                    } else if (Set.class.isAssignableFrom(field.getType())) {
                        l = new HashSet();
                    }
                    Logger.debug((String)"Collection intialized: %1$s", (Object[])new Object[]{l.getClass().getName()});
                    if (!isEmbedded) {
                        String[] ids = params.get(name + "." + field.getName() + "." + keyName);
                        if (ids != null) {
                            params.remove(name + "." + field.getName() + "." + keyName);
                            for (String _id : ids) {
                                if (_id.equals("")) continue;
                                Query q = Model.ds().createQuery(c).filter(keyName, Model.processId_(_id));
                                try {
                                    l.add(q.get());
                                }
                                catch (Exception e) {
                                    Validation.addError((String)(name + "." + field.getName()), (String)"validation.notFound", (String[])new String[]{_id});
                                }
                            }
                        }
                    } else {
                        Logger.debug((String)"multiple embedded objects not supported yet", (Object[])new Object[0]);
                    }
                    bw.set(field.getName(), o, (Object)l);
                    Logger.debug((String)"Entity[%1$s]'s field[%2$s] has been set to %3$s", (Object[])new Object[]{o.getClass().getName(), field.getName(), l});
                    continue;
                }
                String name0 = name + "." + field.getName();
                String name1 = name0 + "." + keyName;
                String[] ids = params.get(name1);
                if (ids != null && ids.length > 0 && !ids[0].equals("")) {
                    params.remove(name1);
                    Query q = Model.ds().createQuery(c).filter(keyName, Model.processId_(ids[0]));
                    try {
                        Object to = q.get();
                        bw.set(field.getName(), o, to);
                    }
                    catch (Exception e) {
                        Validation.addError((String)name0, (String)"validation.notFound", (String[])new String[]{ids[0]});
                    }
                    continue;
                }
                if (ids == null || ids.length <= 0 || !ids[0].equals("")) continue;
                bw.set(field.getName(), o, null);
                params.remove(name1);
            }
            bw.bind(name, o.getClass(), params, "", o, annotations);
            return (T)((Model)o);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public <T extends Model> T edit(String name, Map<String, String[]> params) {
        Model.edit(this, name, params, new Annotation[0]);
        return (T)this;
    }

    public boolean validateAndSave() {
        if (Validation.current().valid((Object)this).ok) {
            this.save();
            return true;
        }
        return false;
    }

    protected boolean isEmbedded_() {
        return false;
    }

    protected boolean isUserDefinedId_() {
        return false;
    }

    protected static Object processId_(Object id) {
        return IdGenerator.processId(id);
    }

    public Object getId() {
        return null;
    }

    public final void setId(Object id) {
        if (null != this.getId()) {
            throw new IllegalStateException("Cannot set ID to entity with ID presented");
        }
        this.setId_(id);
    }

    protected void setId_(Object id) {
        throw new UnsupportedOperationException("Please override this method for user marked Id field entity: " + this.getClass().getName());
    }

    @PrePersist
    private void generateId_() {
        if (this.isEmbedded_()) {
            return;
        }
        if (null == this.getId()) {
            if (this.isUserDefinedId_()) {
                throw new IllegalStateException("User defined ID should be populated before persist");
            }
            this.setId_(IdGenerator.generateId(this));
        }
    }

    public static Model.Factory getModelFactory() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public String toString() {
        String id = this.getId() == null ? "empty_key" : this.getId().toString();
        return this.getClass().getSimpleName() + "[" + id + "]";
    }

    public int hashCode() {
        Object oid = this.getId();
        return null == oid ? 0 : oid.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        Object oid = this.getId();
        if (oid == null) {
            return false;
        }
        return oid.equals(((Model)other).getId());
    }

    public final boolean isNew() {
        return !this.saved_;
    }

    @PostLoad
    @PostPersist
    private void setSaved_() {
        this.saved_ = true;
    }

    public <T extends Model> T merge() {
        return (T)this;
    }

    public <T extends Model> T refresh() {
        return (T)((Model)Model.ds().get((Object)this));
    }

    public static <T extends Model> MorphiaQuery all() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Model create(String name, Scope.Params params) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaQuery createQuery() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static long count() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static long count(String keys, Object ... params) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public <T extends Model> T delete() {
        this._delete();
        return (T)this;
    }

    public static long delete(MorphiaQuery query) {
        return query.delete();
    }

    public static long deleteAll() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaQuery find() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> MorphiaQuery find(String keys, Object ... params) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T> List<T> findAll() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> T findById(Object id) {
        throw new UnsupportedOperationException("Embedded entity does not support this method");
    }

    public static <T extends Model> MorphiaQuery filter(String property, Object value) {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static <T extends Model> T get() {
        throw new UnsupportedOperationException("Please annotate your model with @com.google.code.morphia.annotations.Entity annotation.");
    }

    public static Datastore ds() {
        return MorphiaPlugin.ds();
    }

    public static DB db() {
        return Model.ds().getDB();
    }

    public <T extends Model> T save() {
        Model.ds().save((Object)this);
        return (T)this;
    }

    public Key<? extends Model> save2() {
        return Model.ds().save((Object)this);
    }

    public long _getCreated() {
        throw new UnsupportedOperationException("Please annotate model with @AutoTimestamp annotation");
    }

    public long _getModified() {
        throw new UnsupportedOperationException("Please annotate model with @AutoTimestamp annotation");
    }

    public static class MorphiaQuery {
        private Query<? extends Model> q_;

        public static Datastore ds() {
            return MorphiaPlugin.ds();
        }

        public Query<? extends Model> getMorphiaQuery() {
            return this.q_;
        }

        private MorphiaQuery() {
        }

        public MorphiaQuery(Class<? extends Model> clazz) {
            this.q_ = MorphiaQuery.ds().createQuery(clazz);
        }

        public MorphiaQuery(Class<? extends Model> clazz, DBCollection coll, Datastore ds) {
            this.q_ = new QueryImpl(clazz, coll, ds);
        }

        public MorphiaQuery(Class<? extends Model> clazz, DBCollection coll, Datastore ds, int offset, int limit) {
            this.q_ = new QueryImpl(clazz, coll, ds, offset, limit);
        }

        public long delete() {
            long l = this.count();
            MorphiaQuery.ds().delete(this.q_);
            return l;
        }

        public long count() {
            return this.q_.countAll();
        }

        public MorphiaQuery findBy(String query, Object ... params) {
            if (null == query || params.length == 0) {
                throw new IllegalArgumentException("Invalid query or params");
            }
            String[] keys = query.split("And");
            if (params.length != 1 && keys.length != params.length) {
                throw new IllegalArgumentException("Query key number does not match the params number");
            }
            Object oneVal = params.length == 1 ? params[0] : null;
            for (int i = 0; i < keys.length; ++i) {
                StringBuilder sb = new StringBuilder(keys[i]);
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                this.q_.filter(sb.toString(), oneVal == null ? params[i] : oneVal);
            }
            return this;
        }

        public String toString() {
            return this.q_.toString();
        }

        public <T> T first() {
            return this.get();
        }

        public <T> MorphiaQuery from(int position) {
            this.q_.offset(position);
            return this;
        }

        public <T extends Model> List<T> fetchAll() {
            return this.q_.asList();
        }

        public <T extends Model> List<T> fetch(int max) {
            return this.q_.limit(max).asList();
        }

        public <T extends Model> List<T> fetch(int page, int length) {
            if (page < 1) {
                page = 1;
            }
            return this.q_.offset((page - 1) * length).limit(length).asList();
        }

        public Model _get() {
            return (Model)this.q_.get();
        }

        public <T extends Model> T get() {
            return (T)((Model)this.q_.get());
        }

        public <T extends Model> MorphiaQuery filter(String condition, Object value) {
            this.q_.filter(condition, value);
            return this;
        }

        public <T extends Model> Key<T> getKey() {
            return this.q_.getKey();
        }

        public <T extends Model> Iterator<T> iterator() {
            return this.q_.iterator();
        }

        public <T extends Model> List<T> asList() {
            return this.q_.asList();
        }

        public <T extends Model> List<Key<T>> asKeyList() {
            return this.q_.asKeyList();
        }

        public <T extends Model> Iterable<T> fetch() {
            return this.q_.fetch();
        }

        public <T extends Model> Iterable<T> fetchEmptyEntities() {
            return this.q_.fetchEmptyEntities();
        }

        public <T extends Model> FieldEnd<? extends Query<T>> field(String field) {
            return this.q_.field(field);
        }

        public <T extends Model> Iterable<Key<T>> fetchKeys() {
            return this.q_.fetchKeys();
        }

        public <T extends Model> FieldEnd<? extends CriteriaContainerImpl> criteria(String field) {
            return this.q_.criteria(field);
        }

        public <T extends Model> CriteriaContainer and(Criteria ... criteria) {
            return this.q_.and(criteria);
        }

        public long countAll() {
            return this.q_.countAll();
        }

        public <T extends Model> CriteriaContainer or(Criteria ... criteria) {
            return this.q_.or(criteria);
        }

        public <T extends Model> MorphiaQuery where(String js) {
            this.q_.where(js);
            return this;
        }

        public <T extends Model> MorphiaQuery where(CodeWScope js) {
            this.q_.where(js);
            return this;
        }

        public <T extends Model> MorphiaQuery order(String condition) {
            this.q_.order(condition);
            return this;
        }

        public <T extends Model> MorphiaQuery limit(int value) {
            this.q_.limit(value);
            return this;
        }

        public <T extends Model> MorphiaQuery batchSize(int value) {
            this.q_.batchSize(value);
            return this;
        }

        public <T extends Model> MorphiaQuery offset(int value) {
            this.q_.offset(value);
            return this;
        }

        @Deprecated
        public <T extends Model> MorphiaQuery skip(int value) {
            this.q_.skip(value);
            return this;
        }

        public <T extends Model> MorphiaQuery enableValidation() {
            this.q_.enableValidation();
            return this;
        }

        public <T extends Model> MorphiaQuery disableValidation() {
            this.q_.disableValidation();
            return this;
        }

        public <T extends Model> MorphiaQuery hintIndex(String idxName) {
            this.q_.hintIndex(idxName);
            return this;
        }

        public <T extends Model> MorphiaQuery retrievedFields(boolean include, String ... fields) {
            this.q_.retrievedFields(include, fields);
            return this;
        }

        public <T extends Model> MorphiaQuery enableSnapshotMode() {
            this.q_.enableSnapshotMode();
            return this;
        }

        public <T extends Model> MorphiaQuery disableSnapshotMode() {
            this.q_.disableSnapshotMode();
            return this;
        }

        public <T extends Model> MorphiaQuery queryNonPrimary() {
            this.q_.queryNonPrimary();
            return this;
        }

        public <T extends Model> MorphiaQuery queryPrimaryOnly() {
            this.q_.queryPrimaryOnly();
            return this;
        }

        public <T extends Model> MorphiaQuery disableTimeout() {
            this.q_.disableTimeout();
            return this;
        }

        public <T extends Model> MorphiaQuery enableTimeout() {
            this.q_.enableTimeout();
            return this;
        }

        public Class<? extends Model> getEntityClass() {
            return this.q_.getEntityClass();
        }

        public MorphiaQuery clone() {
            MorphiaQuery mq = new MorphiaQuery();
            mq.q_ = this.q_.clone();
            return mq;
        }
    }
}

