/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.converters;

import com.google.code.morphia.converters.SimpleValueConverter;
import com.google.code.morphia.converters.TypeConverter;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.MappingException;

public class BooleanConverter
extends TypeConverter
implements SimpleValueConverter {
    public BooleanConverter() {
        super(Boolean.TYPE, Boolean.class);
    }

    public Object decode(Class targetClass, Object val, MappedField optionalExtraInfo) throws MappingException {
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue() == 1.0;
        }
        String sVal = val.toString();
        return Boolean.parseBoolean(sVal);
    }
}

