/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.converters;

import com.google.code.morphia.converters.EnumConverter;
import com.google.code.morphia.converters.SimpleValueConverter;
import com.google.code.morphia.converters.TypeConverter;
import com.google.code.morphia.mapping.MappedField;
import com.google.code.morphia.mapping.MappingException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class EnumSetConverter
extends TypeConverter
implements SimpleValueConverter {
    private EnumConverter ec = new EnumConverter();

    public EnumSetConverter() {
        super(EnumSet.class);
    }

    public Object decode(Class targetClass, Object fromDBObject, MappedField optionalExtraInfo) throws MappingException {
        if (fromDBObject == null) {
            return null;
        }
        Class enumType = optionalExtraInfo.getSubClass();
        List l = (List)fromDBObject;
        if (l.isEmpty()) {
            return EnumSet.noneOf(enumType);
        }
        ArrayList<Object> enums = new ArrayList<Object>();
        for (Object object : l) {
            enums.add(this.ec.decode(enumType, object));
        }
        EnumSet copyOf = EnumSet.copyOf(enums);
        return copyOf;
    }

    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        EnumSet s = (EnumSet)value;
        Object[] array = s.toArray();
        for (int i = 0; i < array.length; ++i) {
            values.add(this.ec.encode(array[i]));
        }
        return values;
    }
}

