/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia;

import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.PrePersist;
import com.google.code.morphia.annotations.Transient;
import java.util.ArrayList;
import java.util.Arrays;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.annotation.Annotation;
import org.apache.commons.lang.StringUtils;
import play.Logger;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.modules.morphia.Model;
import play.modules.morphia.utils.IdGenerator;

public class MorphiaEnhancer
extends Enhancer {
    public static final String PACKAGE_NAME = "play.modules.morphia";

    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        this.enhanceThisClass_(applicationClass);
    }

    void enhanceThisClass_(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        boolean autoTS;
        boolean embedded;
        boolean addId;
        CtClass ctClass = this.makeClass(applicationClass);
        if (this.hasAnnotation(ctClass, Entity.class.getName()) && !this.hasAnnotation(ctClass, Model.ByPass.class.getName())) {
            addId = true;
            embedded = false;
            autoTS = this.hasAnnotation(ctClass, Model.AutoTimestamp.class.getName());
            if (this.hasAnnotation(ctClass, Embedded.class.getName())) {
                addId = false;
                embedded = true;
            } else if (this.hasAnnotation(ctClass, Model.NoId.class.getName())) {
                addId = false;
            } else {
                for (CtField cf : ctClass.getDeclaredFields()) {
                    if (!this.hasAnnotation(cf, Id.class.getName())) continue;
                    addId = false;
                    break;
                }
                for (CtField cf : ctClass.getFields()) {
                    if (!this.hasAnnotation(cf, Id.class.getName())) continue;
                    addId = false;
                    break;
                }
            }
        } else {
            return;
        }
        this.enhance_(ctClass, applicationClass, addId, embedded, autoTS);
    }

    private void enhance_(CtClass ctClass, ApplicationClasses.ApplicationClass applicationClass, boolean addId, boolean embedded, boolean autoTS) throws Exception {
        CtMethod findById;
        Logger.trace((String)("Morphia: enhancing MorphiaEntity: " + ctClass.getName()), (Object[])new Object[0]);
        this.classPool.importPackage(PACKAGE_NAME);
        String entityName = ctClass.getName();
        String className = entityName + ".class";
        CtField mf = CtField.make((String)("protected static play.db.Model.Factory mf = MorphiaPlugin.MorphiaModelLoader.getFactory(" + className + ");"), (CtClass)ctClass);
        ctClass.addField(mf);
        CtMethod getModelFactory = CtMethod.make((String)"public static play.db.Model.Factory getModelFactory() { return mf; }", (CtClass)ctClass);
        ctClass.addMethod(getModelFactory);
        if (addId) {
            Logger.trace((String)"Adding id methods to system managed ID entity: %1$s", (Object[])new Object[]{ctClass.getName()});
            Logger.trace((String)"type name: %1$s", (Object[])new Object[]{IdGenerator.getIdTypeName()});
            CtField idField = new CtField(this.classPool.get(IdGenerator.getIdTypeName()), "_id", ctClass);
            idField.setModifiers(2);
            AnnotationsAttribute aa = new AnnotationsAttribute(ctClass.getClassFile().getConstPool(), "RuntimeVisibleAnnotations");
            Annotation idAnn = new Annotation(Id.class.getName(), ctClass.getClassFile().getConstPool());
            aa.addAnnotation(idAnn);
            idField.getFieldInfo().addAttribute((AttributeInfo)aa);
            ctClass.addField(idField);
            Logger.trace((String)"ID field added to entity[%2$s]: %1$s", (Object[])new Object[]{idField.getSignature(), ctClass.getName()});
            CtMethod getId = CtMethod.make((String)"public Object getId() { return _id;}", (CtClass)ctClass);
            ctClass.addMethod(getId);
            CtMethod setId = CtMethod.make((String)("protected void setId_(Object id) { _id = (" + IdGenerator.getIdTypeName() + ")play.modules.morphia.utils.IdGenerator.processId(id);}"), (CtClass)ctClass);
            ctClass.addMethod(setId);
        } else if (!embedded) {
            Logger.trace((String)"adding id methods to user defined id entity: %1$s", (Object[])new Object[]{ctClass.getName()});
            boolean hasGetId = false;
            for (CtMethod cm : ctClass.getDeclaredMethods()) {
                if (!"getId".equals(cm.getName()) || !cm.getDeclaringClass().equals(ctClass)) continue;
                hasGetId = true;
                break;
            }
            if (!hasGetId) {
                CtMethod getId = CtMethod.make((String)"public Object getId() { return mf.keyValue(this);}", (CtClass)ctClass);
                ctClass.addMethod(getId);
            }
            CtMethod isUserDefinedId = CtMethod.make((String)"protected boolean isUserDefinedId_() {return super.isUserDefinedId_();}", (CtClass)ctClass);
            ctClass.addMethod(isUserDefinedId);
        } else {
            Logger.trace((String)"adding id methods to embedded entity: %1$s", (Object[])new Object[]{ctClass.getName()});
            CtMethod setId = CtMethod.make((String)"protected void setId_(Object id) {throw new UnsupportedOperationException(\"embedded object does not support this method\");}", (CtClass)ctClass);
            ctClass.addMethod(setId);
            CtMethod isEmbedded = CtMethod.make((String)"protected boolean isEmbedded_() {return true;}", (CtClass)ctClass);
            ctClass.addMethod(isEmbedded);
        }
        if (autoTS) {
            Logger.trace((String)"create timestamp fields automatically", (Object[])new Object[0]);
            CtField createdField = new CtField(CtClass.longType, "_created", ctClass);
            createdField.setModifiers(2);
            ctClass.addField(createdField);
            CtField modifiedField = new CtField(CtClass.longType, "_modified", ctClass);
            modifiedField.setModifiers(2);
            ctClass.addField(modifiedField);
            CtMethod persistTs = CtMethod.make((String)"void _updateTimestamp() { long now = System.currentTimeMillis(); if (0 == _created) {_created = now;} ;_modified = now;}", (CtClass)ctClass);
            AnnotationsAttribute aa = new AnnotationsAttribute(ctClass.getClassFile().getConstPool(), "RuntimeVisibleAnnotations");
            Annotation prePersistAnn = new Annotation(PrePersist.class.getName(), ctClass.getClassFile().getConstPool());
            aa.addAnnotation(prePersistAnn);
            persistTs.getMethodInfo().addAttribute((AttributeInfo)aa);
            ctClass.addMethod(persistTs);
            CtMethod getCreated = CtMethod.make((String)"public long _getCreated() { return _created; }", (CtClass)ctClass);
            ctClass.addMethod(getCreated);
            CtMethod getModified = CtMethod.make((String)"public long _getModified() { return _modified; }", (CtClass)ctClass);
            ctClass.addMethod(getModified);
        }
        CtMethod all = CtMethod.make((String)("public static play.modules.morphia.Model.MorphiaQuery all() { return new play.modules.morphia.Model.MorphiaQuery(" + className + "); }"), (CtClass)ctClass);
        ctClass.addMethod(all);
        CtMethod create = CtMethod.make((String)("public static play.modules.morphia.Model create(String name, play.mvc.Scope.Params params) { Object o = play.Play.classloader.loadClass(\"" + entityName + "\").newInstance(); return ((play.modules.morphia.Model)o).edit(name, params.all()); }"), (CtClass)ctClass);
        ctClass.addMethod(create);
        CtMethod createQuery = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery createQuery() { return all(); }", (CtClass)ctClass);
        ctClass.addMethod(createQuery);
        CtMethod q = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery q() { return all(); }", (CtClass)ctClass);
        ctClass.addMethod(q);
        CtMethod disableValidation = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery disableValidation() { return all().disableValidation(); }", (CtClass)ctClass);
        ctClass.addMethod(disableValidation);
        CtMethod find = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery find() { return all(); }", (CtClass)ctClass);
        ctClass.addMethod(find);
        CtMethod find2 = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery find(String keys, java.lang.Object[] params) { return createQuery().findBy(keys, params); }", (CtClass)ctClass);
        ctClass.addMethod(find2);
        CtMethod q2 = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery q(String keys, java.lang.Object value) { return createQuery().filter(keys, value); }", (CtClass)ctClass);
        ctClass.addMethod(q2);
        CtMethod findAll = CtMethod.make((String)"public static java.util.List findAll() {return all().asList();}", (CtClass)ctClass);
        ctClass.addMethod(findAll);
        CtMethod filter = CtMethod.make((String)"public static play.modules.morphia.Model.MorphiaQuery filter(String property, Object value) { return find().filter(property, value); }", (CtClass)ctClass);
        ctClass.addMethod(filter);
        CtMethod get = CtMethod.make((String)"public static Model get() { return find().get(); }", (CtClass)ctClass);
        ctClass.addMethod(get);
        if (addId) {
            findById = CtMethod.make((String)"public static Model findById(java.lang.Object id) { return filter(\"_id\", play.modules.morphia.utils.IdGenerator.processId(id))._get(); }", (CtClass)ctClass);
            ctClass.addMethod(findById);
        } else if (!embedded) {
            findById = CtMethod.make((String)"public static Model findById(java.lang.Object id) { return (Model)mf.findById(id); }", (CtClass)ctClass);
            ctClass.addMethod(findById);
        }
        CtMethod count = CtMethod.make((String)("public static long count() { return ds().getCount(" + className + "); }"), (CtClass)ctClass);
        ctClass.addMethod(count);
        CtMethod count2 = CtMethod.make((String)"public static long count(String keys, Object[] params) { return find(keys, params).count(); }", (CtClass)ctClass);
        ctClass.addMethod(count2);
        CtMethod distinct = CtMethod.make((String)String.format("public static java.util.Set _distinct(String key) {return new java.util.HashSet(ds().getCollection(%s).distinct(key));}", className), (CtClass)ctClass);
        ctClass.addMethod(distinct);
        CtMethod max = CtMethod.make((String)String.format("public static Long _max(String field) {return q().max(field);}", className), (CtClass)ctClass);
        ctClass.addMethod(max);
        CtMethod groupmax = CtMethod.make((String)String.format("public static AggregationResult groupMax(String field, String[] groupKeys) {return q().groupMax(field, groupKeys);}", className), (CtClass)ctClass);
        ctClass.addMethod(groupmax);
        CtMethod min = CtMethod.make((String)String.format("public static Long _min(String field) {return q().min(field);}", className), (CtClass)ctClass);
        ctClass.addMethod(min);
        CtMethod groupMin = CtMethod.make((String)String.format("public static AggregationResult groupMin(String field, String[] groupKeys) {return q().groupMin(field, groupKeys);}", className), (CtClass)ctClass);
        ctClass.addMethod(groupMin);
        CtMethod average = CtMethod.make((String)String.format("public static Long _average(String field) {return q().average(field);}", className), (CtClass)ctClass);
        ctClass.addMethod(average);
        CtMethod groupAverage = CtMethod.make((String)String.format("public static AggregationResult groupAverage(String field, String[] groupKeys) {return q().groupAverage(field, groupKeys);}", className), (CtClass)ctClass);
        ctClass.addMethod(groupAverage);
        CtMethod sum = CtMethod.make((String)String.format("public static Long _sum(String field) {return q().sum(field);}", className), (CtClass)ctClass);
        ctClass.addMethod(sum);
        CtMethod groupSum = CtMethod.make((String)String.format("public static AggregationResult groupSum(String field, String[] groupKeys) {return q().groupSum(field, groupKeys);}", className), (CtClass)ctClass);
        ctClass.addMethod(groupSum);
        CtMethod groupCount = CtMethod.make((String)String.format("public static AggregationResult groupCount(String field, String[] groupKeys) {return q().groupCount(field, groupKeys);}", className), (CtClass)ctClass);
        ctClass.addMethod(groupCount);
        CtMethod deleteAll = CtMethod.make((String)"public static long deleteAll() { return delete(all()); }", (CtClass)ctClass);
        ctClass.addMethod(deleteAll);
        this.addTransientAnnotationToAllBlobFields(ctClass);
        this.addGetterToAllBlobFields(ctClass);
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.detach();
    }

    private void addGetterToAllBlobFields(CtClass ctClass) throws CannotCompileException, NotFoundException {
        for (CtMethod method : ctClass.getMethods()) {
            boolean isGetter = method.getName().startsWith("get");
            boolean isReturningBlob = method.getReturnType().getName().equals("play.modules.morphia.Blob");
            if (!isGetter || !isReturningBlob) continue;
            String fieldName = method.getName().substring(3);
            Logger.debug((String)"Adding blob getter for field %s", (Object[])new Object[]{fieldName});
            String methodStr = String.format("public Blob %s() { return binaryFieldGet(\"%s\"); }", method.getName(), StringUtils.uncapitalize((String)fieldName), fieldName);
            CtMethod getMethod = CtMethod.make((String)methodStr, (CtClass)ctClass);
            getMethod.setModifiers(getMethod.getModifiers() | 0x1000);
            getMethod.setName(method.getName());
            ctClass.removeMethod(method);
            ctClass.addMethod(getMethod);
        }
    }

    private void addTransientAnnotationToAllBlobFields(CtClass ctClass) throws NotFoundException, ClassNotFoundException {
        ArrayList<CtField> fields = new ArrayList<CtField>();
        fields.addAll(Arrays.asList(ctClass.getDeclaredFields()));
        fields.addAll(Arrays.asList(ctClass.getFields()));
        for (CtField cf : fields) {
            CtClass ctReturnType = cf.getType();
            if (ctReturnType == null || !ctReturnType.getName().equals("play.modules.morphia.Blob") || this.hasAnnotation(cf, Transient.class.getName())) continue;
            MorphiaEnhancer.createAnnotation((AnnotationsAttribute)MorphiaEnhancer.getAnnotations((CtField)cf), Transient.class);
        }
    }
}

