/*
 * Decompiled with CFR 0.152.
 */
package play.modules.morphia;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.annotations.Embedded;
import com.google.code.morphia.annotations.Entity;
import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Transient;
import com.google.code.morphia.mapping.validation.ConstraintViolationException;
import com.google.code.morphia.query.Criteria;
import com.google.code.morphia.query.Query;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.gridfs.GridFS;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bson.types.ObjectId;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.data.binding.Binder;
import play.db.Model;
import play.exceptions.ConfigurationException;
import play.exceptions.UnexpectedException;
import play.modules.morphia.Blob;
import play.modules.morphia.Model;
import play.modules.morphia.MorphiaEnhancer;
import play.modules.morphia.utils.StringUtil;

public class MorphiaPlugin
extends PlayPlugin {
    public static final String VERSION = "1.2.3beta1";
    public static final String PREFIX = "morphia.db.";
    private MorphiaEnhancer e_ = new MorphiaEnhancer();
    private static Morphia morphia_ = null;
    private static Datastore ds_ = null;
    private static GridFS gridfs;
    private static boolean configured_;
    private static IdType idType_;
    private static final ConcurrentMap<String, Datastore> dataStores_;
    private static Mongo mongo_;

    private static String msg_(String msg, Object ... args) {
        return String.format("MorphiaPlugin-1.2.3beta1> %1$s", String.format(msg, args));
    }

    public static boolean configured() {
        return configured_;
    }

    public static IdType getIdType() {
        return idType_;
    }

    public static Datastore ds() {
        return ds_;
    }

    public static GridFS gridFs() {
        return gridfs;
    }

    public static Datastore ds(String dbName) {
        Datastore ds0;
        if (StringUtil.isEmpty(dbName)) {
            return MorphiaPlugin.ds();
        }
        Datastore ds = (Datastore)dataStores_.get(dbName);
        if (null == ds && null == (ds = dataStores_.putIfAbsent(dbName, ds0 = morphia_.createDatastore(mongo_, dbName)))) {
            ds = ds0;
        }
        return ds;
    }

    public static Morphia morphia() {
        return morphia_;
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        this.onConfigurationRead();
        this.e_.enhanceThisClass(applicationClass);
    }

    private final Mongo connect_(String host, String port) {
        String[] pa;
        String[] ha = host.split("[,\\s;]+");
        int len = ha.length;
        if (len != (pa = port.split("[,\\s;]+")).length) {
            throw new ConfigurationException("host and ports number does not match");
        }
        if (1 == len) {
            try {
                return new Mongo(ha[0], Integer.parseInt(pa[0]));
            }
            catch (Exception e) {
                throw new ConfigurationException(String.format("Cannot connect to mongodb at %s:%s", host, port));
            }
        }
        ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>(ha.length);
        for (int i = 0; i < len; ++i) {
            try {
                addrs.add(new ServerAddress(ha[i], Integer.parseInt(pa[i])));
                continue;
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)"Error creating mongo connection to %s:%s", (Object[])new Object[]{host, port});
            }
        }
        if (addrs.isEmpty()) {
            throw new ConfigurationException("Cannot connect to mongodb: no replica can be connected");
        }
        return new Mongo(addrs);
    }

    private final Mongo connect_(String seeds) {
        String[] sa = seeds.split("[;,\\s]+");
        ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>(sa.length);
        for (String s : sa) {
            String[] hp = s.split(":");
            if (0 == hp.length) continue;
            String host = hp[0];
            int port = 27017;
            if (hp.length > 1) {
                port = Integer.parseInt(hp[1]);
            }
            try {
                addrs.add(new ServerAddress(host, port));
            }
            catch (UnknownHostException e) {
                Logger.error((Throwable)e, (String)"error creating mongo connection to %s:%s", (Object[])new Object[]{host, port});
            }
        }
        if (addrs.isEmpty()) {
            throw new ConfigurationException("Cannot connect to mongodb: no replica can be connected");
        }
        return new Mongo(addrs);
    }

    public void onConfigurationRead() {
        String password;
        String username;
        if (configured_) {
            return;
        }
        Logger.trace((String)"Morphia> reading configuration", (Object[])new Object[0]);
        Properties c = Play.configuration;
        String seeds = c.getProperty("morphia.db.seeds");
        if (!StringUtil.isEmpty(seeds)) {
            mongo_ = this.connect_(seeds);
        } else {
            String host = c.getProperty("morphia.db.host", "localhost");
            String port = c.getProperty("morphia.db.port", "27017");
            mongo_ = this.connect_(host, port);
        }
        String dbName = c.getProperty("morphia.db.name");
        if (null == dbName) {
            Logger.warn((String)"mongodb name not configured! using [test] db", (Object[])new Object[0]);
            dbName = "test";
        }
        DB db = mongo_.getDB(dbName);
        if (c.containsKey("morphia.db.username") && c.containsKey("morphia.db.password") && !db.authenticate(username = c.getProperty("morphia.db.username"), (password = c.getProperty("morphia.db.password")).toCharArray())) {
            throw new RuntimeException("MongoDB authentication failed: " + dbName);
        }
        if (c.containsKey("morphia.id.type")) {
            Logger.debug((String)"Morphia> reading id type...", (Object[])new Object[0]);
            String s = c.getProperty("morphia.id.type");
            try {
                idType_ = IdType.valueOf(s);
                Logger.debug((String)"ID Type set to : %1$s", (Object[])new Object[]{idType_.name()});
                if ("1.2beta".equals(VERSION) && idType_ == IdType.Long) {
                    Logger.warn((String)"Caution: Using reference in your model entities might cause problem when you ID type set to Long. Check http://groups.google.com/group/morphia/browse_thread/thread/bdd51121c2845973", (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                Logger.warn((Throwable)e, (String)"Error configure morphia id type: %1$s. Id type set to default: ObjectId.", (Object[])new Object[]{s});
            }
        }
        morphia_ = new Morphia();
        ds_ = morphia_.createDatastore(mongo_, dbName);
        dataStores_.put(dbName, ds_);
        String uploadCollection = c.getProperty("morphia.db.collection.upload", "uploads");
        gridfs = new GridFS(MorphiaPlugin.ds().getDB(), uploadCollection);
        configured_ = true;
    }

    public void onApplicationStart() {
        configured_ = false;
        this.onConfigurationRead();
        this.configureDs_();
        Logger.info((String)MorphiaPlugin.msg_("loaded", new Object[0]), (Object[])new Object[0]);
    }

    public void onInvocationException(Throwable e) {
        if (e instanceof MongoException.Network) {
            Logger.error((String)"MongoException.Network encountered. Trying to restart mongo...", (Object[])new Object[0]);
            configured_ = false;
            this.onConfigurationRead();
        }
    }

    private void configureDs_() {
        ArrayList<Class> pending = new ArrayList<Class>();
        HashMap<Class, Integer> retries = new HashMap<Class, Integer>();
        List cs = Play.classes.all();
        for (ApplicationClasses.ApplicationClass c : cs) {
            Class clz = c.javaClass;
            if (!clz.isAnnotationPresent(Entity.class)) continue;
            try {
                Logger.debug((String)">> mapping class: %1$s", (Object[])new Object[]{clz.getName()});
                morphia_.map(clz);
            }
            catch (ConstraintViolationException e) {
                Logger.error((Throwable)e, (String)"error mapping class [%1$s]", (Object[])new Object[]{clz});
                pending.add(clz);
                retries.put(clz, 1);
            }
        }
        while (!pending.isEmpty()) {
            for (Class clz : pending) {
                try {
                    Logger.trace((String)">> mapping class: ", (Object[])new Object[]{clz.getName()});
                    morphia_.map(clz);
                    pending.remove(clz);
                }
                catch (ConstraintViolationException e) {
                    Logger.error((Throwable)e, (String)"error mapping class [%1$s]", (Object[])new Object[]{clz});
                    int retry = (Integer)retries.get(clz);
                    if (retry > 2) {
                        throw new RuntimeException("too many errories mapping Morphia Entity classes");
                    }
                    retries.put(clz, (Integer)retries.get(clz) + 1);
                }
            }
        }
        MorphiaPlugin.ds().ensureIndexes();
        String writeConcern = Play.configuration.getProperty("morphia.defaultWriteConcern", "safe");
        if (null != writeConcern) {
            MorphiaPlugin.ds().setDefaultWriteConcern(WriteConcern.valueOf((String)writeConcern.toUpperCase()));
        }
        Logger.info((String)MorphiaPlugin.msg_("initialized", new Object[0]), (Object[])new Object[0]);
    }

    public Object bind(String name, Class clazz, Type type, Annotation[] annotations, Map<String, String[]> params) {
        if (Model.class.isAssignableFrom(clazz)) {
            String keyName = this.modelFactory(clazz).keyName();
            String idKey = name + "." + keyName;
            if (params.containsKey(idKey) && params.get(idKey).length > 0 && params.get(idKey)[0] != null && params.get(idKey)[0].trim().length() > 0) {
                String id = params.get(idKey)[0];
                try {
                    Object o = MorphiaPlugin.ds().createQuery(clazz).filter(keyName, (Object)new ObjectId(id)).get();
                    return Model.edit(o, name, params, annotations);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return Model.create(clazz, name, params, annotations);
        }
        return super.bind(name, clazz, type, annotations, params);
    }

    public Object bind(String name, Object o, Map<String, String[]> params) {
        if (o instanceof Model) {
            return Model.edit(o, name, params, null);
        }
        return null;
    }

    public Model.Factory modelFactory(Class<? extends play.db.Model> modelClass) {
        if (Model.class.isAssignableFrom(modelClass) && modelClass.isAnnotationPresent(Entity.class)) {
            return MorphiaModelLoader.getFactory(modelClass);
        }
        return null;
    }

    static {
        configured_ = false;
        idType_ = IdType.ObjectId;
        dataStores_ = new ConcurrentHashMap<String, Datastore>();
    }

    public static class MorphiaModelLoader
    implements Model.Factory {
        private static Map<Class<? extends Model>, Model.Factory> m_ = new HashMap<Class<? extends Model>, Model.Factory>();
        private Class<? extends Model> clazz;

        private MorphiaModelLoader(Class<? extends Model> clazz) {
            this.clazz = clazz;
            m_.put(clazz, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Model.Factory getFactory(Class<? extends Model> clazz) {
            Map<Class<? extends Model>, Model.Factory> map = m_;
            synchronized (map) {
                Model.Factory f = m_.get(clazz);
                if (null == f) {
                    f = new MorphiaModelLoader(clazz);
                }
                return f;
            }
        }

        public Model findById(Object id) {
            if (id == null) {
                return null;
            }
            try {
                return (Model)MorphiaPlugin.ds().find(this.clazz, this.keyName(), Binder.directBind((String)id.toString(), this.keyType())).get();
            }
            catch (Exception e) {
                Logger.debug((Throwable)e, (String)"cannot find entity[%s] with id: %s", (Object[])new Object[]{this.clazz.getName(), id});
                return null;
            }
        }

        public List<play.db.Model> fetch(int offset, int size, String orderBy, String order, List<String> searchFields, String keywords, String where) {
            if (orderBy == null) {
                orderBy = this.keyName();
            }
            if ("DESC".equalsIgnoreCase(order)) {
                orderBy = null == orderBy ? null : "-" + orderBy;
            }
            Query q = MorphiaPlugin.ds().createQuery(this.clazz).offset(offset).limit(size);
            if (null != orderBy) {
                q = q.order(orderBy);
            }
            if (keywords != null && !keywords.equals("")) {
                ArrayList<Object> cl = new ArrayList<Object>();
                for (String f : this.fillSearchFieldsIfEmpty_(searchFields)) {
                    cl.add(q.criteria(f).contains(keywords));
                }
                q.or(cl.toArray(new Criteria[0]));
            }
            MorphiaModelLoader.processWhere(q, where);
            ArrayList<play.db.Model> l = new ArrayList<play.db.Model>();
            l.addAll(q.asList());
            return l;
        }

        private List<String> fillSearchFieldsIfEmpty_(List<String> l) {
            if (l == null) {
                l = new ArrayList<String>();
            }
            if (l.isEmpty()) {
                MorphiaModelLoader.listAllSearchableFields_(this.clazz, l, null);
            }
            return l;
        }

        public Long count(List<String> searchFields, String keywords, String where) {
            Query q = MorphiaPlugin.ds().createQuery(this.clazz);
            if (keywords != null && !keywords.equals("")) {
                ArrayList<Object> cl = new ArrayList<Object>();
                for (String f : this.fillSearchFieldsIfEmpty_(searchFields)) {
                    cl.add(q.criteria(f).contains(keywords));
                }
                q.or(cl.toArray(new Criteria[0]));
            }
            MorphiaModelLoader.processWhere(q, where);
            return q.countAll();
        }

        public static void processWhere(Query<?> q, String where) {
            String[] propValPairs;
            if ("".equals(where = null != where ? where.trim() : "") || "null".equalsIgnoreCase(where)) {
                return;
            }
            if (where.startsWith("function")) {
                q.where(where);
                return;
            }
            for (String propVal : propValPairs = where.split("(and|&&)")) {
                String prop;
                String[] sa;
                if (propVal.contains("=")) {
                    sa = propVal.split("=");
                    if (sa.length != 2) {
                        throw new IllegalArgumentException("invalid where clause: " + where);
                    }
                    prop = sa[0];
                    String val = sa[1];
                    Logger.trace((String)"where prop val pair found: %1$s = %2$s", (Object[])new Object[]{prop, val});
                    prop = prop.replaceAll("[\"' ]", "");
                    if (val.matches("[\"'].*[\"']")) {
                        val = val.replaceAll("[\"' ]", "");
                        q.filter(prop, (Object)val);
                        continue;
                    }
                    if (val.matches("[-+]?\\d+\\.\\d+")) {
                        q.filter(prop, (Object)Float.valueOf(Float.parseFloat(val)));
                        continue;
                    }
                    if (val.matches("[-+]?\\d+")) {
                        q.filter(prop, (Object)Integer.parseInt(val));
                        continue;
                    }
                    if (val.matches("(false|true|FALSE|TRUE|False|True)")) {
                        q.filter(prop, (Object)Boolean.parseBoolean(val));
                        continue;
                    }
                    q.filter(prop, (Object)val);
                    continue;
                }
                if (propVal.contains(" in ")) {
                    sa = propVal.split(" in ");
                    if (sa.length != 2) {
                        throw new IllegalArgumentException("invalid where clause: " + where);
                    }
                    prop = sa[0].trim();
                    String val0 = sa[1].trim();
                    if (!val0.matches("\\(.*\\)")) {
                        throw new IllegalArgumentException("invalid where clause: " + where);
                    }
                    val0 = val0.replaceAll("[\\(\\)]", "");
                    String[] vals = val0.split(",");
                    ArrayList<Object> l = new ArrayList<Object>();
                    for (String val : vals) {
                        if (val.matches("[-+]?\\d+\\.\\d+")) {
                            l.add(Float.valueOf(Float.parseFloat(val)));
                            continue;
                        }
                        if (val.matches("[-+]?\\d+")) {
                            l.add(Integer.parseInt(val));
                            continue;
                        }
                        if (val.matches("(false|true|FALSE|TRUE|False|True)")) {
                            l.add(Boolean.parseBoolean(val));
                            continue;
                        }
                        l.add(val);
                    }
                    q.filter(prop + " in ", l);
                    continue;
                }
                throw new IllegalArgumentException("invalid where clause: " + where);
            }
        }

        public void deleteAll() {
            MorphiaPlugin.ds().delete(MorphiaPlugin.ds().createQuery(this.clazz));
        }

        public List<Model.Property> listProperties() {
            ArrayList<Model.Property> properties = new ArrayList<Model.Property>();
            HashSet fields = new HashSet();
            Class<? extends Model> tclazz = this.clazz;
            while (!tclazz.equals(Object.class)) {
                Collections.addAll(fields, tclazz.getDeclaredFields());
                tclazz = tclazz.getSuperclass();
            }
            for (Field f : fields) {
                Model.Property mp;
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Transient.class) && !f.getType().equals(Blob.class) || (mp = this.buildProperty(f)) == null) continue;
                properties.add(mp);
            }
            return properties;
        }

        private static void listAllSearchableFields_(Class<?> clazz, List<String> l, String prefix) {
            HashSet fields = new HashSet();
            Class<?> tclazz = clazz;
            while (!tclazz.equals(Object.class)) {
                Collections.addAll(fields, tclazz.getDeclaredFields());
                tclazz = tclazz.getSuperclass();
            }
            for (Field f : fields) {
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(Transient.class)) continue;
                if (f.isAnnotationPresent(Embedded.class)) {
                    if (Collection.class.isAssignableFrom(f.getType())) {
                        Class fieldType = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0];
                        if (!fieldType.isAnnotationPresent(Embedded.class)) continue;
                        MorphiaModelLoader.listAllSearchableFields_(fieldType, l, null == prefix ? f.getName() + "." : prefix + f.getName() + ".");
                        continue;
                    }
                    if (Map.class.isAssignableFrom(f.getType())) continue;
                    MorphiaModelLoader.listAllSearchableFields_(f.getType(), l, null == prefix ? f.getName() + "." : prefix + f.getName() + ".");
                    continue;
                }
                if (!f.getType().equals(String.class)) continue;
                l.add(prefix == null ? f.getName() : prefix + f.getName());
            }
        }

        public String keyName() {
            Field f = this.keyField();
            return f == null ? null : f.getName();
        }

        public Class<?> keyType() {
            return this.keyField().getType();
        }

        public Object keyValue(play.db.Model m) {
            Field k = this.keyField();
            try {
                return null != k ? k.get(m) : null;
            }
            catch (Exception ex) {
                throw new UnexpectedException((Throwable)ex);
            }
        }

        Field keyField() {
            Class<? extends Model> c = this.clazz;
            try {
                while (!c.equals(Object.class)) {
                    for (Field field : c.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(Id.class)) continue;
                        field.setAccessible(true);
                        return field;
                    }
                    c = c.getSuperclass();
                }
            }
            catch (Exception e) {
                throw new UnexpectedException("Error while determining the object @Id for an object of type " + c);
            }
            return null;
        }

        Model.Property buildProperty(final Field field) {
            Model.Property modelProperty = new Model.Property();
            modelProperty.type = field.getType();
            modelProperty.field = field;
            if (Model.class.isAssignableFrom(field.getType())) {
                if (field.isAnnotationPresent(Embedded.class)) {
                    modelProperty.isRelation = true;
                    modelProperty.relationType = field.getType();
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            return Collections.EMPTY_LIST;
                        }
                    };
                }
                if (field.isAnnotationPresent(Reference.class)) {
                    modelProperty.isRelation = true;
                    modelProperty.relationType = field.getType();
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            return MorphiaPlugin.ds().createQuery(field.getType()).asList();
                        }
                    };
                }
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                final Class fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                if (field.isAnnotationPresent(Reference.class)) {
                    modelProperty.isRelation = true;
                    modelProperty.isMultiple = true;
                    modelProperty.relationType = fieldType;
                    modelProperty.choices = new Model.Choices(){

                        public List<Object> list() {
                            return MorphiaPlugin.ds().createQuery(fieldType).asList();
                        }
                    };
                }
            }
            modelProperty.name = field.getName();
            if (field.getType().equals(String.class)) {
                modelProperty.isSearchable = true;
            }
            return modelProperty;
        }
    }

    public static enum IdType {
        Long,
        ObjectId;

    }
}

