/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceCommand {
    final String _input;
    final String _map;
    final String _reduce;
    final String _outputTarget;
    String _outputDB = null;
    final OutputType _outputType;
    final DBObject _query;
    String _finalize;
    DBObject _sort;
    int _limit;
    Map<String, Object> _scope;
    Boolean _verbose = true;

    public MapReduceCommand(DBCollection inputCollection, String map, String reduce, String outputCollection, OutputType type, DBObject query) throws MongoException {
        this._input = inputCollection.getName();
        this._map = map;
        this._reduce = reduce;
        this._outputTarget = outputCollection;
        this._outputType = type;
        this._query = query;
    }

    public void setVerbose(Boolean verbose) {
        this._verbose = verbose;
    }

    public Boolean isVerbose() {
        return this._verbose;
    }

    public String getInput() {
        return this._input;
    }

    public String getMap() {
        return this._map;
    }

    public String getReduce() {
        return this._reduce;
    }

    public String getOutputTarget() {
        return this._outputTarget;
    }

    public OutputType getOutputType() {
        return this._outputType;
    }

    public String getFinalize() {
        return this._finalize;
    }

    public void setFinalize(String finalize) {
        this._finalize = finalize;
    }

    public DBObject getQuery() {
        return this._query;
    }

    public DBObject getSort() {
        return this._sort;
    }

    public void setSort(DBObject sort) {
        this._sort = sort;
    }

    public int getLimit() {
        return this._limit;
    }

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public Map<String, Object> getScope() {
        return this._scope;
    }

    public void setScope(Map<String, Object> scope) {
        this._scope = scope;
    }

    public void setOutputDB(String outputDB) {
        this._outputDB = outputDB;
    }

    public DBObject toDBObject() {
        BasicDBObjectBuilder builder = BasicDBObjectBuilder.start();
        builder.add("mapreduce", this._input).add("map", this._map).add("reduce", this._reduce).add("verbose", this._verbose);
        if (this._outputType == OutputType.REPLACE && this._outputDB == null) {
            builder.add("out", this._outputTarget);
        } else {
            BasicDBObject out = new BasicDBObject();
            switch (this._outputType) {
                case INLINE: {
                    out.put("inline", (Object)1);
                    break;
                }
                case REPLACE: {
                    out.put("replace", (Object)this._outputTarget);
                    break;
                }
                case MERGE: {
                    out.put("merge", (Object)this._outputTarget);
                    break;
                }
                case REDUCE: {
                    out.put("reduce", (Object)this._outputTarget);
                }
            }
            if (this._outputDB != null) {
                out.put("db", (Object)this._outputDB);
            }
            builder.add("out", out);
        }
        if (this._query != null) {
            builder.add("query", this._query);
        }
        if (this._finalize != null) {
            builder.add("finalize", this._finalize);
        }
        if (this._sort != null) {
            builder.add("sort", this._sort);
        }
        if (this._limit > 0) {
            builder.add("limit", this._limit);
        }
        if (this._scope != null) {
            builder.add("scope", this._scope);
        }
        return builder.get();
    }

    public String toString() {
        return this.toDBObject().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputType {
        REPLACE,
        MERGE,
        REDUCE,
        INLINE;

    }
}

