/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.morphia.mapping.validation.classrules;

import com.google.code.morphia.annotations.Id;
import com.google.code.morphia.annotations.Reference;
import com.google.code.morphia.annotations.Transient;
import com.google.code.morphia.mapping.MappedClass;
import com.google.code.morphia.mapping.validation.ClassConstraint;
import com.google.code.morphia.mapping.validation.ConstraintViolation;
import com.google.code.morphia.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainsEmbeddedWithId
implements ClassConstraint {
    private boolean hasTypeFieldAnnotation(Class<?> type, Class<Id> class1) {
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(type, true)) {
            if (field.getAnnotation(class1) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void check(MappedClass mc, Set<ConstraintViolation> ve) {
        HashSet classesToInspect = new HashSet();
        for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(mc.getClazz(), true)) {
            if (!this.isFieldToInspect(field) || field.isAnnotationPresent(Id.class)) continue;
            classesToInspect.add(field.getType());
        }
        this.checkRecursivelyHasNoIdAnnotationPresent(classesToInspect, new HashSet(), mc, ve);
    }

    private boolean isFieldToInspect(Field field) {
        return !field.isAnnotationPresent(Transient.class) && !field.isAnnotationPresent(Reference.class);
    }

    private void checkRecursivelyHasNoIdAnnotationPresent(Set<Class<?>> classesToInspect, HashSet<Class<?>> alreadyInspectedClasses, MappedClass mc, Set<ConstraintViolation> ve) {
        for (Class<?> clazz : classesToInspect) {
            if (alreadyInspectedClasses.contains(clazz)) continue;
            if (this.hasTypeFieldAnnotation(clazz, Id.class)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, this.getClass(), "You cannot use @Id on any field of an Embedded/Property object"));
            }
            alreadyInspectedClasses.add(clazz);
            HashSet extraClassesToInspect = new HashSet();
            for (Field field : ReflectionUtils.getDeclaredAndInheritedFields(clazz, true)) {
                if (!this.isFieldToInspect(field)) continue;
                extraClassesToInspect.add(field.getType());
            }
            this.checkRecursivelyHasNoIdAnnotationPresent(extraClassesToInspect, alreadyInspectedClasses, mc, ve);
        }
    }
}

